/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.admin;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ehrbase.api.audit.msg.AuditMsgBuilder;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.openehr.sdk.response.dto.admin.AdminDeleteResponseData;
import org.ehrbase.openehr.sdk.response.dto.admin.AdminUpdateResponseData;
import org.ehrbase.rest.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnMissingBean(name={"primaryadminehrcontroller"})
@ConditionalOnProperty(prefix="admin-api", name={"active"})
@Tag(name="Admin - EHR")
@RestController
@RequestMapping(path={"${admin-api.context-path:/rest/admin}/ehr"}, produces={"application/json", "application/xml"})
public class AdminEhrController
extends BaseController {
    private final EhrService ehrService;

    @Autowired
    public AdminEhrController(EhrService ehrService) {
        this.ehrService = ehrService;
    }

    @PutMapping(path={"/{ehr_id}"}, consumes={"application/json", "application/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="EHR has been updated and number of updated items will be returned in the body.", headers={@Header(name="Content-Type", description="Format of response", schema=@Schema(implementation=MediaType.class))}), @ApiResponse(responseCode="401", description="Client credentials are invalid or have been expired."), @ApiResponse(responseCode="403", description="Client is not permitted to access this resource since the admin role is missing."), @ApiResponse(responseCode="404", description="EHR with id could not be found.")})
    public ResponseEntity<AdminUpdateResponseData> updateEhr(@Parameter(description="Client requested response content type") @RequestHeader(value="Accept", required=false) String accept, @Parameter(description="Target EHR id to update", required=true) @PathVariable(value="ehr_id") String ehrId) {
        UUID ehrUuid = UUID.fromString(ehrId);
        if (!this.ehrService.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("Admin EHR", String.format("EHR with id %s does not exist.", ehrId));
        }
        AuditMsgBuilder.getInstance().setEhrIds(new Object[]{ehrUuid});
        return ResponseEntity.ok().body((Object)new AdminUpdateResponseData(0));
    }

    @DeleteMapping(path={"/{ehr_id}"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="EHR has been deleted successfully"), @ApiResponse(responseCode="401", description="Client credentials are invalid or have been expired."), @ApiResponse(responseCode="403", description="Client is not permitted to access this resource since the admin role is missing."), @ApiResponse(responseCode="404", description="EHR with id could not be found.")})
    public ResponseEntity<AdminDeleteResponseData> deleteEhr(@Parameter(description="Target EHR id to delete", required=true) @PathVariable(value="ehr_id") String ehrId) {
        UUID ehrUuid = UUID.fromString(ehrId);
        if (!this.ehrService.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("Admin EHR", String.format("EHR with id %s does not exist.", ehrId));
        }
        AuditMsgBuilder.getInstance().setEhrIds(new Object[]{ehrUuid}).setRemovedPatients(this.getPatientNumbers(ehrUuid));
        this.ehrService.adminDeleteEhr(ehrUuid);
        return ResponseEntity.noContent().build();
    }

    private Set<String> getPatientNumbers(Object ... ehrs) {
        return Arrays.stream(ehrs).map(ehrId -> this.ehrService.getSubjectExtRef(ehrId.toString())).collect(Collectors.toSet());
    }
}

