/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.audit.msg.AuditMsgBuilder;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.DirectoryService;
import org.ehrbase.openehr.sdk.response.dto.DirectoryResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.DirectoryApiSpecification;
import org.joda.time.DateTime;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrdirectorycontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr"})
public class OpenehrDirectoryController
extends BaseController
implements DirectoryApiSpecification {
    private final DirectoryService directoryService;

    public OpenehrDirectoryController(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    @Override
    @PostMapping(path={"/{ehr_id}/directory"})
    public ResponseEntity<DirectoryResponseData> createDirectory(@PathVariable(name="ehr_id") UUID ehrId, @RequestHeader(name="openEHR-VERSION", required=false) String openEhrVersion, @RequestHeader(name="openEHR-AUDIT_DETAILS", required=false) String openEhrAuditDetails, @RequestHeader(name="Content-Type") String contentType, @RequestHeader(name="Accept", defaultValue="application/json") String accept, @RequestHeader(name="Prefer", defaultValue="return=minimal") String prefer, @RequestBody Folder folder) {
        Folder createdFolder = this.directoryService.create(ehrId, folder);
        return this.createDirectoryResponse(HttpMethod.POST, prefer, accept, createdFolder, ehrId);
    }

    @Override
    @PutMapping(path={"/{ehr_id}/directory"})
    public ResponseEntity<DirectoryResponseData> updateDirectory(@PathVariable(name="ehr_id") UUID ehrId, @RequestHeader(name="If-Match") ObjectVersionId folderId, @RequestHeader(name="Content-Type") String contentType, @RequestHeader(name="Accept", defaultValue="application/json") String accept, @RequestHeader(name="Prefer", defaultValue="return=minimal") String prefer, @RequestHeader(name="openEHR-VERSION", required=false) String openEhrVersion, @RequestHeader(name="openEHR-AUDIT_DETAILS", required=false) String openEhrAuditDetails, @RequestBody Folder folder) {
        folderId.setValue(StringUtils.unwrap((String)folderId.getValue(), (char)'\"'));
        Folder updatedFolder = this.directoryService.update(ehrId, folder, folderId);
        return this.createDirectoryResponse(HttpMethod.PUT, prefer, accept, updatedFolder, ehrId);
    }

    @Override
    @DeleteMapping(path={"/{ehr_id}/directory"})
    public ResponseEntity<DirectoryResponseData> deleteDirectory(@PathVariable(name="ehr_id") UUID ehrId, @RequestHeader(name="openEHR-VERSION", required=false) String openEhrVersion, @RequestHeader(name="openEHR-AUDIT_DETAILS", required=false) String openEhrAuditDetails, @RequestHeader(name="Accept", defaultValue="application/json") String accept, @RequestHeader(name="If-Match") ObjectVersionId folderId) {
        folderId.setValue(StringUtils.unwrap((String)folderId.getValue(), (char)'\"'));
        this.directoryService.delete(ehrId, folderId);
        this.createAuditLogsMsgBuilder(ehrId.toString(), folderId.toString());
        this.createAuditLogsMsgBuilder(ehrId.toString(), folderId.toString());
        return this.createDirectoryResponse(HttpMethod.DELETE, null, accept, null, ehrId);
    }

    @Override
    @GetMapping(path={"/{ehr_id}/directory/{version_uid}"})
    public ResponseEntity<DirectoryResponseData> getFolderInDirectory(@PathVariable(name="ehr_id") UUID ehrId, @PathVariable(name="version_uid") ObjectVersionId versionUid, @RequestParam(name="path", required=false) String path, @RequestHeader(name="Accept", defaultValue="application/json") String accept) {
        this.validateVersionUid(versionUid);
        this.assertValidPath(path);
        Optional foundFolder = this.directoryService.get(ehrId, versionUid, path);
        if (foundFolder.isEmpty()) {
            throw new ObjectNotFoundException("DIRECTORY", String.format("Folder with id %s and path %s does not exist.", versionUid, path != null ? path : "/"));
        }
        return this.createDirectoryResponse(HttpMethod.GET, "return=representation", accept, (Folder)foundFolder.get(), ehrId);
    }

    private void validateVersionUid(ObjectVersionId versionUid) {
        String versionUidStr = versionUid.getValue();
        if (StringUtils.isEmpty((CharSequence)versionUidStr)) {
            throw new InvalidApiParameterException("a valid  must be provided");
        }
        try {
            versionUid.getCreatingSystemId();
            if (versionUid.isBranch()) {
                throw new InvalidApiParameterException("Version branching is not supported");
            }
        }
        catch (UnsupportedOperationException e) {
            throw new InvalidApiParameterException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @GetMapping(path={"/{ehr_id}/directory"})
    public ResponseEntity<DirectoryResponseData> getFolderInDirectoryVersionAtTime(@PathVariable(name="ehr_id") UUID ehrId, @RequestParam(name="version_at_time", required=false) String versionAtTime, @RequestParam(name="path", required=false) String path, @RequestHeader(name="Accept", required=false, defaultValue="application/json") String accept) {
        this.assertValidPath(path);
        Optional<OffsetDateTime> temporal = OpenehrDirectoryController.decodeVersionAtTime(versionAtTime);
        Optional foundFolder = temporal.isPresent() ? this.directoryService.getByTime(ehrId, temporal.get(), path) : this.directoryService.get(ehrId, null, path);
        if (foundFolder.isEmpty()) {
            throw new ObjectNotFoundException("folder", "The FOLDER for ehrId %s and path %s does not exist.".formatted(ehrId.toString(), path != null ? path : "/"));
        }
        return this.createDirectoryResponse(HttpMethod.GET, "return=representation", accept, (Folder)foundFolder.get(), ehrId);
    }

    private DirectoryResponseData buildResponse(Folder folderDto) {
        DirectoryResponseData resBody = new DirectoryResponseData();
        resBody.setDetails(folderDto.getDetails());
        resBody.setFolders(folderDto.getFolders());
        resBody.setItems(folderDto.getItems());
        resBody.setName(folderDto.getName());
        resBody.setUid(folderDto.getUid());
        return resBody;
    }

    private ResponseEntity<DirectoryResponseData> createDirectoryResponse(HttpMethod method, String prefer, String accept, Folder folderDto, UUID ehrId) {
        HttpStatus successStatus;
        DirectoryResponseData body;
        HttpHeaders headers = new HttpHeaders();
        if (prefer != null && prefer.equals("return=representation")) {
            headers.setContentType(this.resolveContentType(accept, MediaType.APPLICATION_XML));
            body = this.buildResponse(folderDto);
            successStatus = this.getSuccessStatus(method);
        } else {
            body = null;
            successStatus = HttpStatus.NO_CONTENT;
        }
        if (folderDto != null) {
            String versionUid = folderDto.getUid().toString();
            headers.setETag("\"" + versionUid + "\"");
            headers.setLocation(this.createLocationUri("ehr", ehrId.toString(), "directory", versionUid));
            headers.setLastModified(DateTime.now().getMillis());
            this.createAuditLogsMsgBuilder(ehrId.toString(), versionUid);
        }
        return new ResponseEntity(body, (MultiValueMap)headers, (HttpStatusCode)successStatus);
    }

    private HttpStatus getSuccessStatus(HttpMethod method) {
        if (method.equals((Object)HttpMethod.POST)) {
            return HttpStatus.CREATED;
        }
        if (method.equals((Object)HttpMethod.DELETE)) {
            return HttpStatus.NO_CONTENT;
        }
        return HttpStatus.OK;
    }

    private void assertValidPath(String path) {
        if (path == null) {
            return;
        }
        try {
            Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new InvalidApiParameterException("The value of path parameter is invalid", (Throwable)e);
        }
    }

    private void createAuditLogsMsgBuilder(String ehrId, String versionedObjectUid) {
        AuditMsgBuilder.getInstance().setEhrIds(new Object[]{ehrId}).setLocation(UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", ehrId, "directory", versionedObjectUid}).build().toString());
    }
}

