/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.ehrbase.api.audit.msg.AuditMsgBuilder;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.sdk.response.dto.EhrStatusResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.EhrStatusApiSpecification;
import org.ehrbase.rest.util.InternalResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrehrstatuscontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr/{ehr_id}/ehr_status"})
public class OpenehrEhrStatusController
extends BaseController
implements EhrStatusApiSpecification {
    private final EhrService ehrService;
    private final SystemService systemService;

    public OpenehrEhrStatusController(EhrService ehrService, SystemService systemService) {
        this.ehrService = ehrService;
        this.systemService = systemService;
    }

    @Override
    @GetMapping
    public ResponseEntity<EhrStatusResponseData> getEhrStatusVersionByTime(@PathVariable(name="ehr_id") UUID ehrId, @RequestParam(name="version_at_time", required=false) String versionAtTime, @RequestHeader(name="Accept", required=false) String accept) {
        ObjectVersionId objectVersionId;
        if (versionAtTime != null) {
            OffsetDateTime time = OpenehrEhrStatusController.decodeVersionAtTime(versionAtTime).orElseThrow();
            objectVersionId = this.ehrService.getEhrStatusVersionByTimestamp(ehrId, time);
        } else {
            objectVersionId = this.ehrService.getLatestVersionUidOfStatus(ehrId);
        }
        int version = this.extractVersionFromVersionUid(objectVersionId.getValue()).orElseThrow();
        UUID statusUid = this.extractVersionedObjectUidFromVersionUid(objectVersionId.getValue());
        return this.internalGetEhrStatusProcessing(accept, ehrId, statusUid, version);
    }

    @Override
    @GetMapping(path={"/{version_uid}"})
    public ResponseEntity<EhrStatusResponseData> getEhrStatusByVersionId(@PathVariable(name="ehr_id") UUID ehrId, @PathVariable(name="version_uid") String versionUid, @RequestHeader(name="Accept", required=false) String accept) {
        UUID versionedObjectUid = this.extractVersionedObjectUidFromVersionUid(versionUid);
        int version = this.extractVersionFromVersionUid(versionUid).orElseThrow(() -> new InvalidApiParameterException("VERSION UID parameter does not contain a version"));
        return this.internalGetEhrStatusProcessing(accept, ehrId, versionedObjectUid, version);
    }

    @Override
    @PutMapping
    public ResponseEntity<EhrStatusResponseData> updateEhrStatus(@PathVariable(value="ehr_id") UUID ehrId, @RequestHeader(name="If-Match") String versionUid, @RequestHeader(name="Prefer", required=false) String prefer, @RequestHeader(name="Accept", required=false) String accept, @RequestHeader(name="Content-Type", required=false) String contentType, @RequestBody EhrStatus ehrStatus) {
        ObjectVersionId targetObjId = new ObjectVersionId(versionUid);
        ObjectVersionId statusUid = this.ehrService.updateStatus(ehrId, ehrStatus, targetObjId, null, null);
        int version = this.extractVersionFromVersionUid(statusUid.getValue()).orElseThrow();
        List<String> headerList = Arrays.asList("Content-Type", "Location", "ETag", "Last-Modified");
        this.createAuditLogsMsgBuilder(ehrId);
        return this.buildEhrStatusResponseData(EhrStatusResponseData::new, ehrId, UUID.fromString(statusUid.getObjectId().getValue()), version, accept, headerList).map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body((Object)((EhrStatusResponseData)i.getResponseData()))).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private ResponseEntity<EhrStatusResponseData> internalGetEhrStatusProcessing(String accept, UUID ehrId, UUID ehrStatusId, int version) {
        List<String> headerList = Arrays.asList("Content-Type", "Location", "ETag", "Last-Modified");
        Optional<InternalResponse<EhrStatusResponseData>> respData = this.buildEhrStatusResponseData(EhrStatusResponseData::new, ehrId, ehrStatusId, version, accept, headerList);
        this.createAuditLogsMsgBuilder(ehrId);
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body((Object)((EhrStatusResponseData)i.getResponseData()))).orElseThrow(() -> new ObjectNotFoundException("ehr_status", "EHR_STATUS not found"));
    }

    private void createAuditLogsMsgBuilder(UUID ehrId) {
        AuditMsgBuilder.getInstance().setEhrIds(new Object[]{ehrId});
    }

    private <T extends EhrStatusResponseData> Optional<InternalResponse<T>> buildEhrStatusResponseData(Supplier<T> factory, UUID ehrId, UUID ehrStatusId, int version, String accept, List<String> headerList) {
        String versionedObjectUid = String.format("%s::%s::%s", ehrStatusId, this.systemService.getSystemId(), version);
        AuditMsgBuilder.getInstance().setEhrIds(new Object[]{ehrId.toString()}).setDirectoryId(versionedObjectUid).setLocation(UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", ehrId.toString(), "ehr_status", versionedObjectUid}).build().toString());
        EhrStatusResponseData minimalOrRepresentation = (EhrStatusResponseData)factory.get();
        MediaType contentType = this.resolveContentType(accept);
        Optional ehrStatus = this.ehrService.getEhrStatusAtVersion(ehrId, ehrStatusId, version);
        if (minimalOrRepresentation != null) {
            EhrStatusResponseData objByReference = minimalOrRepresentation;
            if (ehrStatus.isPresent()) {
                objByReference.setArchetypeNodeId(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getArchetypeNodeId());
                objByReference.setName(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getName());
                objByReference.setUid((UIDBasedId)((OriginalVersion)ehrStatus.get()).getUid());
                objByReference.setSubject(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getSubject());
                objByReference.setOtherDetails(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).getOtherDetails());
                objByReference.setModifiable(Boolean.valueOf(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).isModifiable()));
                objByReference.setQueryable(Boolean.valueOf(((EhrStatus)((OriginalVersion)ehrStatus.get()).getData()).isQueryable()));
            } else {
                return Optional.empty();
            }
        }
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Content-Type": {
                    respHeaders.setContentType(contentType);
                    break;
                }
                case "Location": {
                    try {
                        URI url = this.createLocationUri("ehr", ehrId.toString(), "ehr_status", versionedObjectUid);
                        respHeaders.setLocation(url);
                        break;
                    }
                    catch (Exception e) {
                        throw new InternalServerException(e.getMessage());
                    }
                }
                case "ETag": {
                    respHeaders.setETag("\"" + String.valueOf(ehrStatusId) + "::" + this.systemService.getSystemId() + "::" + version + "\"");
                    break;
                }
                case "Last-Modified": {
                    ehrStatus.ifPresent(ehrStatusOriginalVersion -> respHeaders.setLastModified(ehrStatusOriginalVersion.getCommitAudit().getTimeCommitted().getMagnitude().longValue()));
                    break;
                }
            }
        }
        return Optional.of(new InternalResponse<EhrStatusResponseData>(minimalOrRepresentation, respHeaders));
    }
}

