/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.AqlQueryRequest;
import org.ehrbase.api.service.AqlQueryService;
import org.ehrbase.api.service.StatusService;
import org.ehrbase.api.service.StoredQueryService;
import org.ehrbase.openehr.sdk.response.dto.MetaData;
import org.ehrbase.openehr.sdk.response.dto.QueryResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryResultDto;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.QueryApiSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrquerycontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/query"}, produces={"application/json", "application/xml"})
public class OpenehrQueryController
extends BaseController
implements QueryApiSpecification {
    private static final String QUERY_PARAMETERS = "query_parameters";
    private static final String FETCH = "fetch";
    private static final String OFFSET = "offset";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AqlQueryService aqlQueryService;
    private final StoredQueryService storedQueryService;
    private final StatusService statusService;
    @Value(value="${ehrbase.rest.aql.response.generator-details-enabled:false}")
    boolean generatorDetailsEnabled = false;

    public OpenehrQueryController(AqlQueryService aqlQueryService, StoredQueryService storedQueryService, StatusService statusService) {
        this.aqlQueryService = aqlQueryService;
        this.storedQueryService = storedQueryService;
        this.statusService = statusService;
    }

    @Override
    @GetMapping(path={"/aql"})
    public ResponseEntity<QueryResponseData> executeAdHocQuery(@RequestParam(name="q") String queryString, @RequestParam(name="offset", required=false) Integer offset, @RequestParam(name="fetch", required=false) Integer fetch, @RequestParam(name="query_parameters", required=false) Map<String, Object> queryParameters, @RequestHeader(name="Accept", required=false) String accept) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_EXECUTE_ENDPOINT, (Object)Boolean.TRUE);
        QueryResultDto queryResult = this.invoke(queryString, queryParameters, Optional.ofNullable(fetch).map(Integer::longValue), Optional.ofNullable(offset).map(Integer::longValue));
        QueryResponseData queryResponseData = this.createQueryResponse(queryString, queryResult, this.createLocationUri("query", "aql"));
        return ResponseEntity.ok((Object)queryResponseData);
    }

    @Override
    @PostMapping(path={"/aql"}, consumes={"application/json", "application/xml"})
    public ResponseEntity<QueryResponseData> executeAdHocQuery(@RequestBody Map<String, Object> queryRequest, @RequestHeader(name="Accept", required=false) String accept, @RequestHeader(name="Content-Type") String contentType) {
        this.logger.debug("Got following input: {}", queryRequest);
        Object rawQuery = queryRequest.get("q");
        if (rawQuery == null) {
            throw new InvalidApiParameterException("No aql query provided");
        }
        if (rawQuery instanceof ArrayList) {
            throw new InvalidApiParameterException("Multiple aql queries provided");
        }
        String queryString = (String)rawQuery;
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_EXECUTE_ENDPOINT, (Object)Boolean.TRUE);
        QueryResultDto queryResult = this.invoke(queryString, queryRequest);
        QueryResponseData queryResponseData = this.createQueryResponse(queryString, queryResult);
        return ResponseEntity.ok((Object)queryResponseData);
    }

    @Override
    @GetMapping(path={"/{qualified_query_name}", "/{qualified_query_name}/{version}"})
    public ResponseEntity<QueryResponseData> executeStoredQuery(@PathVariable(name="qualified_query_name") String qualifiedQueryName, @PathVariable(name="version", required=false) String version, @RequestParam(name="offset", required=false) Integer offset, @RequestParam(name="fetch", required=false) Integer fetch, @RequestParam(name="query_parameters", required=false) Map<String, Object> queryParameters, @RequestHeader(name="Accept", required=false) String accept) {
        this.logger.trace("getStoredQuery with the following input: {} - {} - {} - {} - {}", new Object[]{qualifiedQueryName, version, offset, fetch, queryParameters});
        this.createRestContext(qualifiedQueryName, version);
        QueryDefinitionResultDto queryDefinition = this.storedQueryService.retrieveStoredQuery(qualifiedQueryName, version);
        String queryString = queryDefinition.getQueryText();
        QueryResultDto queryResult = this.invoke(queryString, queryParameters, Optional.ofNullable(fetch).map(Integer::longValue), Optional.ofNullable(offset).map(Integer::longValue));
        Stream<String> pathSegments = Stream.of("query", qualifiedQueryName, version).filter(Objects::nonNull);
        URI locationUri = this.createLocationUri((String[])pathSegments.toArray(String[]::new));
        QueryResponseData queryResponseData = this.createQueryResponse(queryString, queryResult, locationUri);
        OpenehrQueryController.setQueryName(queryDefinition, queryResponseData);
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_ID, (Object)queryDefinition.getQualifiedName());
        return ResponseEntity.ok((Object)queryResponseData);
    }

    @Override
    @PostMapping(path={"/{qualified_query_name}", "/{qualified_query_name}/{version}"}, consumes={"application/json", "application/xml"})
    public ResponseEntity<QueryResponseData> executeStoredQuery(@PathVariable(name="qualified_query_name") String qualifiedQueryName, @PathVariable(name="version", required=false) String version, @RequestHeader(name="Accept", required=false) String accept, @RequestHeader(name="Content-Type") String contentType, @RequestBody(required=false) Map<String, Object> queryRequest) {
        this.logger.trace("postStoredQuery with the following input: {}, {}, {}", new Object[]{qualifiedQueryName, version, queryRequest});
        this.createRestContext(qualifiedQueryName, version);
        QueryDefinitionResultDto queryDefinition = this.storedQueryService.retrieveStoredQuery(qualifiedQueryName, version);
        String queryString = queryDefinition.getQueryText();
        if (queryString == null) {
            String message = MessageFormat.format("Could not retrieve AQL {0}/{1}", qualifiedQueryName, version);
            throw new ObjectNotFoundException("AQL", message);
        }
        QueryResultDto queryResult = this.invoke(queryString, queryRequest);
        QueryResponseData queryResponseData = this.createQueryResponse(queryString, queryResult);
        OpenehrQueryController.setQueryName(queryDefinition, queryResponseData);
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_ID, (Object)queryDefinition.getQualifiedName());
        return ResponseEntity.ok((Object)queryResponseData);
    }

    private void createRestContext(String qualifiedName, @Nullable String version) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_EXECUTE_ENDPOINT, (Object)Boolean.TRUE, (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"query", qualifiedName, version}).build().toString());
    }

    private QueryResultDto invoke(@NonNull String queryString, Map<String, Object> requestBody) {
        requestBody = Optional.ofNullable(requestBody).orElseGet(Map::of);
        Map queryParameters = Optional.ofNullable(requestBody.get(QUERY_PARAMETERS)).map(p -> (Map)p).orElseGet(Map::of);
        Optional<Long> fetch = OpenehrQueryController.optionalLong(FETCH, requestBody);
        Optional<Long> offset = OpenehrQueryController.optionalLong(OFFSET, requestBody);
        return this.invoke(queryString, queryParameters, fetch, offset);
    }

    private QueryResultDto invoke(@NonNull String queryString, Map<String, Object> parameters, Optional<Long> fetch, Optional<Long> offset) {
        AqlQueryRequest aqlQueryRequest = new AqlQueryRequest(queryString, parameters, (Long)fetch.orElse(null), (Long)offset.orElse(null));
        return this.aqlQueryService.query(aqlQueryRequest);
    }

    private static Optional<Long> optionalLong(String name, Map<String, Object> params) {
        return Optional.of(name).map(params::get).map(o -> {
            Long l;
            Object object = o;
            Objects.requireNonNull(object);
            Object selector0$temp = object;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, String.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    Long l2;
                    Integer i = (Integer)selector0$temp;
                    l = l2 = Long.valueOf(i.longValue());
                    break;
                }
                case 1: {
                    Long l3;
                    Long l4;
                    l = l4 = (l3 = (Long)selector0$temp);
                    break;
                }
                case 2: {
                    String s = (String)selector0$temp;
                    try {
                        Long l5;
                        l = l5 = Long.valueOf(s);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidApiParameterException("invalid '%s' value '%s'".formatted(name, s));
                    }
                }
                default: {
                    throw new InvalidApiParameterException("invalid '%s' value '%s'".formatted(name, o));
                }
            }
            return l;
        });
    }

    private static void setQueryName(QueryDefinitionResultDto queryDefinitionResultDto, QueryResponseData queryResponseData) {
        queryResponseData.setName(queryDefinitionResultDto.getQualifiedName() + "/" + queryDefinitionResultDto.getVersion());
    }

    private QueryResponseData createQueryResponse(String requestedAQL, QueryResultDto resultDto) {
        return this.createQueryResponse(requestedAQL, resultDto, null);
    }

    protected QueryResponseData createQueryResponse(String requestedAQL, QueryResultDto resultDto, @Nullable URI location) {
        QueryResponseData queryResponseData = new QueryResponseData(resultDto);
        MetaData metaData = new MetaData(resultDto);
        metaData.setHref((String)Optional.ofNullable(location).map(URI::toASCIIString).orElse(null));
        metaData.setSchemaVersion("1.0.4");
        queryResponseData.setMeta(metaData);
        if (this.generatorDetailsEnabled) {
            metaData.setGenerator("EHRBase/%s".formatted(this.statusService.getEhrbaseVersion()));
        }
        return queryResponseData;
    }
}

