/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.changecontrol.VersionedObject;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.ehr.VersionedEhrStatus;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.openehr.sdk.response.dto.OriginalVersionResponseData;
import org.ehrbase.openehr.sdk.response.dto.RevisionHistoryResponseData;
import org.ehrbase.openehr.sdk.response.dto.VersionedObjectResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.ContributionDto;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.VersionedEhrStatusApiSpecification;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrversionedehrstatuscontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr/{ehr_id}/versioned_ehr_status"}, produces={"application/json", "application/xml"})
public class OpenehrVersionedEhrStatusController
extends BaseController
implements VersionedEhrStatusApiSpecification {
    private static final String REVISION_HISTORY = "revision_history";
    private final ContributionService contributionService;
    private final EhrService ehrService;

    public OpenehrVersionedEhrStatusController(EhrService ehrService, ContributionService contributionService) {
        this.ehrService = Objects.requireNonNull(ehrService);
        this.contributionService = Objects.requireNonNull(contributionService);
    }

    @Override
    @GetMapping
    public ResponseEntity<VersionedObjectResponseData<EhrStatus>> retrieveVersionedEhrStatusByEhr(@PathVariable(value="ehr_id") String ehrIdString, @RequestHeader(value="Accept", required=false) String accept) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        VersionedEhrStatus versionedEhrStatus = this.ehrService.getVersionedEhrStatus(ehrId);
        VersionedObjectResponseData response = new VersionedObjectResponseData((VersionedObject)versionedEhrStatus);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        this.createRestContext(ehrId, new String[0]);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)response);
    }

    @Override
    @GetMapping(path={"/revision_history"})
    public ResponseEntity<RevisionHistoryResponseData> retrieveVersionedEhrStatusRevisionHistoryByEhr(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        RevisionHistory revisionHistory = this.ehrService.getRevisionHistoryOfVersionedEhrStatus(ehrId);
        RevisionHistoryResponseData response = new RevisionHistoryResponseData(revisionHistory);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        this.createRestContext(ehrId, REVISION_HISTORY);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)response);
    }

    @Override
    @GetMapping(path={"/version"})
    public ResponseEntity<OriginalVersionResponseData<EhrStatus>> retrieveVersionOfEhrStatusByTime(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @RequestParam(value="version_at_time", required=false) String versionAtTime) {
        ObjectVersionId objectVersionId;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (versionAtTime != null) {
            OffsetDateTime time = OpenehrVersionedEhrStatusController.decodeVersionAtTime(versionAtTime).orElseThrow();
            objectVersionId = this.ehrService.getEhrStatusVersionByTimestamp(ehrId, time);
        } else {
            objectVersionId = this.ehrService.getLatestVersionUidOfStatus(ehrId);
        }
        int version = this.extractVersionFromVersionUid(objectVersionId.getValue()).orElseThrow();
        UUID statusUid = this.extractVersionedObjectUidFromVersionUid(objectVersionId.getValue());
        Optional ehrStatusOriginalVersion = this.ehrService.getEhrStatusAtVersion(ehrId, statusUid, version);
        UUID contributionId = ehrStatusOriginalVersion.map(i -> UUID.fromString(i.getContribution().getId().getValue())).orElseThrow(() -> new ObjectNotFoundException("EHR_STATUS", "Couldn't retrieve EhrStatus with given parameters"));
        ContributionDto contributionDto = this.contributionService.getContribution(ehrId, contributionId);
        OriginalVersionResponseData originalVersionResponseData = new OriginalVersionResponseData((OriginalVersion)ehrStatusOriginalVersion.orElseThrow(), contributionDto);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        this.createRestContext(ehrId, (Pair<String, String>)new ImmutablePair((Object)"version_at_time", (Object)versionAtTime), "version");
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.VERSION, (Object)version);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)originalVersionResponseData);
    }

    @Override
    @GetMapping(path={"/version/{version_uid}"})
    public ResponseEntity<OriginalVersionResponseData<EhrStatus>> retrieveVersionOfEhrStatusByVersionUid(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="version_uid") String versionUid) {
        int version;
        UUID versionedObjectId;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("EHR", "No EHR with this ID can be found.");
        }
        try {
            versionedObjectId = UUID.fromString(versionUid.split("::")[0]);
            version = Integer.parseInt(versionUid.split("::")[2]);
        }
        catch (Exception e) {
            throw new InvalidApiParameterException("VERSION UID parameter has wrong format: " + e.getMessage());
        }
        if (version < 1) {
            throw new InvalidApiParameterException("Version can't be negative.");
        }
        Optional ehrStatusOriginalVersion = this.ehrService.getEhrStatusAtVersion(ehrId, versionedObjectId, version);
        UUID contributionId = ehrStatusOriginalVersion.map(i -> UUID.fromString(i.getContribution().getId().getValue())).orElseThrow(() -> new ObjectNotFoundException("EHR_STATUS", "Couldn't retrieve EhrStatus with given parameters"));
        ContributionDto contributionDto = this.contributionService.getContribution(ehrId, contributionId);
        OriginalVersionResponseData originalVersionResponseData = new OriginalVersionResponseData((OriginalVersion)ehrStatusOriginalVersion.orElseThrow(), contributionDto);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        this.createRestContext(ehrId, "version", originalVersionResponseData.getVersionId().toString());
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.VERSION, (Object)version);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)originalVersionResponseData);
    }

    private void createRestContext(UUID ehrId, String ... pathSegments) {
        this.createRestContext(ehrId, (Pair<String, String>)new ImmutablePair((Object)"", (Object)""), pathSegments);
    }

    private void createRestContext(UUID ehrId, Pair<String, String> queryParam, String ... pathSegments) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", ehrId.toString(), "versioned_ehr_status"}).pathSegment(pathSegments);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)queryParam.getKey())) && StringUtils.isNotBlank((CharSequence)((CharSequence)queryParam.getValue()))) {
            uriComponentsBuilder.queryParam((String)queryParam.getKey(), new Object[]{queryParam.getValue()});
        }
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)ehrId, (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)uriComponentsBuilder.build().toString());
    }
}

