/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.openehr.sdk.response.dto.ContributionResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.ContributionDto;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.ContributionApiSpecification;
import org.ehrbase.rest.util.InternalResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrcontributioncontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr"}, produces={"application/json", "application/xml"})
public class OpenehrContributionController
extends BaseController
implements ContributionApiSpecification {
    private final ContributionService contributionService;

    @Autowired
    public OpenehrContributionController(ContributionService contributionService) {
        this.contributionService = Objects.requireNonNull(contributionService);
    }

    @Override
    @PostMapping(value={"/{ehr_id}/contribution"}, consumes={"application/xml", "application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity createContribution(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Content-Type") String contentType, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false) String prefer, @PathVariable(value="ehr_id") String ehrIdString, @RequestBody String contribution) {
        if (!this.resolveContentType(contentType).isCompatibleWith(MediaType.APPLICATION_JSON)) {
            throw new NotAcceptableException("Invalid content type, only %s is supported".formatted(MediaType.APPLICATION_JSON));
        }
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID contributionId = this.contributionService.commitContribution(ehrId, contribution);
        URI uri = this.createLocationUri("ehr", ehrId.toString(), "contribution", contributionId.toString());
        List<String> headerList = Arrays.asList("Location", "ETag");
        boolean doReturnRepresentation = "return=representation".equals(prefer);
        InternalResponse<ContributionResponseData> respData = this.buildContributionResponseData(contributionId, ehrId, accept, uri, headerList, doReturnRepresentation);
        this.createRestContext(ehrId, contributionId);
        if (doReturnRepresentation) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).headers(respData.getHeaders())).body((Object)respData.getResponseData());
        }
        return ResponseEntity.noContent().headers(respData.getHeaders()).build();
    }

    @Override
    @GetMapping(value={"/{ehr_id}/contribution/{contribution_uid}"})
    public ResponseEntity getContribution(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="contribution_uid") String contributionUidString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID contributionUid = this.getContributionVersionedObjectUidString(contributionUidString);
        URI uri = this.createLocationUri("ehr", ehrId.toString(), "contribution", contributionUid.toString());
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        InternalResponse<ContributionResponseData> respData = this.buildContributionResponseData(contributionUid, ehrId, accept, uri, headerList, true);
        this.createRestContext(ehrId, contributionUid);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respData.getHeaders())).body((Object)respData.getResponseData());
    }

    private InternalResponse<ContributionResponseData> buildContributionResponseData(UUID contributionId, UUID ehrId, String accept, URI uri, List<String> headerList, boolean includeResponseData) {
        ContributionResponseData responseData;
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Location": {
                    respHeaders.setLocation(uri);
                    break;
                }
                case "ETag": {
                    respHeaders.setETag("\"" + String.valueOf(contributionId) + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                    break;
                }
            }
        }
        if (includeResponseData) {
            MediaType mediaType = this.resolveContentType(accept);
            respHeaders.setContentType(mediaType);
            ContributionDto contribution = this.contributionService.getContribution(ehrId, contributionId);
            responseData = new ContributionResponseData(new HierObjectId(contributionId.toString()), contribution.getObjectReferences().entrySet().stream().map(e -> new ObjectRef((ObjectId)new ObjectVersionId((String)e.getKey()), "local", (String)e.getValue())).collect(Collectors.toList()), contribution.getAuditDetails());
        } else {
            responseData = null;
        }
        return new InternalResponse<Object>(responseData, respHeaders);
    }

    private void createRestContext(UUID ehrId, UUID contributionId) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)ehrId, (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", ehrId.toString(), "contribution", contributionId.toString()}).build().toString());
    }
}

