/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.specification;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.ehrbase.api.dto.EhrDto;
import org.ehrbase.api.dto.EhrStatusDto;
import org.springframework.http.ResponseEntity;

@Tag(name="EHR")
public interface EhrApiSpecification {
    @Operation(summary="Create EHR", requestBody=@RequestBody(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EhrDto.class)), examples={@ExampleObject(value="{\n    \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n    \"name\": {\n        \"value\": \"EHR status\"\n    },\n    \"uid\": {\n        \"_type\": \"OBJECT_VERSION_ID\",\n        \"value\": \"9e3eb79b-1caa-4ab9-8cd4-d374b7c42bb4::local.ehrbase.org::1\"\n    },\n    \"subject\": {\n        \"_type\": \"PARTY_SELF\"\n    },\n    \"is_queryable\": true,\n    \"is_modifiable\": true\n}\n")})}), responses={@ApiResponse(responseCode="201", description="Created, is returned when the EHR has been successfully created. The new EHR resource is returned in the body when the request's <code>Prefer</code>  header value is <code>return=representation</code> , otherwise only headers are returned.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EhrDto.class)), examples={@ExampleObject(value="{\n    \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n    \"name\": {\n        \"value\": \"EHR status\"\n    },\n    \"uid\": {\n        \"_type\": \"OBJECT_VERSION_ID\",\n        \"value\": \"9e3eb79b-1caa-4ab9-8cd4-d374b7c42bb4::local.ehrbase.org::1\"\n    },\n    \"subject\": {\n        \"_type\": \"PARTY_SELF\"\n    },\n    \"is_queryable\": true,\n    \"is_modifiable\": true\n}\n")})}), @ApiResponse(responseCode="400", description="Bad Request, is returned when the request URL or body (if provided) could not be parsed or has invalid content.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="409", description="Conflict, Unable to create a new EHR due to a conflict with an already existing EHR with the same subject id, namespace pair, whenever EHR_STATUS is supplied.", content={@Content(schema=@Schema(hidden=true))})}, externalDocs=@ExternalDocumentation(url="https://specifications.openehr.org/releases/ITS-REST/latest/ehr.html#tag/EHR/operation/ehr_create"))
    public ResponseEntity<EhrDto> createEhr(String var1, String var2, String var3, @Parameter(hidden=true, allowEmptyValue=true) EhrStatusDto var4);

    @Operation(summary="Create EHR with id", requestBody=@RequestBody(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EhrDto.class)), examples={@ExampleObject(value="{\n    \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n    \"name\": {\n        \"value\": \"EHR status\"\n    },\n    \"uid\": {\n        \"_type\": \"OBJECT_VERSION_ID\",\n        \"value\": \"9e3eb79b-1caa-4ab9-8cd4-d374b7c42bb4::local.ehrbase.org::1\"\n    },\n    \"subject\": {\n        \"_type\": \"PARTY_SELF\"\n    },\n    \"is_queryable\": true,\n    \"is_modifiable\": true\n}\n")})}), responses={@ApiResponse(responseCode="201", description="Created, is returned when the EHR has been successfully created. The new EHR resource is returned in the body when the request's <code>Prefer</code> header value is <code>return=representation</code> , otherwise only headers are returned.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EhrDto.class)), examples={@ExampleObject(value="{\n    \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n    \"name\": {\n        \"value\": \"EHR status\"\n    },\n    \"uid\": {\n        \"_type\": \"OBJECT_VERSION_ID\",\n        \"value\": \"9e3eb79b-1caa-4ab9-8cd4-d374b7c42bb4::local.ehrbase.org::1\"\n    },\n    \"subject\": {\n        \"_type\": \"PARTY_SELF\"\n    },\n    \"is_queryable\": true,\n    \"is_modifiable\": true\n}\n")})}), @ApiResponse(responseCode="400", description="Bad Request, is returned when the request URL or body (if provided) could not be parsed or has invalid content.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="409", description="Conflict, Unable to create a new EHR due to a conflict with an already existing EHR with the same subject id, namespace pair, whenever EHR_STATUS is supplied.", content={@Content(schema=@Schema(hidden=true))})}, externalDocs=@ExternalDocumentation(url="https://specifications.openehr.org/releases/ITS-REST/1.0.3/ehr.html#tag/EHR/operation/ehr_get_by_id"))
    public ResponseEntity<EhrDto> createEhrWithId(String var1, String var2, String var3, String var4, EhrStatusDto var5);

    @Operation(summary="Get EHR by id", responses={@ApiResponse(responseCode="200", description="OK, is returned when the requested EHR resource is successfully retrieved.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EhrDto.class)), examples={@ExampleObject(value="{\n    \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n    \"name\": {\n        \"value\": \"EHR status\"\n    },\n    \"uid\": {\n        \"_type\": \"OBJECT_VERSION_ID\",\n        \"value\": \"9e3eb79b-1caa-4ab9-8cd4-d374b7c42bb4::local.ehrbase.org::1\"\n    },\n    \"subject\": {\n        \"_type\": \"PARTY_SELF\"\n    },\n    \"is_queryable\": true,\n    \"is_modifiable\": true\n}\n")})}), @ApiResponse(responseCode="404", description="Not Found, is returned when an EHR with <code>ehr_id</code>  does not exist.", content={@Content(schema=@Schema(hidden=true))})}, externalDocs=@ExternalDocumentation(url="https://specifications.openehr.org/releases/ITS-REST/latest/ehr.html#tag/EHR/operation/ehr_get_by_id"))
    public ResponseEntity<EhrDto> getEhrById(String var1);

    @Operation(summary="Get EHR summary by subject id and namespace", responses={@ApiResponse(responseCode="200", description="OK, is returned when the requested EHR resource is successfully retrieved.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EhrDto.class)), examples={@ExampleObject(value="{\n    \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n    \"name\": {\n        \"value\": \"EHR status\"\n    },\n    \"uid\": {\n        \"_type\": \"OBJECT_VERSION_ID\",\n        \"value\": \"9e3eb79b-1caa-4ab9-8cd4-d374b7c42bb4::local.ehrbase.org::1\"\n    },\n    \"subject\": {\n        \"_type\": \"PARTY_SELF\"\n    },\n    \"is_queryable\": true,\n    \"is_modifiable\": true\n}\n")})}), @ApiResponse(responseCode="404", description="Not Found, is returned when an EHR with supplied subject parameters does not exist.", content={@Content(schema=@Schema(hidden=true))})}, externalDocs=@ExternalDocumentation(url="https://specifications.openehr.org/releases/ITS-REST/latest/ehr.html#tag/EHR/operation/ehr_get_by_subject"))
    public ResponseEntity<EhrDto> getEhrBySubject(String var1, String var2);
}

