/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.dto.AqlQueryRequest;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.AqlQueryService;
import org.ehrbase.api.service.StoredQueryService;
import org.ehrbase.openehr.sdk.response.dto.QueryResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryResultDto;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.QueryApiSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrquerycontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/query"}, produces={"application/json", "application/xml"})
public class OpenehrQueryController
extends BaseController
implements QueryApiSpecification {
    private static final String QUERY_PARAMETERS = "query_parameters";
    private static final String FETCH_PARAM = "fetch";
    private static final String OFFSET_PARAM = "offset";
    private static final String Q_PARAM = "q";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AqlQueryService aqlQueryService;
    private final StoredQueryService storedQueryService;
    private final AqlQueryContext aqlQueryContext;

    public OpenehrQueryController(AqlQueryService aqlQueryService, StoredQueryService storedQueryService, AqlQueryContext aqlQueryContext) {
        this.aqlQueryService = aqlQueryService;
        this.storedQueryService = storedQueryService;
        this.aqlQueryContext = aqlQueryContext;
    }

    @Override
    @GetMapping(path={"/aql"})
    public ResponseEntity<QueryResponseData> executeAdHocQuery(@RequestParam(name="q") String queryString, @RequestParam(name="offset", required=false) Integer offset, @RequestParam(name="fetch", required=false) Integer fetch, @RequestParam(name="query_parameters", required=false) Map<String, Object> queryParameters, @RequestHeader(name="Accept", required=false) String accept) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_EXECUTE_ENDPOINT, (Object)Boolean.TRUE);
        AqlQueryRequest aqlQueryRequest = this.createRequest(queryString, queryParameters, Optional.ofNullable(fetch).map(Integer::longValue), Optional.ofNullable(offset).map(Integer::longValue));
        QueryResultDto aqlQueryResult = this.aqlQueryService.query(aqlQueryRequest);
        QueryResponseData queryResponseData = this.createQueryResponse(aqlQueryResult, queryString, this.createLocationUri("query", "aql"));
        return ResponseEntity.ok((Object)queryResponseData);
    }

    @Override
    @PostMapping(path={"/aql"}, consumes={"application/json", "application/xml"})
    public ResponseEntity<QueryResponseData> executeAdHocQuery(@RequestBody Map<String, Object> queryRequest, @RequestHeader(name="Accept", required=false) String accept, @RequestHeader(name="Content-Type") String contentType) {
        Object rawQuery;
        this.logger.debug("Got following input: {}", queryRequest);
        Object object = rawQuery = queryRequest.get(Q_PARAM);
        int n = 0;
        String queryString = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayList.class, String.class}, (Object)object, n)) {
            case -1 -> throw new InvalidApiParameterException("No aql query provided");
            case 0 -> {
                ArrayList __ = (ArrayList)object;
                throw new InvalidApiParameterException("Multiple aql queries provided");
            }
            case 1 -> (String)object;
            default -> throw new InvalidApiParameterException("Data type of aql query not supported");
        };
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_EXECUTE_ENDPOINT, (Object)Boolean.TRUE);
        AqlQueryRequest aqlQueryRequest = this.createRequest(queryString, queryRequest);
        QueryResultDto aqlQueryResult = this.aqlQueryService.query(aqlQueryRequest);
        QueryResponseData queryResponseData = this.createQueryResponse(aqlQueryResult, queryString, null);
        return ResponseEntity.ok((Object)queryResponseData);
    }

    @Override
    @GetMapping(path={"/{qualified_query_name}", "/{qualified_query_name}/{version}"})
    public ResponseEntity<QueryResponseData> executeStoredQuery(@PathVariable(name="qualified_query_name") String qualifiedQueryName, @PathVariable(name="version", required=false) String version, @RequestParam(name="offset", required=false) Integer offset, @RequestParam(name="fetch", required=false) Integer fetch, @RequestParam(name="query_parameters", required=false) Map<String, Object> queryParameters, @RequestHeader(name="Accept", required=false) String accept) {
        this.logger.trace("getStoredQuery with the following input: {} - {} - {} - {} - {}", new Object[]{qualifiedQueryName, version, offset, fetch, queryParameters});
        this.createRestContext(qualifiedQueryName, version);
        QueryDefinitionResultDto queryDefinition = this.storedQueryService.retrieveStoredQuery(qualifiedQueryName, version);
        String queryString = queryDefinition.getQueryText();
        AqlQueryRequest aqlQueryRequest = this.createRequest(queryString, queryParameters, Optional.ofNullable(fetch).map(Integer::longValue), Optional.ofNullable(offset).map(Integer::longValue));
        QueryResultDto aqlQueryResult = this.aqlQueryService.query(aqlQueryRequest);
        Stream<String> pathSegments = Stream.of("query", qualifiedQueryName, version).filter(Objects::nonNull);
        URI locationUri = this.createLocationUri((String[])pathSegments.toArray(String[]::new));
        QueryResponseData queryResponseData = this.createQueryResponse(aqlQueryResult, queryString, locationUri);
        OpenehrQueryController.setQueryName(queryDefinition, queryResponseData);
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_ID, (Object)queryDefinition.getQualifiedName());
        return ResponseEntity.ok((Object)queryResponseData);
    }

    @Override
    @PostMapping(path={"/{qualified_query_name}", "/{qualified_query_name}/{version}"}, consumes={"application/json", "application/xml"})
    public ResponseEntity<QueryResponseData> executeStoredQuery(@PathVariable(name="qualified_query_name") String qualifiedQueryName, @PathVariable(name="version", required=false) String version, @RequestHeader(name="Accept", required=false) String accept, @RequestHeader(name="Content-Type") String contentType, @RequestBody(required=false) Map<String, Object> queryRequest) {
        this.logger.trace("postStoredQuery with the following input: {}, {}, {}", new Object[]{qualifiedQueryName, version, queryRequest});
        this.createRestContext(qualifiedQueryName, version);
        QueryDefinitionResultDto queryDefinition = this.storedQueryService.retrieveStoredQuery(qualifiedQueryName, version);
        String queryString = queryDefinition.getQueryText();
        if (queryString == null) {
            String message = MessageFormat.format("Could not retrieve AQL {0}/{1}", qualifiedQueryName, version);
            throw new ObjectNotFoundException("AQL", message);
        }
        AqlQueryRequest aqlQueryRequest = this.createRequest(queryString, queryRequest);
        QueryResultDto aqlQueryResult = this.aqlQueryService.query(aqlQueryRequest);
        QueryResponseData queryResponseData = this.createQueryResponse(aqlQueryResult, queryString, null);
        OpenehrQueryController.setQueryName(queryDefinition, queryResponseData);
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_ID, (Object)queryDefinition.getQualifiedName());
        return ResponseEntity.ok((Object)queryResponseData);
    }

    private void createRestContext(String qualifiedName, @Nullable String version) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_EXECUTE_ENDPOINT, (Object)Boolean.TRUE, (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{Q_PARAM, qualifiedName, version}).build().toString());
    }

    private AqlQueryRequest createRequest(@NonNull String queryString, Map<String, Object> requestBody) {
        requestBody = Optional.ofNullable(requestBody).orElseGet(Map::of);
        Map queryParameters = Optional.ofNullable(requestBody.get(QUERY_PARAMETERS)).map(p -> (Map)p).orElseGet(Map::of);
        Optional<Long> fetch = OpenehrQueryController.optionalLong(FETCH_PARAM, requestBody);
        Optional<Long> offset = OpenehrQueryController.optionalLong(OFFSET_PARAM, requestBody);
        return this.createRequest(queryString, queryParameters, fetch, offset);
    }

    private AqlQueryRequest createRequest(@NonNull String queryString, Map<String, Object> parameters, Optional<Long> fetch, Optional<Long> offset) {
        return new AqlQueryRequest(queryString, parameters, (Long)fetch.orElse(null), (Long)offset.orElse(null));
    }

    protected QueryResponseData createQueryResponse(QueryResultDto aqlQueryResult, String queryString, @Nullable URI location) {
        QueryResponseData queryResponseData = new QueryResponseData(aqlQueryResult);
        queryResponseData.setQuery(queryString);
        queryResponseData.setMeta(this.aqlQueryContext.createMetaData(location));
        return queryResponseData;
    }

    private static void setQueryName(QueryDefinitionResultDto queryDefinitionResultDto, QueryResponseData queryResponseData) {
        queryResponseData.setName(queryDefinitionResultDto.getQualifiedName() + "/" + queryDefinitionResultDto.getVersion());
    }

    private static Optional<Long> optionalLong(String name, Map<String, Object> params) {
        return Optional.of(name).map(params::get).map(o -> {
            Long l;
            Object object = o;
            Objects.requireNonNull(object);
            Object selector0$temp = object;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, String.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    Long l2;
                    Integer i = (Integer)selector0$temp;
                    l = l2 = Long.valueOf(i.longValue());
                    break;
                }
                case 1: {
                    Long l3;
                    Long l4;
                    l = l4 = (l3 = (Long)selector0$temp);
                    break;
                }
                case 2: {
                    String s = (String)selector0$temp;
                    try {
                        Long l5;
                        l = l5 = Long.valueOf(s);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidApiParameterException("invalid '%s' value '%s'".formatted(name, s));
                    }
                }
                default: {
                    throw new InvalidApiParameterException("invalid '%s' value '%s'".formatted(name, o));
                }
            }
            return l;
        });
    }
}

