/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.ehr.VersionedComposition;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.dto.VersionedCompositionDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.sdk.response.dto.OriginalVersionResponseData;
import org.ehrbase.openehr.sdk.response.dto.RevisionHistoryResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.ContributionDto;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.VersionedCompositionApiSpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrversionedcompositioncontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr/{ehr_id}/versioned_composition"}, produces={"application/json", "application/xml"})
public class OpenehrVersionedCompositionController
extends BaseController
implements VersionedCompositionApiSpecification {
    private final EhrService ehrService;
    private final CompositionService compositionService;
    private final ContributionService contributionService;
    private final SystemService systemService;

    @Autowired
    public OpenehrVersionedCompositionController(EhrService ehrService, CompositionService compositionService, ContributionService contributionService, SystemService systemService) {
        this.ehrService = Objects.requireNonNull(ehrService);
        this.compositionService = Objects.requireNonNull(compositionService);
        this.contributionService = Objects.requireNonNull(contributionService);
        this.systemService = systemService;
    }

    @Override
    @GetMapping(path={"/{versioned_object_uid}"})
    public ResponseEntity<VersionedCompositionDto> retrieveVersionedCompositionByVersionedObjectUid(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedCompoUid = this.getCompositionVersionedObjectUidString(versionedObjectUid);
        this.checkForValidEhrAndCompositionParameter(ehrId, versionedCompoUid);
        VersionedComposition versionedComposition = this.compositionService.getVersionedComposition(ehrId, versionedCompoUid);
        VersionedCompositionDto versionedCompositionDto = new VersionedCompositionDto(versionedComposition.getUid(), versionedComposition.getOwnerId(), DateTimeFormatter.ISO_DATE_TIME.format(versionedComposition.getTimeCreated().getValue()));
        String auditLocation = this.getLocationUrl(versionedCompoUid, ehrId, 0, new String[0]);
        this.createRestContext(ehrId, versionedCompoUid, auditLocation);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)versionedCompositionDto);
    }

    @Override
    @GetMapping(path={"/{versioned_object_uid}/revision_history"})
    public ResponseEntity<RevisionHistoryResponseData> retrieveVersionedCompositionRevisionHistoryByEhr(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedCompoUid = this.getCompositionVersionedObjectUidString(versionedObjectUid);
        this.checkForValidEhrAndCompositionParameter(ehrId, versionedCompoUid);
        RevisionHistory revisionHistory = this.compositionService.getRevisionHistoryOfVersionedComposition(ehrId, versionedCompoUid);
        RevisionHistoryResponseData response = new RevisionHistoryResponseData(revisionHistory);
        String auditLocation = this.getLocationUrl(versionedCompoUid, ehrId, 0, "revision_history");
        this.createRestContext(ehrId, versionedCompoUid, auditLocation);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)response);
    }

    @Override
    @GetMapping(path={"/{versioned_object_uid}/version/{version_uid}"})
    public ResponseEntity<OriginalVersionResponseData<Composition>> retrieveVersionOfCompositionByVersionUid(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @PathVariable(value="version_uid") String versionUid) {
        int version;
        UUID versionedObjectId;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedCompoUid = this.getCompositionVersionedObjectUidString(versionedObjectUid);
        this.checkForValidEhrAndCompositionParameter(ehrId, versionedCompoUid);
        ObjectVersionId compositionVersionId = new ObjectVersionId(versionUid);
        if (!compositionVersionId.getRoot().getValue().equals(versionedObjectUid)) {
            throw new IllegalArgumentException("Composition parameters are not matching.");
        }
        try {
            versionedObjectId = UUID.fromString(compositionVersionId.getRoot().getValue());
            version = Integer.parseInt(compositionVersionId.getVersionTreeId().getValue());
            if (version <= 0) {
                throw new InvalidApiParameterException("VERSION UID parameter has wrong format: Version needs to be greater 0");
            }
        }
        catch (Exception e) {
            throw new InvalidApiParameterException("VERSION UID parameter has wrong format: " + e.getMessage());
        }
        String auditLocation = this.getLocationUrl(versionedObjectId, ehrId, version, "version", versionUid);
        this.createRestContext(ehrId, versionedCompoUid, auditLocation);
        return this.getOriginalVersionResponseDataResponseEntity(accept, ehrId, versionedObjectId, version);
    }

    @Override
    @GetMapping(path={"/{versioned_object_uid}/version"})
    public ResponseEntity<OriginalVersionResponseData<Composition>> retrieveVersionOfCompositionByTime(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @RequestParam(value="version_at_time", required=false) String versionAtTime) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedCompoUid = this.getCompositionVersionedObjectUidString(versionedObjectUid);
        this.checkForValidEhrAndCompositionParameter(ehrId, versionedCompoUid);
        Optional<OffsetDateTime> temporal = OpenehrVersionedCompositionController.decodeVersionAtTime(versionAtTime);
        int version = temporal.isPresent() ? this.compositionService.getVersionByTimestamp(versionedCompoUid, temporal.get()) : this.compositionService.getLastVersionNumber(versionedCompoUid);
        String auditLocation = this.getLocationUrl(versionedCompoUid, ehrId, version, "version");
        this.createRestContext(ehrId, versionedCompoUid, auditLocation);
        return this.getOriginalVersionResponseDataResponseEntity(accept, ehrId, versionedCompoUid, version);
    }

    private void checkForValidEhrAndCompositionParameter(UUID ehrId, UUID versionedCompoUid) {
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("EHR", "No EHR with this ID can be found");
        }
        if (!this.compositionService.exists(versionedCompoUid)) {
            throw new ObjectNotFoundException("COMPOSITION", "No composition with this ID can be found.");
        }
    }

    private ResponseEntity<OriginalVersionResponseData<Composition>> getOriginalVersionResponseDataResponseEntity(String accept, UUID ehrId, UUID versionedObjectId, int version) {
        Optional compositionOriginalVersion = this.compositionService.getOriginalVersionComposition(ehrId, versionedObjectId, version);
        UUID contributionId = compositionOriginalVersion.map(i -> UUID.fromString(i.getContribution().getId().getValue())).orElseThrow(() -> new ObjectNotFoundException("ORIGINAL_VERSION", "No VERSIONED_COMPOSITION with given id: %s and version: %d".formatted(versionedObjectId, version)));
        ContributionDto contributionDto = this.contributionService.getContribution(ehrId, contributionId);
        OriginalVersionResponseData originalVersionResponseData = new OriginalVersionResponseData((OriginalVersion)compositionOriginalVersion.orElseThrow(() -> new InternalServerException("Composition exists but can't be retrieved as Original Version.")), contributionDto);
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(this.resolveContentType(accept));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).body((Object)originalVersionResponseData);
    }

    private void createRestContext(UUID ehrId, UUID versionedCompoUid, String auditLocation) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)ehrId, (HttpRestContext.CtxAttr)HttpRestContext.TEMPLATE_ID, (Object)this.compositionService.retrieveTemplateId(versionedCompoUid), (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)auditLocation);
    }

    private String getLocationUrl(UUID versionedObjectUid, UUID ehrId, int version, String ... pathSegments) {
        if (version == 0) {
            version = this.compositionService.getLastVersionNumber(versionedObjectUid);
        }
        String versionedComposition = String.format("%s::%s::%s", versionedObjectUid, this.systemService.getSystemId(), version);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", ehrId.toString(), "versioned_composition", versionedComposition});
        if (pathSegments.length > 0) {
            uriComponentsBuilder.pathSegment(pathSegments);
        }
        return uriComponentsBuilder.build().toString();
    }
}

