/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.UUID;
import org.ehrbase.api.dto.EhrStatusDto;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.EhrStatusApiSpecification;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrehrstatuscontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr/{ehr_id}/ehr_status"})
public class OpenehrEhrStatusController
extends BaseController
implements EhrStatusApiSpecification {
    private final EhrService ehrService;

    public OpenehrEhrStatusController(EhrService ehrService) {
        this.ehrService = ehrService;
    }

    @Override
    @GetMapping(produces={"application/json", "application/xml"})
    public ResponseEntity<EhrStatusDto> getEhrStatusVersionByTime(@PathVariable(name="ehr_id") UUID ehrId, @RequestParam(name="version_at_time", required=false) String versionAtTime) {
        ObjectVersionId objectVersionId;
        if (versionAtTime != null) {
            OffsetDateTime time = OpenehrEhrStatusController.decodeVersionAtTime(versionAtTime).orElseThrow();
            objectVersionId = this.ehrService.getEhrStatusVersionByTimestamp(ehrId, time);
        } else {
            objectVersionId = this.ehrService.getLatestVersionUidOfStatus(ehrId);
        }
        UUID ehrStatusId = this.extractVersionedObjectUidFromVersionUid(objectVersionId.getValue());
        int version = this.extractVersionFromVersionUid(objectVersionId.getValue()).orElseThrow();
        OriginalVersion<EhrStatusDto> originalVersion = this.ehrStatusVersion(ehrId, ehrStatusId, version);
        return this.responseBuilder(HttpStatus.OK, ehrId, originalVersion).body((Object)((EhrStatusDto)originalVersion.getData()));
    }

    @Override
    @GetMapping(path={"/{version_uid}"}, produces={"application/json", "application/xml"})
    public ResponseEntity<EhrStatusDto> getEhrStatusByVersionId(@PathVariable(name="ehr_id") UUID ehrId, @PathVariable(name="version_uid") String versionUid) {
        UUID ehrStatusId = this.extractVersionedObjectUidFromVersionUid(versionUid);
        int version = this.extractVersionFromVersionUid(versionUid).orElseThrow(() -> new InvalidApiParameterException("VERSION UID parameter does not contain a version"));
        OriginalVersion<EhrStatusDto> originalVersion = this.ehrStatusVersion(ehrId, ehrStatusId, version);
        return this.responseBuilder(HttpStatus.OK, ehrId, originalVersion).body((Object)((EhrStatusDto)originalVersion.getData()));
    }

    @Override
    @PutMapping(consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    public ResponseEntity<EhrStatusDto> updateEhrStatus(@PathVariable(value="ehr_id") UUID ehrId, @RequestHeader(name="If-Match") String versionUid, @RequestHeader(name="Prefer", required=false) String prefer, @RequestBody EhrStatusDto ehrStatusDto) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)ehrId);
        ObjectVersionId targetObjId = new ObjectVersionId(versionUid);
        EhrService.EhrResult ehrResult = this.ehrService.updateStatus(ehrId, ehrStatusDto, targetObjId, null, null);
        ObjectVersionId statusUid = ehrResult.statusVersionId();
        int version = this.extractVersionFromVersionUid(statusUid.getValue()).orElseThrow();
        UUID ehrStatusId = UUID.fromString(statusUid.getObjectId().getValue());
        OriginalVersion<EhrStatusDto> originalVersion = this.ehrStatusVersion(ehrId, ehrStatusId, version);
        if ("return=representation".equals(prefer)) {
            return this.responseBuilder(HttpStatus.OK, ehrId, originalVersion).body((Object)((EhrStatusDto)originalVersion.getData()));
        }
        return this.responseBuilder(HttpStatus.NO_CONTENT, ehrId, originalVersion).build();
    }

    private ResponseEntity.BodyBuilder responseBuilder(HttpStatus status, UUID ehrId, OriginalVersion<EhrStatusDto> originalVersion) {
        this.createRestContext(ehrId, originalVersion.getUid());
        ObjectVersionId versionId = originalVersion.getUid();
        URI uri = this.createLocationUri("ehr", ehrId.toString(), "ehr_status", versionId.getValue());
        return (ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).location(uri)).eTag("\"" + versionId.getValue() + "\"")).lastModified(OpenehrEhrStatusController.lastModifiedValue(originalVersion.getCommitAudit().getTimeCommitted()));
    }

    private OriginalVersion<EhrStatusDto> ehrStatusVersion(UUID ehrId, UUID ehrStatusId, int version) {
        return (OriginalVersion)this.ehrService.getEhrStatusAtVersion(ehrId, ehrStatusId, version).orElseThrow(() -> new ObjectNotFoundException("EHR_STATUS", "Could not find EhrStatus[id=%s, version=%s]".formatted(ehrStatusId.toString(), version)));
    }

    private static Instant lastModifiedValue(DvDateTime dvDateTime) {
        TemporalAccessor timeCommitted = dvDateTime.getValue();
        if (timeCommitted.query(TemporalQueries.zone()) != null) {
            return ZonedDateTime.from(timeCommitted).toInstant();
        }
        return LocalDateTime.from(timeCommitted).toInstant(ZoneOffset.UTC);
    }

    private void createRestContext(UUID ehrId, ObjectVersionId versionId) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)ehrId, (HttpRestContext.CtxAttr)HttpRestContext.DIRECTORY_ID, (Object)versionId.getValue(), (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", ehrId.toString(), "ehr_status", versionId.getValue()}).build().toString());
    }
}

