/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.specification;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import org.ehrbase.api.dto.EhrStatusDto;
import org.springframework.http.ResponseEntity;

@Tag(name="EHR_STATUS")
public interface EhrStatusApiSpecification {
    @Operation(summary="Get EHR_STATUS version by time", responses={@ApiResponse(responseCode="200", description="OK, is returned when the requested EHR_STATUS is successfully retrieved.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EhrStatusDto.class)), examples={@ExampleObject(value="{\n    \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n    \"name\": {\n        \"value\": \"EHR status\"\n    },\n    \"uid\": {\n        \"_type\": \"OBJECT_VERSION_ID\",\n        \"value\": \"9e3eb79b-1caa-4ab9-8cd4-d374b7c42bb4::local.ehrbase.org::1\"\n    },\n    \"subject\": {\n        \"_type\": \"PARTY_SELF\"\n    },\n    \"is_queryable\": true,\n    \"is_modifiable\": true\n}\n")})}), @ApiResponse(responseCode="400", description="Bad Request, is returned when the request has invalid content such as an invalid <code>version_at_time</code> format.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found, is returned when an EHR with <code>ehr_id</code> does not exist, or when a version of the resource identified by the request parameters (at specified <code>version_at_time</code>) does not exist.", content={@Content(schema=@Schema(hidden=true))})}, externalDocs=@ExternalDocumentation(url="https://specifications.openehr.org/releases/ITS-REST/latest/ehr.html#ehr_status-ehr_status-get"))
    public ResponseEntity<EhrStatusDto> getEhrStatusVersionByTime(UUID var1, String var2);

    @Operation(summary="Get EHR_STATUS by version id", responses={@ApiResponse(responseCode="200", description="OK, is returned when the requested EHR_STATUS is successfully retrieved.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EhrStatusDto.class)), examples={@ExampleObject(value="{\n    \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n    \"name\": {\n        \"value\": \"EHR status\"\n    },\n    \"uid\": {\n        \"_type\": \"OBJECT_VERSION_ID\",\n        \"value\": \"9e3eb79b-1caa-4ab9-8cd4-d374b7c42bb4::local.ehrbase.org::1\"\n    },\n    \"subject\": {\n        \"_type\": \"PARTY_SELF\"\n    },\n    \"is_queryable\": true,\n    \"is_modifiable\": true\n}\n")})}), @ApiResponse(responseCode="404", description="Not Found, is returned when an EHR with <code>ehr_id</code> does not exist, or when the <code>version_uid</code> does not exist.", content={@Content(schema=@Schema(hidden=true))})}, externalDocs=@ExternalDocumentation(url="https://specifications.openehr.org/releases/ITS-REST/latest/ehr.html#ehr_status-ehr_status-get-1"))
    public ResponseEntity<EhrStatusDto> getEhrStatusByVersionId(UUID var1, String var2);

    @Operation(summary="Update EHR_STATUS", requestBody=@RequestBody(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EhrStatusDto.class)), examples={@ExampleObject(value="{\n    \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n    \"name\": {\n        \"value\": \"EHR status\"\n    },\n    \"uid\": {\n        \"_type\": \"OBJECT_VERSION_ID\",\n        \"value\": \"9e3eb79b-1caa-4ab9-8cd4-d374b7c42bb4::local.ehrbase.org::1\"\n    },\n    \"subject\": {\n        \"_type\": \"PARTY_SELF\"\n    },\n    \"is_queryable\": true,\n    \"is_modifiable\": true\n}\n")})}), responses={@ApiResponse(responseCode="200", description="OK, is returned when the EHR_STATUS is successfully updated, and the updated resource is returned in the body when <code>Prefer</code> header value is <code>return=representation</code>.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EhrStatusDto.class)), examples={@ExampleObject(value="{\n    \"archetype_node_id\": \"openEHR-EHR-EHR_STATUS.generic.v1\",\n    \"name\": {\n        \"value\": \"EHR status\"\n    },\n    \"uid\": {\n        \"_type\": \"OBJECT_VERSION_ID\",\n        \"value\": \"9e3eb79b-1caa-4ab9-8cd4-d374b7c42bb4::local.ehrbase.org::1\"\n    },\n    \"subject\": {\n        \"_type\": \"PARTY_SELF\"\n    },\n    \"is_queryable\": true,\n    \"is_modifiable\": true\n}\n")})}), @ApiResponse(responseCode="204", description="No Content, is returned when the <code>Prefer</code> header is missing or is set to <code>return=minimal</code>", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="400", description="Bad Request, is returned when the request URL or body (if provided) could not be parsed or has invalid content.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found, is returned when an EHR with <code>ehr_id</code> does not exist.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="412", description="Precondition Failed, is returned when <code>If-Match</code> request header doesn't match the latest version on the service side. Returns also latest <code>version_uid</code> in the <code>Location</code> and <codeETag></code> headers.", content={@Content(schema=@Schema(hidden=true))})}, externalDocs=@ExternalDocumentation(url="https://specifications.openehr.org/releases/ITS-REST/latest/ehr.html#ehr_status-ehr_status-put"))
    public ResponseEntity<EhrStatusDto> updateEhrStatus(UUID var1, String var2, String var3, EhrStatusDto var4);
}

