/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.experimental;

import com.google.common.annotations.VisibleForTesting;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.ehrbase.api.dto.experimental.ItemTagDto;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.service.experimental.ItemTagService;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.experimental.ItemTagApiSpecification;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnMissingBean(name={"primaryopenehritemtagcontroller"})
@RestController
@RequestMapping(path={"${ehrbase.rest.experimental.tags.context-path:/rest/experimental/tags}/ehr"}, produces={"application/json"})
@ConditionalOnProperty(name={"ehrbase.rest.experimental.tags.enabled"}, havingValue="true")
public class ItemTagController
extends BaseController
implements ItemTagApiSpecification {
    private final ItemTagService itemTagService;

    public ItemTagController(ItemTagService itemTagService) {
        this.itemTagService = itemTagService;
    }

    @Override
    @PutMapping(value={"/{ehr_id}/ehr_status/{versioned_object_uid}/item_tag"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Object> upsertEhrStatusItemTags(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Prefer", required=false) String prefer, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @RequestBody List<ItemTagDto> itemTags) {
        return this.upsertItemTags(prefer, ehrIdString, versionedObjectUid, ItemTagDto.ItemTagRMType.EHR_STATUS, "ehr_status", itemTags);
    }

    @Override
    @GetMapping(value={"/{ehr_id}/ehr_status/{versioned_object_uid}/item_tag"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<List<ItemTagDto>> getEhrStatusItemTags(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @RequestParam(value="ids", required=false) List<String> ids, @RequestParam(value="keys", required=false) List<String> keys) {
        return this.getItemTag(ehrIdString, versionedObjectUid, ItemTagDto.ItemTagRMType.EHR_STATUS, "ehr_status", ids, keys);
    }

    @Override
    @DeleteMapping(value={"/{ehr_id}/ehr_status/{versioned_object_uid}/item_tag"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteEhrStatusItemTags(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @RequestBody List<Object> itemTagsOrUUIDs) {
        return this.deleteTags(ehrIdString, versionedObjectUid, ItemTagDto.ItemTagRMType.EHR_STATUS, itemTagsOrUUIDs);
    }

    @Override
    @PutMapping(value={"/{ehr_id}/composition/{versioned_object_uid}/item_tag"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Object> upsertCompositionItemTags(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Prefer", required=false) String prefer, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @RequestBody List<ItemTagDto> itemTags) {
        return this.upsertItemTags(prefer, ehrIdString, versionedObjectUid, ItemTagDto.ItemTagRMType.COMPOSITION, "composition", itemTags);
    }

    @Override
    @GetMapping(value={"/{ehr_id}/composition/{versioned_object_uid}/item_tag"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<List<ItemTagDto>> getCompositionItemTags(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @RequestParam(value="ids", required=false) List<String> ids, @RequestParam(value="keys", required=false) List<String> keys) {
        return this.getItemTag(ehrIdString, versionedObjectUid, ItemTagDto.ItemTagRMType.COMPOSITION, "composition", ids, keys);
    }

    @Override
    @DeleteMapping(value={"/{ehr_id}/composition/{versioned_object_uid}/item_tag"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> deleteCompositionItemTags(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @RequestBody List<Object> itemTagsOrUUIDs) {
        return this.deleteTags(ehrIdString, versionedObjectUid, ItemTagDto.ItemTagRMType.COMPOSITION, itemTagsOrUUIDs);
    }

    @VisibleForTesting
    ResponseEntity<Object> upsertItemTags(String prefer, String ehrIdString, String versionedObjectUid, ItemTagDto.ItemTagRMType itemTagType, String locationPart, List<ItemTagDto> itemTags) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID compositionUid = this.extractVersionedObjectUidFromVersionUid(versionedObjectUid);
        if (itemTags.isEmpty()) {
            throw new UnprocessableEntityException("ItemTags are empty");
        }
        List tagIds = this.itemTagService.bulkUpsert(ehrId, compositionUid, itemTagType, itemTags);
        URI uri = this.createLocationUri("ehr", ehrId.toString(), locationPart, versionedObjectUid, "item_tag");
        ResponseEntity.BodyBuilder bodyBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.ok().location(uri);
        if ("return=representation".equals(prefer)) {
            List tags = this.itemTagService.findItemTag(ehrId, compositionUid, itemTagType, (Collection)tagIds, List.of());
            return bodyBuilder.body((Object)tags);
        }
        return bodyBuilder.body((Object)tagIds);
    }

    @VisibleForTesting
    ResponseEntity<List<ItemTagDto>> getItemTag(String ehrIdString, String versionedObjectUid, ItemTagDto.ItemTagRMType itemTagType, String locationPart, @Nullable List<String> ids, @Nullable List<String> keys) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID compositionUid = this.extractVersionedObjectUidFromVersionUid(versionedObjectUid);
        List tagKeys = Optional.ofNullable(keys).orElseGet(List::of);
        List tagIDs = Optional.ofNullable(ids).map(it -> it.stream().map(UUID::fromString).toList()).orElseGet(List::of);
        List itemTags = this.itemTagService.findItemTag(ehrId, compositionUid, itemTagType, (Collection)tagIDs, (Collection)tagKeys);
        URI uri = this.createLocationUri("ehr", ehrId.toString(), locationPart, versionedObjectUid, "item_tag");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().location(uri)).body((Object)itemTags);
    }

    @VisibleForTesting
    ResponseEntity<Void> deleteTags(String ehrIdString, String versionedObjectUid, ItemTagDto.ItemTagRMType itemTagType, @Nonnull List<Object> itemTagsOrUUIDs) {
        if (itemTagsOrUUIDs.isEmpty()) {
            throw new UnprocessableEntityException("ItemTags are empty");
        }
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID compositionUid = this.extractVersionedObjectUidFromVersionUid(versionedObjectUid);
        List<UUID> tagIDs = itemTagsOrUUIDs.stream().map(entry -> {
            Object object = entry;
            Objects.requireNonNull(object);
            Object selector0$temp = object;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Map.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    String s;
                    yield s = (String)selector0$temp;
                }
                case 1 -> {
                    Map map = (Map)selector0$temp;
                    yield Optional.ofNullable(map.get("id")).map(Object::toString).orElseThrow(() -> new UnprocessableEntityException("Expected ItemTag entry to contain an 'id'"));
                }
                default -> throw new UnprocessableEntityException("Expected array entry to be ItemTag or UUID String");
            };
        }).map(UUID::fromString).toList();
        this.itemTagService.bulkDelete(ehrId, compositionUid, itemTagType, tagIDs);
        return ResponseEntity.noContent().build();
    }
}

