/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.admin;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.openehr.sdk.response.dto.admin.AdminDeleteResponseData;
import org.ehrbase.openehr.sdk.response.dto.admin.AdminStatusResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.admin.AdminApiConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnMissingBean(name={"primaryadmintemplatecontroller"})
@ConditionalOnProperty(prefix="admin-api", name={"active"})
@Tag(name="Admin - Template")
@RestController
@RequestMapping(path={"${admin-api.context-path:/rest/admin}/template"}, produces={"application/json", "application/xml"})
public class AdminTemplateController
extends BaseController {
    TemplateService templateService;
    @Autowired
    AdminApiConfiguration adminApiConfiguration;

    @Autowired
    public AdminTemplateController(TemplateService templateService) {
        this.templateService = templateService;
    }

    @PutMapping(path={"/{template_id}"}, consumes={"application/xml"}, produces={"application/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Template has been updated successfully.", headers={@Header(name="Content-Type", description="Format of response")}), @ApiResponse(responseCode="401", description="Client credentials are invalid or have expired."), @ApiResponse(responseCode="403", description="Client has no access permission since admin role is missing."), @ApiResponse(responseCode="404", description="Template could not be found."), @ApiResponse(responseCode="422", description="Template could not be replaced since it is used in at least one Composition.")})
    public ResponseEntity<String> updateTemplate(@Parameter(description="Client should specify expected format") @RequestHeader(value="Accept", required=false, defaultValue="application/xml") String accept, @Parameter(description="Client may request content format") @RequestHeader(value="Content-Type") String contentType, @Parameter(description="Target template id to update. The value comes from the 'template_id' property.") @PathVariable(value="template_id") String templateId, @Parameter(description="New template content to replace old one with") @RequestBody String content) {
        String updatedTemplate = this.templateService.adminUpdateTemplate(templateId, content);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/xml");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)updatedTemplate);
    }

    @DeleteMapping(path={"/{template_id}"})
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Template has been deleted successfully."), @ApiResponse(responseCode="401", description="Client credentials are invalid or have expired."), @ApiResponse(responseCode="403", description="Client has no access permission since admin role is missing."), @ApiResponse(responseCode="404", description="Template could not be found."), @ApiResponse(responseCode="422", description="The template is still used by compositions and cannot be deleted.")})
    public ResponseEntity<AdminDeleteResponseData> deleteTemplate(@Parameter(description="Target template id to delete. The value comes from the 'template_id' property.") @PathVariable(value="template_id") String templateId) {
        this.templateService.adminDeleteTemplate(templateId);
        return ResponseEntity.ok().body((Object)new AdminDeleteResponseData(1));
    }

    @DeleteMapping(path={"/all"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All templates have been removed successfully", headers={@Header(name="Content-Type", description="Format of response")}), @ApiResponse(responseCode="401", description="Client credentials are invalid or have expired."), @ApiResponse(responseCode="403", description="Client has no access permission since admin role is missing."), @ApiResponse(responseCode="404", description="Template could not be found."), @ApiResponse(responseCode="422", description="There are templates that are used by compositions and cannot be removed.")})
    public ResponseEntity<?> deleteAllTemplates() {
        if (!this.adminApiConfiguration.getAllowDeleteAll()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED).body((Object)new AdminStatusResponseData("Delete all resources not allowed."));
        }
        int deleted = this.templateService.adminDeleteAllTemplates();
        return ResponseEntity.ok().body((Object)new AdminDeleteResponseData(deleted));
    }
}

