/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.changecontrol.VersionedObject;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.ehrbase.api.dto.EhrStatusDto;
import org.ehrbase.api.dto.VersionedEhrStatusDto;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.openehr.sdk.response.dto.OriginalVersionResponseData;
import org.ehrbase.openehr.sdk.response.dto.RevisionHistoryResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.ContributionDto;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.VersionedEhrStatusApiSpecification;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrversionedehrstatuscontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr/{ehr_id}/versioned_ehr_status"}, produces={"application/json", "application/xml"})
public class OpenehrVersionedEhrStatusController
extends BaseController
implements VersionedEhrStatusApiSpecification {
    private static final String REVISION_HISTORY = "revision_history";
    private final ContributionService contributionService;
    private final EhrService ehrService;

    public OpenehrVersionedEhrStatusController(EhrService ehrService, ContributionService contributionService) {
        this.ehrService = Objects.requireNonNull(ehrService);
        this.contributionService = Objects.requireNonNull(contributionService);
    }

    @Override
    @GetMapping
    public ResponseEntity<VersionedEhrStatusDto> retrieveVersionedEhrStatusByEhr(@PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        this.createRestContext(ehrId, Map.of(), new String[0]);
        VersionedObject versionedEhrStatus = this.ehrService.getVersionedEhrStatus(ehrId);
        VersionedEhrStatusDto versionedEhrStatusDto = new VersionedEhrStatusDto(versionedEhrStatus.getUid(), versionedEhrStatus.getOwnerId(), DateTimeFormatter.ISO_DATE_TIME.format(versionedEhrStatus.getTimeCreated().getValue()));
        return ResponseEntity.ok().body((Object)versionedEhrStatusDto);
    }

    @Override
    @GetMapping(path={"/revision_history"})
    public ResponseEntity<RevisionHistoryResponseData> retrieveVersionedEhrStatusRevisionHistoryByEhr(@PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        RevisionHistory revisionHistory = this.ehrService.getRevisionHistoryOfVersionedEhrStatus(ehrId);
        this.createRestContext(ehrId, Map.of(), REVISION_HISTORY);
        return ResponseEntity.ok().body((Object)new RevisionHistoryResponseData(revisionHistory));
    }

    @Override
    @GetMapping(path={"/version"})
    public ResponseEntity<OriginalVersionResponseData<EhrStatusDto>> retrieveVersionOfEhrStatusByTime(@PathVariable(value="ehr_id") String ehrIdString, @RequestParam(value="version_at_time", required=false) String versionAtTime) {
        Map<Object, Object> contextParams;
        ObjectVersionId objectVersionId;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        if (versionAtTime != null) {
            OffsetDateTime time = OpenehrVersionedEhrStatusController.decodeVersionAtTime(versionAtTime).orElseThrow();
            objectVersionId = this.ehrService.getEhrStatusVersionByTimestamp(ehrId, time);
            contextParams = Map.of("version_at_time", versionAtTime);
        } else {
            objectVersionId = this.ehrService.getLatestVersionUidOfStatus(ehrId);
            contextParams = Map.of();
        }
        int version = this.extractVersionFromVersionUid(objectVersionId.getValue()).orElseThrow();
        UUID ehrStatusId = this.extractVersionedObjectUidFromVersionUid(objectVersionId.getValue());
        return this.retrieveVersionOfEhrStatus(ehrId, ehrStatusId, version, versionId -> this.createRestContext(ehrId, contextParams, "version"));
    }

    @Override
    @GetMapping(path={"/version/{version_uid}"})
    public ResponseEntity<OriginalVersionResponseData<EhrStatusDto>> retrieveVersionOfEhrStatusByVersionUid(@PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="version_uid") String versionUid) {
        int version;
        UUID ehrStatusId;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        try {
            ehrStatusId = this.extractVersionedObjectUidFromVersionUid(versionUid);
            version = this.extractVersionFromVersionUid(versionUid).orElseThrow(() -> new IllegalArgumentException("no version found"));
        }
        catch (Exception e) {
            throw new InvalidApiParameterException("VERSION UID parameter has wrong format: " + e.getMessage());
        }
        return this.retrieveVersionOfEhrStatus(ehrId, ehrStatusId, version, versionId -> this.createRestContext(ehrId, Map.of(), "version", versionId.toString()));
    }

    private ResponseEntity<OriginalVersionResponseData<EhrStatusDto>> retrieveVersionOfEhrStatus(UUID ehrId, UUID ehrStatusId, int version, Consumer<ObjectVersionId> initContext) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.VERSION, (Object)version);
        OriginalVersion originalVersion = (OriginalVersion)this.ehrService.getEhrStatusAtVersion(ehrId, ehrStatusId, version).orElseThrow(() -> new ObjectNotFoundException("EHR_STATUS", "Couldn't retrieve EhrStatus with given parameters"));
        ObjectRef contribution = originalVersion.getContribution();
        UUID contributionId = UUID.fromString(contribution.getId().getValue());
        ContributionDto contributionDto = this.contributionService.getContribution(ehrId, contributionId);
        OriginalVersionResponseData originalVersionResponseData = new OriginalVersionResponseData(originalVersion, contributionDto);
        initContext.accept(originalVersionResponseData.getVersionId());
        return ResponseEntity.ok().body((Object)originalVersionResponseData);
    }

    private void createRestContext(UUID ehrId, Map<String, String> queryParams, String ... pathSegments) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", ehrId.toString(), "versioned_ehr_status"}).pathSegment(pathSegments);
        queryParams.forEach((x$0, xva$1) -> uriComponentsBuilder.queryParam(x$0, new Object[]{xva$1}));
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)ehrId, (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)uriComponentsBuilder.build().toString());
    }
}

