/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.sdk.response.dto.CompositionResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.StructuredString;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.format.CompositionRepresentation;
import org.ehrbase.rest.openehr.specification.CompositionApiSpecification;
import org.ehrbase.rest.util.InternalResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrcompositioncontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr"}, produces={"application/json", "application/xml", "application/openehr.wt.flat.schema+json", "application/openehr.wt.structured.schema+json"})
public class OpenehrCompositionController
extends BaseController
implements CompositionApiSpecification {
    private final CompositionService compositionService;
    private final SystemService systemService;

    @Autowired
    public OpenehrCompositionController(CompositionService compositionService, SystemService systemService) {
        this.compositionService = Objects.requireNonNull(compositionService);
        this.systemService = systemService;
    }

    @Override
    @PostMapping(value={"/{ehr_id}/composition"}, consumes={"application/json", "application/xml", "application/openehr.wt.flat.schema+json", "application/openehr.wt.structured.schema+json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity createComposition(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Content-Type") String contentType, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false) String prefer, @PathVariable(value="ehr_id") String ehrIdString, @RequestParam(value="templateId", required=false) String templateId, @RequestParam(value="format", required=false) String format, @RequestBody String composition) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        CompositionRepresentation requestRepresentation = this.extractCompositionRepresentation(contentType, format);
        CompositionRepresentation responseRepresentation = this.extractCompositionRepresentation(accept, format);
        Composition compoObj = this.compositionService.buildComposition(composition, requestRepresentation.format, templateId);
        UUID compositionUuid = (UUID)this.compositionService.create(ehrId, (Locatable)compoObj).orElseThrow(() -> new InternalServerException("Failed to create composition"));
        URI uri = this.createLocationUri("ehr", ehrId.toString(), "composition", compositionUuid.toString());
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<CompositionResponseData>> respData = this.buildCompositionResponseData(ehrId, compositionUuid, 1, responseRepresentation, uri, headerList, "return=representation".equals(prefer) ? () -> new CompositionResponseData(null, null) : () -> null);
        return respData.map(i -> Optional.ofNullable((CompositionResponseData)i.getResponseData()).map(StructuredString::getValue).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @Override
    @PutMapping(value={"/{ehr_id}/composition/{versioned_object_uid}"}, consumes={"application/json", "application/xml", "application/openehr.wt.flat.schema+json", "application/openehr.wt.structured.schema+json"})
    public ResponseEntity updateComposition(String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false) String prefer, @RequestHeader(value="If-Match") String ifMatch, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUidString, @RequestParam(value="templateId", required=false) String templateId, @RequestParam(value="format", required=false) String format, @RequestBody String composition) {
        Optional<InternalResponse<CompositionResponseData>> respData;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        UUID versionedObjectUid = this.getCompositionVersionedObjectUidString(versionedObjectUidString);
        CompositionRepresentation requestRepresentation = this.extractCompositionRepresentation(contentType, format);
        CompositionRepresentation responseRepresentation = this.extractCompositionRepresentation(accept, format);
        Composition compoObj = this.compositionService.buildComposition(composition, requestRepresentation.format, templateId);
        Optional<String> inputUuid = this.getUidFrom(compoObj);
        inputUuid.ifPresent(id -> {
            if (!versionedObjectUid.equals(this.extractVersionedObjectUidFromVersionUid((String)id))) {
                throw new PreconditionFailedException("UUID from input must match given versioned_object_uid in request URL");
            }
        });
        try {
            ObjectVersionId ifMatchId = new ObjectVersionId(ifMatch);
            String compositionVersionUid = ((UUID)this.compositionService.update(ehrId, ifMatchId, (Locatable)compoObj).orElseThrow(() -> new InternalServerException("Failed to create composition"))).toString();
            URI uri = this.createLocationUri("ehr", ehrId.toString(), "composition", compositionVersionUid);
            List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
            UUID compositionId = this.extractVersionedObjectUidFromVersionUid(compositionVersionUid);
            int nextVersion = Integer.parseInt(ifMatchId.getVersionTreeId().getValue()) + 1;
            respData = this.buildCompositionResponseData(ehrId, compositionId, nextVersion, responseRepresentation, uri, headerList, "return=representation".equals(prefer) ? () -> new CompositionResponseData(null, null) : () -> null);
        }
        catch (ObjectNotFoundException e) {
            return ResponseEntity.notFound().build();
        }
        return respData.map(i -> Optional.ofNullable((CompositionResponseData)i.getResponseData()).map(StructuredString::getValue).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @Override
    @DeleteMapping(value={"/{ehr_id}/composition/{preceding_version_uid}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity deleteComposition(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="preceding_version_uid") String precedingVersionUid) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        HttpHeaders headers = new HttpHeaders();
        try {
            ObjectVersionId targetObjId = new ObjectVersionId(precedingVersionUid);
            this.compositionService.delete(ehrId, targetObjId);
            int nextVersion = Integer.parseInt(targetObjId.getVersionTreeId().getValue()) + 1;
            targetObjId.getVersionTreeId().setValue(String.valueOf(nextVersion));
            URI uri = this.createLocationUri("ehr", ehrId.toString(), "composition", targetObjId.getValue());
            headers.setLocation(uri);
            headers.setETag("\"" + targetObjId.getValue() + "\"");
            headers.setLastModified(ZonedDateTime.of(LocalDateTime.now(), ZoneId.systemDefault()).toInstant().toEpochMilli());
            UUID compositionUid = UUID.fromString(targetObjId.getObjectId().getValue());
            Integer version = Integer.parseInt(targetObjId.getVersionTreeId().getValue());
            HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)ehrId, (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)this.getLocationUrl(compositionUid, ehrId, version), (HttpRestContext.CtxAttr)HttpRestContext.TEMPLATE_ID, (Object)this.compositionService.retrieveTemplateId(compositionUid));
            return ResponseEntity.noContent().headers(headers).build();
        }
        catch (ObjectNotFoundException e) {
            throw new ObjectNotFoundException("composition", "No EHR with the supplied ehr_id or no COMPOSITION with the supplied preceding_version_uid.");
        }
    }

    private String getLocationUrl(UUID versionedObjectUid, UUID ehrId, int version) {
        if (version == 0) {
            version = this.compositionService.getLastVersionNumber(ehrId, versionedObjectUid);
        }
        return UriComponentsBuilder.fromPath((String)"/{ehrSegment}/{ehrId}/{compositionSegment}/{compositionId}::{nodeName}::{version}").build(new Object[]{"ehr", ehrId.toString(), "composition", versionedObjectUid, this.systemService.getSystemId(), version}).toString();
    }

    @Override
    @GetMapping(value={"/{ehr_id}/composition/{versioned_object_uid}"})
    public ResponseEntity getComposition(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="ehr_id") String ehrIdString, @PathVariable(value="versioned_object_uid") String versionedObjectUid, @RequestParam(value="format", required=false) String format, @RequestParam(value="version_at_time", required=false) String versionAtTime) {
        int version;
        UUID ehrId = this.getEhrUuid(ehrIdString);
        CompositionRepresentation responseRepresentation = this.extractCompositionRepresentation(accept, format);
        UUID compositionUid = this.extractVersionedObjectUidFromVersionUid(versionedObjectUid);
        if (this.compositionService.isDeleted(ehrId, compositionUid, Integer.valueOf(version = this.extractVersionFromVersionUid(versionedObjectUid).or(() -> OpenehrCompositionController.decodeVersionAtTime(versionAtTime).map(t -> Optional.ofNullable(this.compositionService.getVersionByTimestamp(compositionUid, t)).orElseThrow(() -> new ObjectNotFoundException("composition", "No composition version matching the timestamp condition")))).orElseGet(() -> this.compositionService.getLastVersionNumber(ehrId, compositionUid)).intValue()))) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        URI uri = this.createLocationUri("ehr", ehrId.toString(), "composition", versionedObjectUid);
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<CompositionResponseData>> respData = this.buildCompositionResponseData(ehrId, compositionUid, version, responseRepresentation, uri, headerList, () -> new CompositionResponseData(null, null));
        return respData.map(i -> Optional.ofNullable(((CompositionResponseData)i.getResponseData()).getValue()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body(j)).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private <T extends CompositionResponseData> Optional<InternalResponse<T>> buildCompositionResponseData(UUID ehrId, UUID compositionId, int version, CompositionRepresentation responseRepresentation, URI uri, List<String> headerList, Supplier<T> factory) {
        CompositionResponseData minimalOrRepresentation = (CompositionResponseData)factory.get();
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Location": {
                    respHeaders.setLocation(uri);
                    break;
                }
                case "ETag": {
                    respHeaders.setETag("\"" + String.valueOf(compositionId) + "::" + this.systemService.getSystemId() + "::" + version + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                    break;
                }
            }
        }
        String templateId = null;
        if (minimalOrRepresentation != null) {
            CompositionResponseData objByReference = minimalOrRepresentation;
            CompositionDto compositionDto = this.compositionService.retrieve(ehrId, compositionId, Integer.valueOf(version)).map(c -> CompositionService.from((UUID)ehrId, (Composition)c)).orElseThrow(() -> new ObjectNotFoundException("composition", "Couldn't retrieve composition"));
            templateId = compositionDto.getTemplateId();
            StructuredString ss = this.compositionService.serialize(compositionDto, responseRepresentation.format);
            objByReference.setValue(ss.getValue());
            objByReference.setFormat(ss.getFormat());
            respHeaders.setContentType(responseRepresentation.mediaType);
        }
        if (StringUtils.isBlank(templateId)) {
            templateId = this.compositionService.retrieveTemplateId(compositionId);
        }
        respHeaders.addIfAbsent((Object)"EHRBase-Template-ID", templateId);
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)ehrId, (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)this.getLocationUrl(compositionId, ehrId, version), (HttpRestContext.CtxAttr)HttpRestContext.TEMPLATE_ID, (Object)templateId);
        return Optional.of(new InternalResponse<CompositionResponseData>(minimalOrRepresentation, respHeaders));
    }

    private Optional<String> getUidFrom(Composition composition) {
        return Optional.ofNullable(composition.getUid()).map(ObjectId::toString);
    }
}

