/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.specification.experimental;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.UUID;
import org.ehrbase.api.dto.experimental.ItemTagDto;
import org.springframework.http.ResponseEntity;

public interface ItemTagApiSpecification {
    @Tag(name="EHR_STATUS")
    @OperationTagUpsert
    public ResponseEntity<Object> upsertEhrStatusItemTags(String var1, String var2, @ParameterPrefer String var3, @ParameterEhrId String var4, @ParameterVersionedObjectId String var5, @RequestBody List<ItemTagDto> var6);

    @Tag(name="EHR_STATUS")
    @OperationTagsGet
    public ResponseEntity<List<ItemTagDto>> getEhrStatusItemTags(String var1, String var2, @ParameterEhrId String var3, @ParameterVersionedObjectId String var4, @ParameterFilterIds List<String> var5, @ParameterFilterKeys List<String> var6);

    @Tag(name="EHR_STATUS")
    @OperationTagsDelete
    public ResponseEntity<Void> deleteEhrStatusItemTags(String var1, String var2, @ParameterEhrId String var3, @ParameterVersionedObjectId String var4, @ParameterDeleteIDs List<Object> var5);

    @Tag(name="ITEM_TAG")
    @OperationTagUpsert
    public ResponseEntity<Object> upsertCompositionItemTags(String var1, String var2, @ParameterPrefer String var3, @ParameterEhrId String var4, @ParameterVersionedObjectId String var5, @RequestBody List<ItemTagDto> var6);

    @Tag(name="ITEM_TAG")
    @OperationTagsGet
    public ResponseEntity<List<ItemTagDto>> getCompositionItemTags(String var1, String var2, @ParameterEhrId String var3, @ParameterVersionedObjectId String var4, @ParameterFilterIds List<String> var5, @ParameterFilterKeys List<String> var6);

    @Tag(name="ITEM_TAG")
    @OperationTagsDelete
    public ResponseEntity<Void> deleteCompositionItemTags(String var1, String var2, @ParameterEhrId String var3, @ParameterVersionedObjectId String var4, @ParameterDeleteIDs List<Object> var5);

    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Parameter(description="List of ItemTag string($uuid) or entries to delete", schema=@Schema(oneOf={UUID.class, ItemTagDto.class}))
    public static @interface ParameterDeleteIDs {
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Parameter(description="Filter for tag Identifier.", schema=@Schema(type="string($uuid)"))
    public static @interface ParameterFilterIds {
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Parameter(description="Filter for tag keys.", schema=@Schema(type="string($key)"))
    public static @interface ParameterFilterKeys {
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Parameter(description="Identifier of target, which may be a VERSIONED_OBJECT<T> or a VERSION<T>.", schema=@Schema(type="string($uuid|$version)"), required=true)
    public static @interface ParameterVersionedObjectId {
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Parameter(description="Identifier of owner object, such as EHR.", schema=@Schema(type="string($uuid)"), required=true)
    public static @interface ParameterEhrId {
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Parameter(description="Preferred response type.", schema=@Schema(type="string($prefer)", allowableValues={"return=minimal", "return=representation"}), in=ParameterIn.HEADER)
    public static @interface ParameterPrefer {
    }

    @Target(value={ElementType.METHOD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Operation(summary="Deletes tags", description="Deletes all tags for matching the given uuid or ItemTag.id.", responses={@ApiResponse(responseCode="204")})
    public static @interface OperationTagsDelete {
    }

    @Target(value={ElementType.METHOD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Operation(summary="Get tags", description="Returns all tags for or filters based on the given ids and/or keys.", responses={@ApiResponse(responseCode="200", description="ItemTag for the composition", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ItemTagDto.class)))})})
    public static @interface OperationTagsGet {
    }

    @Target(value={ElementType.METHOD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Operation(summary="Create or Update tags", description="Bulk creation/update of tags. Tags without IDs are created, those with IDs are updated.", requestBody=@RequestBody(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ItemTagDto.class)), examples={@ExampleObject(value="[\n  {\n    \"key\": \"tag::1\",\n    \"value\": \"some textual value\",\n    \"target_path\": \"/context/end_time[at0001]|value\"\n  }\n]")})}), responses={@ApiResponse(responseCode="200", description="ItemTag ids in case Header Prefer is missing or contains return=minimal", content={@Content(schema=@Schema(type="uuid"))}), @ApiResponse(responseCode="200", description="ItemTag ids in case Header Prefer is missing or contains return=representation", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ItemTagDto.class)))})})
    public static @interface OperationTagUpsert {
    }
}

