/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Objects;
import org.ehrbase.api.service.StatusService;
import org.ehrbase.openehr.sdk.response.dto.StatusResponseData;
import org.ehrbase.rest.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnMissingBean(name={"primarystatuscontroller"})
@Tag(name="Status", description="Heartbeat, Version info, Status")
@RestController
@RequestMapping(path={"/rest"}, produces={"application/xml", "application/json"})
public class StatusController
extends BaseController {
    private final StatusService statusService;

    @Autowired
    public StatusController(StatusService statusService) {
        this.statusService = Objects.requireNonNull(statusService);
    }

    @GetMapping(path={"/status"})
    @Operation(summary="Get status information on running EHRbase server instance")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="EHRbase is available. Basic information on runtime and build is returned in body.", headers={@Header(name="Content-Type", description="Format of response", schema=@Schema(implementation=MediaType.class))}, content={@Content(schema=@Schema(implementation=StatusResponseData.class))})})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<StatusResponseData> getEhrbaseStatus(@Parameter(description="Client desired response data format") @RequestHeader(value="Accept", required=false, defaultValue="application/json") String accept) {
        StatusResponseData responseData = new StatusResponseData();
        responseData.setJvmVersion(this.statusService.getJavaVMInformation());
        responseData.setOsVersion(this.statusService.getOperatingSystemInformation());
        responseData.setPostgresVersion(this.statusService.getDatabaseInformation());
        responseData.setEhrbaseVersion(this.statusService.getEhrbaseVersion());
        responseData.setOpenEhrSdkVersion(this.statusService.getOpenEHR_SDK_Version());
        responseData.setArchieVersion(this.statusService.getArchieVersion());
        return ResponseEntity.ok((Object)responseData);
    }
}

