/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.ehrbase.api.dto.AqlQueryContext;
import org.ehrbase.api.service.StatusService;
import org.ehrbase.openehr.sdk.response.dto.MetaData;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component(value="requestScopedAqlQueryContext")
public class RequestScopedAqlQueryContext
implements AqlQueryContext {
    @Value(value="${ehrbase.rest.aql.response.generator-details-enabled:false}")
    boolean generatorDetailsEnabled = false;
    @Value(value="${ehrbase.rest.aql.response.executed-aql-enabled:true}")
    boolean executedAqlEnabled = true;
    @Value(value="${ehrbase.rest.aql.debugging-enabled:false}")
    boolean debuggingEnabled = false;
    private final StatusService statusService;
    private final HttpServletRequest request;
    private String executedAql;
    private final Map<String, Object> metaProperties = new LinkedHashMap<String, Object>();

    public RequestScopedAqlQueryContext(StatusService statusService, HttpServletRequest request) {
        this.statusService = statusService;
        this.request = request;
    }

    public MetaData createMetaData(URI location) {
        MetaData metaData = new MetaData();
        metaData.setCreated(OffsetDateTime.now());
        metaData.setSchemaVersion("1.0.3");
        metaData.setType("RESULTSET");
        metaData.setHref((String)Optional.ofNullable(location).map(URI::toASCIIString).orElse(null));
        if (this.generatorDetailsEnabled) {
            metaData.setGenerator("EHRBase/%s".formatted(this.statusService.getEhrbaseVersion()));
        }
        metaData.setExecutedAql(this.executedAql);
        if (this.isDryRun()) {
            this.setMetaProperty((AqlQueryContext.MetaProperty)AqlQueryContext.EhrbaseMetaProperty.DRY_RUN, true);
        }
        this.metaProperties.forEach((arg_0, arg_1) -> ((MetaData)metaData).setAdditionalProperty(arg_0, arg_1));
        return metaData;
    }

    public boolean showExecutedAql() {
        return this.executedAqlEnabled;
    }

    public boolean isDryRun() {
        return this.debuggingEnabled && this.isHeaderTrue("EHRbase-AQL-Dry-Run");
    }

    public boolean showExecutedSql() {
        return this.debuggingEnabled && this.isHeaderTrue("EHRbase-AQL-Executed-SQL");
    }

    public boolean showQueryPlan() {
        return this.debuggingEnabled && this.isHeaderTrue("EHRbase-AQL-Query-Plan");
    }

    private boolean isHeaderTrue(String header) {
        return Optional.of(header).map(arg_0 -> ((HttpServletRequest)this.request).getHeader(arg_0)).map(Boolean::valueOf).orElse(false);
    }

    public void setExecutedAql(String executedAql) {
        this.executedAql = executedAql;
    }

    public void setMetaProperty(AqlQueryContext.MetaProperty property, Object value) {
        String name = property.propertyName();
        if (value == null) {
            this.metaProperties.remove(name);
        } else {
            this.metaProperties.put(name, value);
        }
    }
}

