/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest;

import com.nimbusds.jose.util.Pair;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.lang.NonNull;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(basePackages={"org.ehrbase.rest", "org.ehrbase.rest.admin", "org.ehrbase.rest.openehr"})
@EnableAspectJAutoProxy
public class RestModuleConfiguration
implements WebMvcConfigurer {
    public static final String NONE = "none";
    @Value(value="${security.auth-type}")
    private String authType;

    public void addInterceptors(InterceptorRegistry registry) {
        if (NONE.equalsIgnoreCase(this.authType)) {
            registry.addInterceptor((HandlerInterceptor)new SecurityContextCleanupInterceptor());
        }
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new QueryParameterConverter());
    }

    public static class SecurityContextCleanupInterceptor
    implements HandlerInterceptor {
        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
            SecurityContextHolder.clearContext();
            return true;
        }
    }

    public static class QueryParameterConverter
    implements Converter<String, Map<String, Object>> {
        private static final String PARAM_ASSIGN = "=";
        private static final String PARAM_DELIM = "&";

        public Map<String, Object> convert(@NonNull String source) {
            StringTokenizer tokenizer = new StringTokenizer(source, PARAM_DELIM);
            Spliterator spliterator = Spliterators.spliterator(tokenizer.asIterator(), 1L, 16);
            return StreamSupport.stream(spliterator, false).map(t -> (String)t).map(str -> {
                String[] split = str.split(PARAM_ASSIGN, 2);
                return switch (split.length) {
                    case 1 -> Pair.of((Object)split[0], (Object)"");
                    case 2 -> Pair.of((Object)split[0], (Object)split[1]);
                    default -> Pair.of((Object)"", (Object)"");
                };
            }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        }
    }
}

