/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.composition.Composition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.api.definitions.OperationalTemplateFormat;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.openehr.sdk.response.dto.TemplateResponseData;
import org.ehrbase.openehr.sdk.response.dto.TemplatesResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionDto;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.format.CompositionRepresentation;
import org.ehrbase.rest.openehr.format.OpenEHRMediaType;
import org.ehrbase.rest.openehr.specification.TemplateApiSpecification;
import org.ehrbase.rest.util.InternalResponse;
import org.openehr.schemas.v1.TemplateDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnMissingBean(name={"primaryopenehrtemplatecontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/definition/template"}, produces={"application/json", "application/xml"})
public class OpenehrTemplateController
extends BaseController
implements TemplateApiSpecification {
    protected static final String ADL_1_4 = "adl1.4";
    private final TemplateService templateService;
    private final CompositionService compositionService;

    @Autowired
    public OpenehrTemplateController(TemplateService templateService, CompositionService compositionService) {
        this.templateService = Objects.requireNonNull(templateService);
        this.compositionService = Objects.requireNonNull(compositionService);
    }

    @Override
    @PostMapping(path={"/adl1.4"}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity createTemplateClassic(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Content-Type") String contentType, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false) String prefer, @RequestBody String template) {
        TemplateDocument document;
        if (!MediaType.parseMediaType((String)contentType).isCompatibleWith(MediaType.APPLICATION_XML)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE).body((Object)"Only XML is supported at the moment");
        }
        try {
            document = TemplateDocument.Factory.parse((InputStream)new ByteArrayInputStream(template.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException | XmlException e) {
            throw new InvalidApiParameterException(e.getMessage());
        }
        String templateId = this.templateService.create(document.getTemplate());
        URI uri = this.createLocationUri("definition", "template", ADL_1_4, templateId);
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<TemplateResponseData>> respData = Optional.ofNullable(prefer).map(i -> i.equals("return=representation")).orElse(false) != false ? this.buildTemplateResponseData(templateId, accept, uri, headerList, TemplateResponseData::new) : this.buildTemplateResponseData(templateId, accept, uri, headerList, () -> null);
        return respData.map(i -> Optional.ofNullable((TemplateResponseData)i.getResponseData()).map(j -> ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).headers(i.getHeaders())).body((Object)j.get())).orElse(ResponseEntity.noContent().headers(i.getHeaders()).build())).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @Override
    @GetMapping(value={"/adl1.4"})
    public ResponseEntity getTemplatesClassic(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Accept", required=false) String accept) {
        URI uri = this.createLocationUri("definition", "template", ADL_1_4);
        List<String> headerList = Collections.emptyList();
        Optional<InternalResponse<TemplatesResponseData>> respData = this.buildTemplateResponseData("", accept, uri, headerList, TemplatesResponseData::new);
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body((Object)((TemplatesResponseData)i.getResponseData()).get())).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @Override
    @GetMapping(value={"/adl1.4/{template_id}"})
    public ResponseEntity getTemplateClassic(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="template_id") String templateId) {
        URI uri = this.createLocationUri("definition", ADL_1_4, templateId);
        List<String> headerList = Arrays.asList("Location", "ETag", "Last-Modified");
        Optional<InternalResponse<TemplateResponseData>> respData = this.buildTemplateResponseData(templateId, accept, uri, headerList, TemplateResponseData::new);
        return respData.map(i -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(i.getHeaders())).body((Object)((TemplateResponseData)i.getResponseData()).get())).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @Override
    @GetMapping(path={"/adl1.4/{template_id}/example"}, produces={"application/json", "application/xml", "application/openehr.wt.structured.schema+json", "application/openehr.wt.flat.schema+json"})
    public ResponseEntity<String> getTemplateExample(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="template_id") String templateId, @RequestParam(value="format", required=false) String format) {
        CompositionRepresentation representation = this.extractCompositionRepresentation(accept, format);
        Composition composition = this.templateService.buildExample(templateId);
        return ResponseEntity.ok().contentType(representation.mediaType).body((Object)this.compositionService.serialize(new CompositionDto(composition, templateId, null, null), representation.format).getValue());
    }

    @Override
    @GetMapping(path={"/adl1.4/{template_id}/webtemplate"}, produces={"application/json", "application/openehr.wt+json"})
    public ResponseEntity<WebTemplate> getWebTemplate(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="template_id") String templateId) {
        MediaType mediaType = this.resolveContentType(accept, OpenEHRMediaType.APPLICATION_WT_JSON, m -> m.isCompatibleWith(OpenEHRMediaType.APPLICATION_WT_JSON) || m.isCompatibleWith(MediaType.APPLICATION_JSON));
        WebTemplate webTemplate = this.templateService.findTemplate(templateId);
        return ResponseEntity.ok().contentType(mediaType).body((Object)webTemplate);
    }

    @Override
    @PostMapping(value={"/adl2"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<TemplateResponseData> createTemplateNew(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false) String prefer, @RequestParam(value="version", required=false) String version, @RequestBody String template) {
        TemplateResponseData data = new TemplateResponseData();
        URI url = URI.create("todo");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setLocation(url);
        headers.setETag("\"something...\"");
        headers.setLastModified(1234565778L);
        return Optional.ofNullable(data).map(i -> new ResponseEntity(i, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED)).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    @Override
    @GetMapping(value={"/adl2/{template_id}/{version_pattern}"})
    public ResponseEntity<TemplateResponseData> getTemplateNew(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="template_id", required=false) String templateId, @PathVariable(value="version_pattern", required=false) String versionPattern) {
        TemplateResponseData data = new TemplateResponseData();
        URI url = URI.create("todo");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setLocation(url);
        headers.setETag("\"something...\"");
        headers.setLastModified(1234565778L);
        return Optional.ofNullable(data).map(i -> new ResponseEntity(i, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.CREATED)).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build());
    }

    private <T> Optional<InternalResponse<T>> buildTemplateResponseData(String templateId, String accept, URI uri, List<String> headerList, Supplier<T> factory) {
        OperationalTemplateFormat format;
        T oneOrAllTemplates = factory.get();
        HttpHeaders respHeaders = new HttpHeaders();
        Iterator<String> iterator = headerList.iterator();
        while (iterator.hasNext()) {
            String header;
            switch (header = iterator.next()) {
                case "Location": {
                    respHeaders.setLocation(uri);
                    break;
                }
                case "ETag": {
                    respHeaders.setETag("\"" + templateId + "\"");
                    break;
                }
                case "Last-Modified": {
                    respHeaders.setLastModified(123124442L);
                    break;
                }
            }
        }
        MediaType mediaType = this.resolveContentType(accept, MediaType.APPLICATION_XML);
        if (mediaType.isCompatibleWith(MediaType.APPLICATION_XML)) {
            format = OperationalTemplateFormat.XML;
        } else if (mediaType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
            format = OperationalTemplateFormat.JSON;
        } else {
            throw new NotAcceptableException("Currently only xml (or empty for fallback) is allowed");
        }
        if (oneOrAllTemplates != null) {
            if (oneOrAllTemplates.getClass().equals(TemplateResponseData.class)) {
                objByReference = (TemplateResponseData)oneOrAllTemplates;
                String template = this.templateService.findOperationalTemplate(templateId, format);
                objByReference.set(template);
                respHeaders.setContentType(MediaType.APPLICATION_XML);
            } else if (oneOrAllTemplates.getClass().equals(TemplatesResponseData.class)) {
                objByReference = (TemplatesResponseData)oneOrAllTemplates;
                List templates = this.templateService.getAllTemplates();
                objByReference.set(templates);
            } else {
                throw new InternalServerException("Building template response data failed");
            }
        }
        return Optional.of(new InternalResponse<T>(oneOrAllTemplates, respHeaders));
    }
}

