/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionFormat;
import org.ehrbase.rest.openehr.format.CompositionRepresentation;
import org.ehrbase.rest.openehr.format.OpenEHRMediaType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public abstract class BaseController {
    public static final String OPENEHR_AUDIT_DETAILS = "openEHR-AUDIT_DETAILS";
    public static final String OPENEHR_VERSION = "openEHR-VERSION";
    public static final String PREFER = "Prefer";
    public static final String RETURN_MINIMAL = "return=minimal";
    public static final String RETURN_REPRESENTATION = "return=representation";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT = "Accept";
    public static final String REQ_CONTENT_TYPE = "Client may request content format";
    public static final String REQ_ACCEPT = "Client should specify expected format";
    public static final String RESP_CONTENT_TYPE_DESC = "Format of response";
    public static final String LOCATION = "Location";
    public static final String ETAG = "ETag";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String IF_MATCH = "If-Match";
    public static final String EHR = "ehr";
    public static final String EHR_STATUS = "ehr_status";
    public static final String VERSIONED_EHR_STATUS = "versioned_ehr_status";
    public static final String VERSIONED_COMPOSITION = "versioned_composition";
    public static final String COMPOSITION = "composition";
    public static final String DIRECTORY = "directory";
    public static final String CONTRIBUTION = "contribution";
    public static final String QUERY = "query";
    public static final String DEFINITION = "definition";
    public static final String TEMPLATE = "template";
    public static final String API_CONTEXT_PATH = "${openehr-api.context-path:/rest/openehr}";
    public static final String API_CONTEXT_PATH_WITH_VERSION = "${openehr-api.context-path:/rest/openehr}/v1";
    public static final String ADMIN_API_CONTEXT_PATH = "${admin-api.context-path:/rest/admin}";
    @Value(value="${openehr-api.context-path:/rest/openehr}/v1")
    protected String apiContextPathWithVersion;

    public String getContextPath() {
        return ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
    }

    protected URI createLocationUri(String ... pathSegments) {
        return UriComponentsBuilder.fromHttpUrl((String)this.getContextPath()).path(UriUtils.encodePath((String)this.apiContextPathWithVersion, (String)"UTF-8")).pathSegment(pathSegments).build().toUri();
    }

    protected UUID parseUUID(String uuidString, String error) {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidApiParameterException(error);
        }
    }

    protected UUID getEhrUuid(String ehrIdString) {
        return this.extractUUIDFromStringWithError(ehrIdString, EHR, "EHR not found, in fact, only UUID-type IDs are supported");
    }

    protected UUID getCompositionVersionedObjectUidString(String compositionVersionedObjectUidString) {
        return this.extractUUIDFromStringWithError(compositionVersionedObjectUidString, COMPOSITION, "Composition not found, in fact, only UUID-type versionedObjectUids are supported");
    }

    protected UUID getContributionVersionedObjectUidString(String compositionVersionedObjectUidString) {
        return this.extractUUIDFromStringWithError(compositionVersionedObjectUidString, CONTRIBUTION, "Contribution not found, in fact, only UUID-type versionedObjectUids are supported");
    }

    private UUID extractUUIDFromStringWithError(String uuidString, String type, String error) {
        UUID uuid;
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectNotFoundException(type, error);
        }
        return uuid;
    }

    protected CompositionRepresentation extractCompositionRepresentation(String contentType, String format) {
        CompositionRepresentation representation;
        try {
            Optional<CompositionFormat> parsedFormat = Optional.ofNullable(format).filter(s -> !s.isEmpty()).map(CompositionFormat::valueOf);
            MediaType mediaType = this.resolveContentType(contentType, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, OpenEHRMediaType.APPLICATION_WT_FLAT_SCHEMA_JSON, OpenEHRMediaType.APPLICATION_WT_STRUCTURED_SCHEMA_JSON);
            representation = CompositionRepresentation.selectFromMediaTypeWithFormat(mediaType, parsedFormat.orElse(null));
        }
        catch (IllegalArgumentException e) {
            throw new NotAcceptableException("Invalid compositions format [%s] only [XML, JSON, FLAT, STRUCTURED] are supported at the moment".formatted(format));
        }
        return representation;
    }

    protected UUID extractVersionedObjectUidFromVersionUid(String versionUid) {
        if (!versionUid.contains("::")) {
            return UUID.fromString(versionUid);
        }
        return UUID.fromString(versionUid.substring(0, versionUid.indexOf("::")));
    }

    protected Optional<Integer> extractVersionFromVersionUid(String versionUid) {
        int lastOccurrence = versionUid.lastIndexOf("::");
        if (lastOccurrence > 0 && versionUid.indexOf("::") != lastOccurrence) {
            return Optional.of(Integer.parseInt(versionUid.substring(lastOccurrence + 2)));
        }
        return Optional.empty();
    }

    protected MediaType resolveContentType(String acceptHeader) {
        return this.resolveContentType(acceptHeader, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML);
    }

    protected MediaType resolveContentType(String acceptHeader, MediaType defaultMediaType, MediaType ... supportedMediaTypes) {
        List mediaTypes = MediaType.parseMediaTypes((String)acceptHeader);
        if (mediaTypes.isEmpty()) {
            return defaultMediaType;
        }
        MimeTypeUtils.sortBySpecificity((List)mediaTypes);
        MediaType contentType = mediaTypes.stream().filter(type -> Stream.concat(Stream.of(defaultMediaType), Arrays.stream(supportedMediaTypes)).anyMatch(arg_0 -> ((MediaType)type).isCompatibleWith(arg_0))).findFirst().orElseThrow(() -> new InvalidApiParameterException("Wrong Content-Type header in request"));
        if (contentType.equals((Object)MediaType.ALL)) {
            return defaultMediaType;
        }
        return contentType;
    }

    protected static Optional<OffsetDateTime> decodeVersionAtTime(String versionAtTimeParam) {
        return Optional.ofNullable(versionAtTimeParam).filter(StringUtils::isNotBlank).map(s -> s.replace(' ', '+')).map(s -> {
            try {
                DvDateTime dvDateTime = new DvDateTime(s);
                TemporalAccessor patt0$temp = dvDateTime.getValue();
                if (patt0$temp instanceof OffsetDateTime) {
                    OffsetDateTime offsetDateTime = (OffsetDateTime)patt0$temp;
                    return offsetDateTime;
                }
                TemporalAccessor patt1$temp = dvDateTime.getValue();
                if (patt1$temp instanceof LocalDateTime) {
                    LocalDateTime localDateTime = (LocalDateTime)patt1$temp;
                    return localDateTime.atOffset(ZoneOffset.UTC);
                }
                throw new IllegalArgumentException("Value '%s' is not valid for version_at_time parameter. Value must be in the extended ISO 8601 format.".formatted(versionAtTimeParam));
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Value '%s' is not valid for version_at_time parameter. Value must be in the extended ISO 8601 format.".formatted(versionAtTimeParam), e);
            }
        });
    }
}

