/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.GeneralRequestProcessingException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.exception.UnsupportedMediaTypeException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.StoredQueryService;
import org.ehrbase.openehr.sdk.response.dto.QueryDefinitionListResponseData;
import org.ehrbase.openehr.sdk.response.dto.QueryDefinitionResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.DefinitionQueryApiSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrdefinitionquerycontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/definition/query"}, produces={"application/json", "application/xml"})
public class OpenehrDefinitionQueryController
extends BaseController
implements DefinitionQueryApiSpecification {
    private static final String AQL = "AQL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final StoredQueryService storedQueryService;

    @Autowired
    public OpenehrDefinitionQueryController(StoredQueryService storedQueryService) {
        this.storedQueryService = Objects.requireNonNull(storedQueryService);
    }

    @Override
    @GetMapping(value={"/{qualified_query_name}", ""})
    public ResponseEntity<QueryDefinitionListResponseData> getStoredQueryList(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name", required=false) String qualifiedQueryName) {
        this.logger.debug("getStoredQueryList invoked with the following input: {}", (Object)qualifiedQueryName);
        this.registerLocation(qualifiedQueryName, null);
        QueryDefinitionListResponseData responseData = new QueryDefinitionListResponseData(this.storedQueryService.retrieveStoredQueries(qualifiedQueryName));
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_ID, (Object)qualifiedQueryName);
        return ResponseEntity.ok((Object)responseData);
    }

    @Override
    @GetMapping(value={"/{qualified_query_name}/{version}"})
    public ResponseEntity<QueryDefinitionResponseData> getStoredQueryVersion(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name") String qualifiedQueryName, @PathVariable(value="version") Optional<String> version) {
        this.logger.debug("getStoredQueryVersion invoked with the following input: {}, version:{}", (Object)qualifiedQueryName, version);
        this.registerLocation(qualifiedQueryName, version.orElse(null));
        QueryDefinitionResponseData queryDefinitionResponseData = new QueryDefinitionResponseData(this.storedQueryService.retrieveStoredQuery(qualifiedQueryName, (String)version.orElse(null)));
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_ID, (Object)qualifiedQueryName);
        return ResponseEntity.ok((Object)queryDefinitionResponseData);
    }

    @Override
    @PutMapping(value={"/{qualified_query_name}/{version}", "/{qualified_query_name}"}, consumes={"text/plain", "application/json"}, produces={"application/json"})
    public ResponseEntity<QueryDefinitionResponseData> putStoredQuery(@RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="qualified_query_name") String qualifiedQueryName, @PathVariable(value="version") Optional<String> version, @RequestParam(value="type", required=false, defaultValue="AQL") String type, @RequestBody String queryPayload) {
        String aql;
        if (!AQL.equalsIgnoreCase(type)) {
            throw new InvalidApiParameterException("Query type:%s not supported!".formatted(type));
        }
        MediaType mediaType = MediaType.parseMediaType((String)contentType);
        if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
            aql = Optional.of(queryPayload).map(p -> {
                try {
                    return new ObjectMapper().readTree(p);
                }
                catch (JsonProcessingException e) {
                    throw new GeneralRequestProcessingException("Invalid content format", (Throwable)e);
                }
            }).map(n -> n.get("q")).filter(JsonNode::isTextual).map(JsonNode::asText).orElse(null);
        } else if (MediaType.TEXT_PLAIN.isCompatibleWith(mediaType)) {
            aql = queryPayload;
        } else {
            throw new UnsupportedMediaTypeException(mediaType.getType());
        }
        if (StringUtils.isBlank((CharSequence)aql)) {
            throw new InvalidApiParameterException("no aql query provided");
        }
        this.registerLocation(qualifiedQueryName, version.orElse(null));
        QueryDefinitionResultDto storedQuery = this.storedQueryService.createStoredQuery(qualifiedQueryName, (String)version.orElse(null), aql);
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.QUERY_ID, (Object)qualifiedQueryName);
        return this.getPutDefenitionResponseEntity(mediaType, storedQuery);
    }

    private ResponseEntity<QueryDefinitionResponseData> getPutDefenitionResponseEntity(MediaType mediaType, QueryDefinitionResultDto storedQuery) {
        if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
            return ResponseEntity.ok((Object)new QueryDefinitionResponseData(storedQuery));
        }
        if (MediaType.TEXT_PLAIN.isCompatibleWith(mediaType)) {
            HttpHeaders respHeaders = new HttpHeaders();
            respHeaders.setContentType(MediaType.APPLICATION_JSON);
            respHeaders.setLocation(this.createLocationUri("definition", "query", storedQuery.getQualifiedName(), storedQuery.getVersion()));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(respHeaders)).build();
        }
        throw new UnexpectedSwitchCaseException(mediaType.getType());
    }

    private void registerLocation(String queryName, @Nullable String version) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"definition", "query", queryName, version}).build().toString());
    }
}

