/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.support.identification.HierObjectId;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.openehr.sdk.response.dto.EhrResponseData;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.EhrApiSpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrehrcontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr"}, produces={"application/json", "application/xml"})
public class OpenehrEhrController
extends BaseController
implements EhrApiSpecification {
    private final EhrService ehrService;
    private final SystemService systemService;

    @Autowired
    public OpenehrEhrController(EhrService ehrService, SystemService systemService) {
        this.ehrService = Objects.requireNonNull(ehrService);
        this.systemService = systemService;
    }

    @Override
    @PostMapping(consumes={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EhrResponseData> createEhr(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Prefer", required=false, defaultValue="return=minimal") String prefer, @RequestBody(required=false) EhrStatus ehrStatus) {
        UUID ehrId = this.ehrService.create(null, ehrStatus);
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)ehrId);
        ResponseEntity.BodyBuilder bodyBuilder = this.ehrResponseBuilder(HttpStatus.CREATED, ehrId);
        if ("return=representation".equals(prefer)) {
            EhrResponseData ehrResponseData = this.ehrResponseData(ehrId);
            return bodyBuilder.body((Object)ehrResponseData);
        }
        return bodyBuilder.build();
    }

    @Override
    @PutMapping(path={"/{ehr_id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EhrResponseData> createEhrWithId(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Prefer", required=false) String prefer, @PathVariable(value="ehr_id") String ehrIdString, @RequestBody(required=false) EhrStatus ehrStatus) {
        UUID newEhrId = this.parseUUID(ehrIdString, "EHR ID format not a UUID");
        UUID ehrId = this.ehrService.create(newEhrId, ehrStatus);
        this.createRestContext(ehrId);
        ResponseEntity.BodyBuilder bodyBuilder = this.ehrResponseBuilder(HttpStatus.CREATED, ehrId);
        if ("return=representation".equals(prefer)) {
            EhrResponseData ehrResponseData = this.ehrResponseData(ehrId);
            return bodyBuilder.body((Object)ehrResponseData);
        }
        return bodyBuilder.build();
    }

    @Override
    @GetMapping(path={"/{ehr_id}"})
    public ResponseEntity<EhrResponseData> getEhrById(@PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        this.createRestContext(ehrId);
        EhrResponseData ehrResponseData = this.ehrResponseData(ehrId);
        return this.ehrResponseBuilder(HttpStatus.OK, ehrId).body((Object)ehrResponseData);
    }

    @Override
    @GetMapping(params={"subject_id", "subject_namespace"})
    public ResponseEntity<EhrResponseData> getEhrBySubject(@RequestParam(value="subject_id") String subjectId, @RequestParam(value="subject_namespace") String subjectNamespace) {
        UUID ehrId = (UUID)this.ehrService.findBySubject(subjectId, subjectNamespace).orElseThrow(() -> new ObjectNotFoundException("ehr", "No EHR with supplied subject parameters found"));
        this.createRestContext(ehrId);
        EhrResponseData ehrResponseData = this.ehrResponseData(ehrId);
        return this.ehrResponseBuilder(HttpStatus.OK, ehrId).body((Object)ehrResponseData);
    }

    private EhrResponseData ehrResponseData(UUID ehrId) {
        EhrResponseData responseData = new EhrResponseData();
        responseData.setEhrId(new HierObjectId(ehrId.toString()));
        responseData.setSystemId(new HierObjectId(this.systemService.getSystemId()));
        responseData.setEhrStatus(this.ehrService.getEhrStatus(ehrId));
        responseData.setTimeCreated(this.ehrService.getCreationTime(ehrId));
        return responseData;
    }

    private ResponseEntity.BodyBuilder ehrResponseBuilder(HttpStatus status, UUID ehrId) {
        URI uri = this.createLocationUri("ehr", ehrId.toString());
        return (ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).location(uri)).eTag("\"%s\"".formatted(ehrId.toString()))).lastModified(123124442L);
    }

    private void createRestContext(UUID resultEhrId) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)resultEhrId, (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", resultEhrId.toString()}).build().toString());
    }
}

