/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.composition.Composition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.api.definitions.OperationalTemplateFormat;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.openehr.sdk.response.dto.TemplateResponseData;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.TemplateMetaDataDto;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplate;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.format.CompositionRepresentation;
import org.ehrbase.rest.openehr.format.OpenEHRMediaType;
import org.ehrbase.rest.openehr.specification.TemplateApiSpecification;
import org.openehr.schemas.v1.TemplateDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriUtils;

@ConditionalOnMissingBean(name={"primaryopenehrtemplatecontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/definition/template"})
public class OpenehrTemplateController
extends BaseController
implements TemplateApiSpecification {
    protected static final String ADL_1_4 = "adl1.4";
    private final TemplateService templateService;
    private final CompositionService compositionService;

    @Autowired
    public OpenehrTemplateController(TemplateService templateService, CompositionService compositionService) {
        this.templateService = Objects.requireNonNull(templateService);
        this.compositionService = Objects.requireNonNull(compositionService);
    }

    @Override
    @PostMapping(path={"/adl1.4"}, consumes={"application/xml"}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<String> createTemplateClassic(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Prefer", required=false) String prefer, @RequestBody String template) {
        String templateId;
        try (ByteArrayInputStream input = new ByteArrayInputStream(template.getBytes(StandardCharsets.UTF_8));){
            TemplateDocument document = TemplateDocument.Factory.parse((InputStream)input);
            templateId = this.templateService.create(document.getTemplate());
        }
        catch (IOException | XmlException e) {
            throw new InvalidApiParameterException(e.getMessage());
        }
        ResponseEntity.BodyBuilder bodyBuilder = this.templateResponseBuilder(HttpStatus.CREATED, templateId, MediaType.APPLICATION_XML);
        if ("return=representation".equals(prefer)) {
            String responseTemplate = this.templateService.findOperationalTemplate(templateId, OperationalTemplateFormat.XML);
            return bodyBuilder.body((Object)responseTemplate);
        }
        return bodyBuilder.build();
    }

    @Override
    @GetMapping(value={"/adl1.4"}, produces={"application/json", "application/xml"})
    public ResponseEntity<List<TemplateMetaDataDto>> getTemplatesClassic(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Accept", required=false) String accept) {
        URI uri = this.createLocationUri("definition", "template", ADL_1_4);
        MediaType mediaType = this.resolveContentType(accept, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML);
        List templates = this.templateService.getAllTemplates();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().location(uri)).contentType(mediaType).body((Object)templates);
    }

    @Override
    @GetMapping(value={"/adl1.4/{template_id}"}, produces={"application/xml", "application/json", "application/openehr.wt+json"})
    public ResponseEntity<Object> getTemplateClassic(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="template_id") String templateId) {
        MediaType mediaType = this.resolveContentType(accept, MediaType.APPLICATION_XML, OpenEHRMediaType.APPLICATION_WT_JSON, MediaType.APPLICATION_JSON);
        OperationalTemplateFormat format = OpenehrTemplateController.operationalTemplateFormatForMediaType(mediaType);
        ResponseEntity.BodyBuilder bodyBuilder = this.templateResponseBuilder(HttpStatus.OK, templateId, mediaType);
        if (mediaType.isCompatibleWith(MediaType.APPLICATION_XML)) {
            String operationalTemplate = this.templateService.findOperationalTemplate(templateId, format);
            return bodyBuilder.body((Object)operationalTemplate);
        }
        WebTemplate webTemplate = this.templateService.findTemplate(templateId);
        return bodyBuilder.body((Object)webTemplate);
    }

    @Override
    @GetMapping(path={"/adl1.4/{template_id}/example"}, produces={"application/json", "application/xml", "application/openehr.wt.structured.schema+json", "application/openehr.wt.flat.schema+json"})
    public ResponseEntity<String> getTemplateExample(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="template_id") String templateId, @RequestParam(value="format", required=false) String format) {
        CompositionRepresentation representation = this.extractCompositionRepresentation(accept, format);
        Composition composition = this.templateService.buildExample(templateId);
        CompositionDto compositionDto = new CompositionDto(composition, templateId, null, null);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().location(this.createLocationUri("definition", "template", ADL_1_4, templateId, "example"))).contentType(representation.mediaType).body((Object)this.compositionService.serialize(compositionDto, representation.format).getValue());
    }

    @Override
    @GetMapping(path={"/adl1.4/{template_id}/webtemplate"}, produces={"application/json", "application/openehr.wt+json"})
    public ResponseEntity<WebTemplate> getWebTemplate(@RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="template_id") String templateId) {
        MediaType mediaType = this.resolveContentType(accept, OpenEHRMediaType.APPLICATION_WT_JSON, MediaType.APPLICATION_JSON);
        WebTemplate webTemplate = this.templateService.findTemplate(templateId);
        String linkPrefix = "%s/%s".formatted(this.getContextPath(), "swagger-ui/index.html?urls.primaryName=1.%20openEHR%20API#");
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().location(this.createLocationUri("definition", "template", ADL_1_4, templateId, "webtemplate"))).contentType(mediaType).header("Deprecated", new String[]{"Mon, 03 Jun 2024 00:00:00 GMT"})).header("Link", new String[]{String.join((CharSequence)", ", List.of("<%s/%s>; rel=\"deprecation\"; type=\"text/html\"".formatted(linkPrefix, UriUtils.encode((String)"TEMPLATE/getWebTemplate", (Charset)StandardCharsets.US_ASCII)), "<%s/%s>; rel=\"successor-version\"".formatted(linkPrefix, UriUtils.encode((String)"ADL 1.4 TEMPLATE/getTemplateClassic", (Charset)StandardCharsets.US_ASCII))))})).body((Object)webTemplate);
    }

    @Override
    @PostMapping(value={"/adl2"}, consumes={"text/plain"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<TemplateResponseData> createTemplateNew(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="Accept", required=false) String accept, @RequestHeader(value="Prefer", required=false) String prefer, @RequestParam(value="version", required=false) String version, @RequestBody String template) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).build();
    }

    @Override
    @GetMapping(value={"/adl2"}, produces={"application/json"})
    public ResponseEntity<TemplateResponseData> getTemplatesNew(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Accept", required=false) String accept) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).build();
    }

    @Override
    @GetMapping(value={"/adl2/{template_id}/{version_pattern}"}, produces={"text/plain"})
    public ResponseEntity<TemplateResponseData> getTemplateNew(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Accept", required=false) String accept, @PathVariable(value="template_id", required=false) String templateId, @PathVariable(value="version_pattern", required=false) String versionPattern) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED).build();
    }

    private ResponseEntity.BodyBuilder templateResponseBuilder(HttpStatus status, String templateId, MediaType mediaType) {
        URI uri = this.createLocationUri("definition", "template", ADL_1_4, templateId);
        return (ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).location(uri)).contentType(mediaType).eTag("\"%s\"".formatted(templateId))).lastModified(123124442L);
    }

    private static OperationalTemplateFormat operationalTemplateFormatForMediaType(MediaType mediaType) {
        if (mediaType.isCompatibleWith(MediaType.APPLICATION_XML)) {
            return OperationalTemplateFormat.XML;
        }
        if (mediaType.isCompatibleWith(MediaType.APPLICATION_JSON) || mediaType.isCompatibleWith(OpenEHRMediaType.APPLICATION_WT_JSON)) {
            return OperationalTemplateFormat.JSON;
        }
        throw new NotAcceptableException("Operation templates are only available in XML based OPT or simplified JSON-based web template format");
    }
}

