/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr.format;

import java.lang.runtime.SwitchBootstraps;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.NotAcceptableException;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionFormat;
import org.ehrbase.rest.openehr.format.OpenEHRMediaType;
import org.springframework.http.MediaType;

public enum CompositionRepresentation {
    XML(MediaType.APPLICATION_XML, CompositionFormat.XML),
    JSON(MediaType.APPLICATION_JSON, CompositionFormat.JSON),
    JSON_STRUCTURED(OpenEHRMediaType.APPLICATION_WT_STRUCTURED_SCHEMA_JSON, CompositionFormat.STRUCTURED),
    JSON_FLAT(OpenEHRMediaType.APPLICATION_WT_FLAT_SCHEMA_JSON, CompositionFormat.FLAT);

    public final CompositionFormat format;
    public final MediaType mediaType;

    private CompositionRepresentation(MediaType mediaType, CompositionFormat compositionFormat) {
        this.mediaType = mediaType;
        this.format = compositionFormat;
    }

    public static CompositionRepresentation selectFromMediaTypeWithFormat(MediaType mediaType, CompositionFormat format) {
        if (format != null) {
            CompositionRepresentation.validateSupportedCompositionFormat(format);
        }
        if (mediaType.isCompatibleWith(MediaType.APPLICATION_XML)) {
            return CompositionRepresentation.selectXMLRepresentation(mediaType, format);
        }
        if (mediaType.isCompatibleWith(OpenEHRMediaType.APPLICATION_WT_FLAT_SCHEMA_JSON)) {
            return JSON_FLAT;
        }
        if (mediaType.isCompatibleWith(OpenEHRMediaType.APPLICATION_WT_STRUCTURED_SCHEMA_JSON)) {
            return JSON_STRUCTURED;
        }
        if (mediaType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
            return CompositionRepresentation.selectJSONRepresentation(mediaType, format);
        }
        throw new NotAcceptableException("Only compositions in XML or JSON are supported at the moment");
    }

    private static void validateSupportedCompositionFormat(CompositionFormat format) {
        switch (format) {
            case FLAT: 
            case STRUCTURED: 
            case XML: 
            case JSON: {
                break;
            }
            case RAW: 
            case EXPANDED: 
            case ECISFLAT: {
                throw new InvalidApiParameterException(String.format("Format %s not supported", format));
            }
        }
    }

    private static CompositionRepresentation selectXMLRepresentation(MediaType mediaType, CompositionFormat format) {
        if (format == null || format == CompositionFormat.XML) {
            return XML;
        }
        throw new NotAcceptableException("Only composition format [XML] is supported at the moment for type [%s]".formatted(mediaType));
    }

    private static CompositionRepresentation selectJSONRepresentation(MediaType mediaType, CompositionFormat format) {
        CompositionFormat compositionFormat = format;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"JSON", "FLAT", "STRUCTURED"}, (CompositionFormat)compositionFormat, n)) {
            case -1 -> JSON;
            case 0 -> JSON;
            case 1 -> JSON_FLAT;
            case 2 -> JSON_STRUCTURED;
            default -> throw new NotAcceptableException("Only compositions formats [JSON, FLAT, STRUCTURED] are supported at the moment for [%s]".formatted(mediaType));
        };
    }
}

