/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.rest.openehr;

import com.nedap.archie.rm.support.identification.HierObjectId;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import org.ehrbase.api.dto.EhrDto;
import org.ehrbase.api.dto.EhrStatusDto;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.rest.HttpRestContext;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.SystemService;
import org.ehrbase.rest.BaseController;
import org.ehrbase.rest.openehr.specification.EhrApiSpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@ConditionalOnMissingBean(name={"primaryopenehrehrcontroller"})
@RestController
@RequestMapping(path={"${openehr-api.context-path:/rest/openehr}/v1/ehr"})
public class OpenehrEhrController
extends BaseController
implements EhrApiSpecification {
    private final EhrService ehrService;
    private final SystemService systemService;

    @Autowired
    public OpenehrEhrController(EhrService ehrService, SystemService systemService) {
        this.ehrService = Objects.requireNonNull(ehrService);
        this.systemService = systemService;
    }

    @Override
    @PostMapping(consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EhrDto> createEhr(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Prefer", required=false, defaultValue="return=minimal") String prefer, @RequestBody(required=false) EhrStatusDto ehrStatus) {
        UUID ehrId = this.ehrService.create(null, ehrStatus).ehrId();
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)ehrId);
        ResponseEntity.BodyBuilder bodyBuilder = this.responseBuilder(HttpStatus.CREATED, ehrId);
        if ("return=representation".equals(prefer)) {
            EhrDto ehrResponseData = this.ehrResponseData(ehrId);
            return bodyBuilder.body((Object)ehrResponseData);
        }
        return bodyBuilder.build();
    }

    @Override
    @PutMapping(path={"/{ehr_id}"}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EhrDto> createEhrWithId(@RequestHeader(value="openEHR-VERSION", required=false) String openehrVersion, @RequestHeader(value="openEHR-AUDIT_DETAILS", required=false) String openehrAuditDetails, @RequestHeader(value="Prefer", required=false) String prefer, @PathVariable(value="ehr_id") String ehrIdString, @RequestBody(required=false) EhrStatusDto ehrStatus) {
        UUID newEhrId = this.parseUUID(ehrIdString, "EHR ID format not a UUID");
        UUID ehrId = this.ehrService.create(newEhrId, ehrStatus).ehrId();
        this.createRestContext(ehrId);
        ResponseEntity.BodyBuilder bodyBuilder = this.responseBuilder(HttpStatus.CREATED, ehrId);
        if ("return=representation".equals(prefer)) {
            EhrDto ehrResponseData = this.ehrResponseData(ehrId);
            return bodyBuilder.body((Object)ehrResponseData);
        }
        return bodyBuilder.build();
    }

    @Override
    @GetMapping(path={"/{ehr_id}"}, produces={"application/json", "application/xml"})
    public ResponseEntity<EhrDto> getEhrById(@PathVariable(value="ehr_id") String ehrIdString) {
        UUID ehrId = this.getEhrUuid(ehrIdString);
        this.createRestContext(ehrId);
        EhrDto ehrResponseData = this.ehrResponseData(ehrId);
        return this.responseBuilder(HttpStatus.OK, ehrId).body((Object)ehrResponseData);
    }

    @Override
    @GetMapping(params={"subject_id", "subject_namespace"}, produces={"application/json", "application/xml"})
    public ResponseEntity<EhrDto> getEhrBySubject(@RequestParam(value="subject_id") String subjectId, @RequestParam(value="subject_namespace") String subjectNamespace) {
        UUID ehrId = (UUID)this.ehrService.findBySubject(subjectId, subjectNamespace).orElseThrow(() -> new ObjectNotFoundException("ehr", "No EHR with supplied subject parameters found"));
        this.createRestContext(ehrId);
        EhrDto ehrResponseData = this.ehrResponseData(ehrId);
        return this.responseBuilder(HttpStatus.OK, ehrId).body((Object)ehrResponseData);
    }

    private EhrDto ehrResponseData(UUID ehrId) {
        EhrService.EhrResult ehrResult = this.ehrService.getEhrStatus(ehrId);
        return new EhrDto(new HierObjectId(this.systemService.getSystemId()), new HierObjectId(ehrId.toString()), ehrResult.status(), this.ehrService.getCreationTime(ehrId), null, null);
    }

    private ResponseEntity.BodyBuilder responseBuilder(HttpStatus status, UUID ehrId) {
        URI uri = this.createLocationUri("ehr", ehrId.toString());
        return (ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)status).location(uri)).eTag("\"%s\"".formatted(ehrId.toString()))).lastModified(123124442L);
    }

    private void createRestContext(UUID resultEhrId) {
        HttpRestContext.register((HttpRestContext.CtxAttr)HttpRestContext.EHR_ID, (Object)resultEhrId, (HttpRestContext.CtxAttr)HttpRestContext.LOCATION, (Object)UriComponentsBuilder.fromPath((String)"").pathSegment(new String[]{"ehr", resultEhrId.toString()}).build().toString());
    }
}

