/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.binder;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.aql.dto.containment.ContainmentDto;
import org.ehrbase.aql.dto.containment.ContainmentExpresionDto;
import org.ehrbase.aql.dto.containment.ContainmentLogicalOperator;
import org.ehrbase.aql.dto.containment.ContainmentLogicalOperatorSymbol;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.containment.ContainmentExpression;
import org.ehrbase.util.exception.SdkException;

public class ContainmentBinder {
    public Pair<ContainmentExpression, Map<Integer, Containment>> buildContainment(ContainmentExpresionDto dto) {
        MutablePair result = new MutablePair();
        if (dto instanceof ContainmentDto) {
            this.handleContainmentDto((ContainmentDto)dto, (MutablePair<ContainmentExpression, Map<Integer, Containment>>)result);
        } else if (dto instanceof ContainmentLogicalOperator) {
            this.handleContainmentLogicalOperator((ContainmentLogicalOperator)dto, (MutablePair<ContainmentExpression, Map<Integer, Containment>>)result);
        } else {
            throw new SdkException("Unknown Type" + dto.getClass().getSimpleName());
        }
        return result;
    }

    public void handleContainmentLogicalOperator(ContainmentLogicalOperator dto, MutablePair<ContainmentExpression, Map<Integer, Containment>> result) {
        Pair<ContainmentExpression, Map<Integer, Containment>> pair = this.buildLogicalOperator(dto.getSymbol(), this.buildContainment(dto.getValues().get(0)), this.buildContainment(dto.getValues().get(1)));
        ContainmentExpression containmentExpression = (ContainmentExpression)pair.getLeft();
        Map containmentMap = (Map)pair.getRight();
        for (int i = 2; i < dto.getValues().size(); ++i) {
            Pair<ContainmentExpression, Map<Integer, Containment>> subPair = this.buildLogicalOperator(dto.getSymbol(), pair, this.buildContainment(dto.getValues().get(i)));
            containmentExpression = (ContainmentExpression)subPair.getLeft();
            containmentMap.putAll((Map)subPair.getRight());
        }
        result.setLeft((Object)containmentExpression);
        result.setRight((Object)containmentMap);
    }

    public void handleContainmentDto(ContainmentDto dto, MutablePair<ContainmentExpression, Map<Integer, Containment>> result) {
        Containment containment;
        HashMap<Integer, Containment> containmentMap = new HashMap<Integer, Containment>();
        Containment containmentExpression1 = containment = new Containment(dto.getArchetypeId());
        containmentMap.put(dto.getId(), containment);
        if (dto.getContains() != null) {
            Pair<ContainmentExpression, Map<Integer, Containment>> pair = this.buildContainment(dto.getContains());
            containment.setContains((ContainmentExpression)pair.getLeft());
            containmentMap.putAll((Map)pair.getRight());
        }
        Containment containmentExpression = containmentExpression1;
        result.setLeft((Object)containmentExpression);
        result.setRight(containmentMap);
    }

    private Pair<ContainmentExpression, Map<Integer, Containment>> buildLogicalOperator(ContainmentLogicalOperatorSymbol symbol, Pair<ContainmentExpression, Map<Integer, Containment>> pair1, Pair<ContainmentExpression, Map<Integer, Containment>> pair2) {
        ContainmentExpression containmentExpression;
        switch (symbol) {
            case OR: {
                containmentExpression = ((ContainmentExpression)pair1.getLeft()).or((ContainmentExpression)pair2.getLeft());
                break;
            }
            case AND: {
                containmentExpression = ((ContainmentExpression)pair1.getLeft()).and((ContainmentExpression)pair2.getLeft());
                break;
            }
            default: {
                throw new SdkException(String.format("Unknown Symbol %s", symbol));
            }
        }
        ((Map)pair1.getRight()).putAll((Map)pair2.getRight());
        return new ImmutablePair((Object)containmentExpression, (Object)((Map)pair1.getRight()));
    }
}

