/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.parser;

import com.nedap.archie.datetime.DateTimeParsers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.dto.AqlDto;
import org.ehrbase.aql.dto.EhrDto;
import org.ehrbase.aql.dto.LogicalOperatorSymbol;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorDto;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorSymbol;
import org.ehrbase.aql.dto.condition.ConditionDto;
import org.ehrbase.aql.dto.condition.ConditionLogicalOperatorDto;
import org.ehrbase.aql.dto.condition.ConditionLogicalOperatorSymbol;
import org.ehrbase.aql.dto.condition.MatchesOperatorDto;
import org.ehrbase.aql.dto.condition.ParameterValue;
import org.ehrbase.aql.dto.condition.SimpleValue;
import org.ehrbase.aql.dto.condition.Value;
import org.ehrbase.aql.dto.containment.ContainmentDto;
import org.ehrbase.aql.dto.containment.ContainmentExpresionDto;
import org.ehrbase.aql.dto.containment.ContainmentLogicalOperator;
import org.ehrbase.aql.dto.containment.ContainmentLogicalOperatorSymbol;
import org.ehrbase.aql.dto.orderby.OrderByExpressionDto;
import org.ehrbase.aql.dto.orderby.OrderByExpressionSymbol;
import org.ehrbase.aql.dto.select.SelectDto;
import org.ehrbase.aql.dto.select.SelectFieldDto;
import org.ehrbase.aql.dto.select.SelectStatementDto;
import org.ehrbase.aql.parser.AqlBaseVisitor;
import org.ehrbase.aql.parser.AqlParseException;
import org.ehrbase.aql.parser.AqlParser;
import org.ehrbase.client.aql.top.Direction;

public class AqlToDtoVisitor
extends AqlBaseVisitor<Object> {
    private int containmentId = 0;
    private final Map<String, Integer> identifierMap = new HashMap<String, Integer>();
    private final MultiValuedMap<String, SelectFieldDto> selectFieldDtoMultiMap = new ArrayListValuedHashMap();

    @Override
    public AqlDto visitQuery(AqlParser.QueryContext ctx) {
        AqlDto aqlDto = new AqlDto();
        aqlDto.setEhr(this.visitFromEHR(ctx.queryExpr().from().fromEHR()));
        if (ctx.queryExpr().from().containsExpression() != null) {
            aqlDto.setContains(this.visitContainsExpression(ctx.queryExpr().from().containsExpression()));
        }
        aqlDto.setSelect(this.visitSelect(ctx.queryExpr().select()));
        if (ctx.queryExpr().where() != null) {
            aqlDto.setWhere(this.visitIdentifiedExpr(ctx.queryExpr().where().identifiedExpr()));
        }
        if (ctx.queryExpr().orderBy() != null) {
            aqlDto.setOrderBy((List<OrderByExpressionDto>)this.visitOrderBySeq(ctx.queryExpr().orderBy().orderBySeq()));
        }
        if (ctx.queryExpr().limitExpr() != null) {
            AqlParser.LimitExprContext limitExpr = ctx.queryExpr().limitExpr();
            aqlDto.setLimit(Integer.parseInt(limitExpr.INTEGER().getText()));
            if (limitExpr.offset() != null) {
                aqlDto.setOffset(Integer.parseInt(limitExpr.offset().INTEGER().getText()));
            }
        }
        this.selectFieldDtoMultiMap.entries().forEach(e -> ((SelectFieldDto)e.getValue()).setContainmentId(Optional.ofNullable(this.identifierMap.get(e.getKey())).orElseThrow()));
        return aqlDto;
    }

    @Override
    public EhrDto visitFromEHR(AqlParser.FromEHRContext ctx) {
        EhrDto ehrDto = new EhrDto();
        ehrDto.setContainmentId(this.buildContainmentId());
        if (ctx.IDENTIFIER() != null) {
            this.identifierMap.put(ctx.IDENTIFIER().getText(), ehrDto.getContainmentId());
            ehrDto.setIdentifier(ctx.IDENTIFIER().getText());
        }
        return ehrDto;
    }

    @Override
    public SelectDto visitSelect(AqlParser.SelectContext ctx) {
        SelectDto selectDto = new SelectDto();
        selectDto.setStatement((List<SelectStatementDto>)this.visitSelectExpr(ctx.selectExpr()));
        if (ctx.topExpr() != null) {
            selectDto.setTopDirection(this.extractSymbol(ctx.topExpr()));
            selectDto.setTopCount(Integer.parseInt(ctx.topExpr().INTEGER().getText()));
        }
        return selectDto;
    }

    private Direction extractSymbol(AqlParser.TopExprContext topExpr) {
        if (topExpr.BACKWARD() != null) {
            return Direction.BACKWARD;
        }
        return Direction.FORWARD;
    }

    @Override
    public List<SelectStatementDto> visitSelectExpr(AqlParser.SelectExprContext ctx) {
        ArrayList<SelectStatementDto> selectStatementDtos = new ArrayList<SelectStatementDto>();
        if (ctx.identifiedPath() != null) {
            SelectFieldDto selectFieldDto = this.visitIdentifiedPath(ctx.identifiedPath());
            if (ctx.IDENTIFIER() != null) {
                selectFieldDto.setName(ctx.IDENTIFIER().getText());
            }
            selectStatementDtos.add(selectFieldDto);
        }
        if (ctx.selectExpr() != null) {
            selectStatementDtos.addAll((Collection<SelectStatementDto>)this.visitSelectExpr(ctx.selectExpr()));
        }
        return selectStatementDtos;
    }

    @Override
    public SelectFieldDto visitIdentifiedPath(AqlParser.IdentifiedPathContext ctx) {
        SelectFieldDto selectStatementDto = new SelectFieldDto();
        this.selectFieldDtoMultiMap.put((Object)ctx.IDENTIFIER().getText(), (Object)selectStatementDto);
        selectStatementDto.setAqlPath(StringUtils.removeStart((String)ctx.getText(), (String)ctx.IDENTIFIER().getText()));
        return selectStatementDto;
    }

    @Override
    public ContainmentExpresionDto visitContainsExpression(AqlParser.ContainsExpressionContext ctx) {
        ArrayList<Object> boolList = new ArrayList<Object>();
        for (AqlParser.ContainsExpressionContext currentContext = ctx; currentContext != null; currentContext = currentContext.containsExpression()) {
            ContainmentLogicalOperatorSymbol symbol = this.extractSymbol(currentContext);
            boolList.add(this.visitContainExpressionBool(currentContext.containExpressionBool()));
            if (symbol == null) continue;
            boolList.add(symbol);
        }
        if (boolList.size() == 1) {
            return (ContainmentExpresionDto)boolList.get(0);
        }
        return this.buildContainmentLogicalOperator(boolList);
    }

    private ContainmentLogicalOperator buildContainmentLogicalOperator(List<Object> boolList) {
        ContainmentLogicalOperator currentOperator = new ContainmentLogicalOperator();
        ContainmentLogicalOperatorSymbol currentSymbol = (ContainmentLogicalOperatorSymbol)boolList.get(1);
        currentOperator.setSymbol(currentSymbol);
        currentOperator.setValues(new ArrayList<ContainmentExpresionDto>());
        currentOperator.getValues().add((ContainmentExpresionDto)boolList.get(0));
        ContainmentLogicalOperator lowestOperator = currentOperator;
        for (int i = 2; i < boolList.size(); i += 2) {
            ContainmentLogicalOperatorSymbol nextSymbol;
            ContainmentLogicalOperatorSymbol containmentLogicalOperatorSymbol = nextSymbol = i + 1 < boolList.size() ? (ContainmentLogicalOperatorSymbol)boolList.get(i + 1) : null;
            if (nextSymbol == null || Objects.equals(currentSymbol, nextSymbol)) {
                currentOperator.getValues().add((ContainmentExpresionDto)boolList.get(i));
                currentSymbol = nextSymbol;
                continue;
            }
            ContainmentLogicalOperator nextOperator = new ContainmentLogicalOperator();
            nextOperator.setSymbol(nextSymbol);
            nextOperator.setValues(new ArrayList<ContainmentExpresionDto>());
            if (this.hasHigherPrecedence(currentSymbol, nextSymbol)) {
                currentOperator.getValues().add((ContainmentExpresionDto)boolList.get(i));
                nextOperator.getValues().add(currentOperator);
                lowestOperator = nextOperator;
            } else {
                nextOperator.getValues().add((ContainmentExpresionDto)boolList.get(i));
                currentOperator.getValues().add(nextOperator);
                lowestOperator = currentOperator;
            }
            currentOperator = nextOperator;
            currentSymbol = nextSymbol;
        }
        return lowestOperator;
    }

    @Override
    public ContainmentExpresionDto visitContainExpressionBool(AqlParser.ContainExpressionBoolContext ctx) {
        if (ctx.contains() != null) {
            return this.visitContains(ctx.contains());
        }
        return this.visitContainsExpression(ctx.containsExpression());
    }

    @Override
    public ContainmentDto visitContains(AqlParser.ContainsContext ctx) {
        ContainmentDto containmentDto = this.visitSimpleClassExpr(ctx.simpleClassExpr());
        if (ctx.containsExpression() != null) {
            containmentDto.setContains(this.visitContainsExpression(ctx.containsExpression()));
        }
        return containmentDto;
    }

    @Override
    public ContainmentDto visitSimpleClassExpr(AqlParser.SimpleClassExprContext ctx) {
        ContainmentDto currentContainment = new ContainmentDto();
        currentContainment.setId(this.buildContainmentId());
        AqlParser.ArchetypedClassExprContext archetypedClassExprContext = (AqlParser.ArchetypedClassExprContext)ctx.getChild(AqlParser.ArchetypedClassExprContext.class, 0);
        if (archetypedClassExprContext != null) {
            if (archetypedClassExprContext.IDENTIFIER().size() == 2) {
                currentContainment.setIdentifier(archetypedClassExprContext.IDENTIFIER(1).getText());
                this.identifierMap.put(currentContainment.getIdentifier(), currentContainment.getId());
            }
            currentContainment.setArchetypeId(archetypedClassExprContext.ARCHETYPEID().getText());
        } else {
            currentContainment.setArchetypeId(ctx.IDENTIFIER(0).getText());
            if (ctx.IDENTIFIER().size() == 2) {
                currentContainment.setIdentifier(ctx.IDENTIFIER(1).getText());
                this.identifierMap.put(currentContainment.getIdentifier(), currentContainment.getId());
            }
        }
        return currentContainment;
    }

    @Override
    public ConditionDto visitIdentifiedExpr(AqlParser.IdentifiedExprContext ctx) {
        ArrayList<Object> boolList = new ArrayList<Object>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ConditionLogicalOperatorSymbol symbol;
            ParseTree child = ctx.getChild(i);
            if (child instanceof AqlParser.IdentifiedEqualityContext) {
                boolList.add(this.visitIdentifiedEquality((AqlParser.IdentifiedEqualityContext)child));
                continue;
            }
            if (!(child instanceof TerminalNode) || (symbol = this.extractSymbolTerminal((TerminalNode)child)) == null) continue;
            boolList.add(symbol);
        }
        if (boolList.size() == 1) {
            return (ConditionDto)boolList.get(0);
        }
        return this.buildConditionLogicalOperator(boolList);
    }

    private ConditionLogicalOperatorDto buildConditionLogicalOperator(List<Object> boolList) {
        ConditionLogicalOperatorDto currentOperator = new ConditionLogicalOperatorDto();
        ConditionLogicalOperatorSymbol currentSymbol = (ConditionLogicalOperatorSymbol)boolList.get(1);
        currentOperator.setSymbol(currentSymbol);
        currentOperator.setValues(new ArrayList<ConditionDto>());
        currentOperator.getValues().add((ConditionDto)boolList.get(0));
        ConditionLogicalOperatorDto lowestOperator = currentOperator;
        for (int i = 2; i < boolList.size(); i += 2) {
            ConditionLogicalOperatorSymbol nextSymbol;
            ConditionLogicalOperatorSymbol conditionLogicalOperatorSymbol = nextSymbol = i + 1 < boolList.size() ? (ConditionLogicalOperatorSymbol)boolList.get(i + 1) : null;
            if (nextSymbol == null || Objects.equals(currentSymbol, nextSymbol)) {
                currentOperator.getValues().add((ConditionDto)boolList.get(i));
                currentSymbol = nextSymbol;
                continue;
            }
            ConditionLogicalOperatorDto nextOperator = new ConditionLogicalOperatorDto();
            nextOperator.setSymbol(nextSymbol);
            nextOperator.setValues(new ArrayList<ConditionDto>());
            if (this.hasHigherPrecedence(currentSymbol, nextSymbol)) {
                currentOperator.getValues().add((ConditionDto)boolList.get(i));
                nextOperator.getValues().add(currentOperator);
                lowestOperator = nextOperator;
            } else {
                nextOperator.getValues().add((ConditionDto)boolList.get(i));
                currentOperator.getValues().add(nextOperator);
                lowestOperator = currentOperator;
            }
            currentOperator = nextOperator;
            currentSymbol = nextSymbol;
        }
        return lowestOperator;
    }

    private ConditionLogicalOperatorSymbol extractSymbolTerminal(TerminalNode child) {
        if (child == null) {
            return null;
        }
        switch (child.getSymbol().getText()) {
            case "or": {
                return ConditionLogicalOperatorSymbol.OR;
            }
            case "and": {
                return ConditionLogicalOperatorSymbol.AND;
            }
            case "xor": {
                throw new AqlParseException("XOR not supported");
            }
        }
        return null;
    }

    @Override
    public ConditionDto visitIdentifiedEquality(AqlParser.IdentifiedEqualityContext ctx) {
        ConditionDto conditionDto = null;
        if (ctx.identifiedExpr() != null) {
            conditionDto = this.visitIdentifiedExpr(ctx.identifiedExpr());
        } else if (ctx.COMPARABLEOPERATOR() != null) {
            ConditionComparisonOperatorSymbol comparisonOperatorSymbol = this.extractSymbol(ctx);
            ConditionComparisonOperatorDto operatorDto = new ConditionComparisonOperatorDto();
            operatorDto.setSymbol(comparisonOperatorSymbol);
            operatorDto.setStatement(this.visitIdentifiedPath(ctx.identifiedOperand(0).identifiedPath()));
            operatorDto.setValue(this.visitOperand(ctx.identifiedOperand(1).operand()));
            conditionDto = operatorDto;
        } else if (ctx.MATCHES() != null) {
            MatchesOperatorDto matchesOperatorDto = new MatchesOperatorDto();
            matchesOperatorDto.setStatement(this.visitIdentifiedPath(ctx.identifiedOperand(0).identifiedPath()));
            matchesOperatorDto.setValues(new ArrayList<Value>());
            for (AqlParser.ValueListItemsContext valueListItemsContext = ctx.matchesOperand().valueListItems(); valueListItemsContext != null; valueListItemsContext = valueListItemsContext.valueListItems()) {
                matchesOperatorDto.getValues().add(this.visitOperand(valueListItemsContext.operand()));
            }
            conditionDto = matchesOperatorDto;
        }
        return conditionDto;
    }

    @Override
    public Value visitOperand(AqlParser.OperandContext ctx) {
        Value value;
        if (ctx.BOOLEAN() != null) {
            SimpleValue simpleValue = new SimpleValue();
            simpleValue.setValue(Boolean.parseBoolean(ctx.getText()));
            value = simpleValue;
        } else if (ctx.DATE() != null) {
            SimpleValue simpleValue = new SimpleValue();
            String unwrap = StringUtils.unwrap((String)StringUtils.unwrap((String)ctx.getText(), (String)"'"), (String)"\"");
            simpleValue.setValue(DateTimeParsers.parseTimeValue((String)unwrap));
            value = simpleValue;
        } else if (ctx.FLOAT() != null) {
            SimpleValue simpleValue = new SimpleValue();
            simpleValue.setValue(Double.valueOf(ctx.getText()));
            value = simpleValue;
        } else if (ctx.INTEGER() != null) {
            SimpleValue simpleValue = new SimpleValue();
            simpleValue.setValue(Integer.valueOf(ctx.getText()));
            value = simpleValue;
        } else if (ctx.STRING() != null) {
            SimpleValue simpleValue = new SimpleValue();
            String unwrap = StringUtils.unwrap((String)StringUtils.unwrap((String)ctx.getText(), (String)"'"), (String)"\"");
            simpleValue.setValue(unwrap);
            value = simpleValue;
        } else if (ctx.PARAMETER() != null) {
            ParameterValue simpleValue = new ParameterValue();
            simpleValue.setName(StringUtils.removeStart((String)ctx.getText(), (String)"$"));
            simpleValue.setType("?");
            value = simpleValue;
        } else {
            throw new AqlParseException("Can not handle value " + ctx.getText());
        }
        return value;
    }

    @Override
    public List<OrderByExpressionDto> visitOrderBySeq(AqlParser.OrderBySeqContext ctx) {
        ArrayList<OrderByExpressionDto> orderByExpressionDtoList = new ArrayList<OrderByExpressionDto>();
        orderByExpressionDtoList.add(this.visitOrderByExpr(ctx.orderByExpr()));
        if (ctx.orderBySeq() != null) {
            orderByExpressionDtoList.addAll((Collection<OrderByExpressionDto>)this.visitOrderBySeq(ctx.orderBySeq()));
        }
        return orderByExpressionDtoList;
    }

    @Override
    public OrderByExpressionDto visitOrderByExpr(AqlParser.OrderByExprContext ctx) {
        OrderByExpressionDto orderByExpressionDto = new OrderByExpressionDto();
        orderByExpressionDto.setStatement(this.visitIdentifiedPath(ctx.identifiedPath()));
        orderByExpressionDto.setSymbol(this.extractSymbol(ctx));
        return orderByExpressionDto;
    }

    private OrderByExpressionSymbol extractSymbol(AqlParser.OrderByExprContext ctx) {
        if (ctx.DESC() != null || ctx.DESCENDING() != null) {
            return OrderByExpressionSymbol.DESC;
        }
        return OrderByExpressionSymbol.ASC;
    }

    private ConditionComparisonOperatorSymbol extractSymbol(AqlParser.IdentifiedEqualityContext ctx) {
        switch (ctx.COMPARABLEOPERATOR().getText()) {
            case "=": {
                return ConditionComparisonOperatorSymbol.EQ;
            }
            case "!=": {
                return ConditionComparisonOperatorSymbol.NEQ;
            }
            case ">": {
                return ConditionComparisonOperatorSymbol.GT;
            }
            case ">=": {
                return ConditionComparisonOperatorSymbol.GT_EQ;
            }
            case "<": {
                return ConditionComparisonOperatorSymbol.LT;
            }
            case "<=": {
                return ConditionComparisonOperatorSymbol.LT_EQ;
            }
        }
        throw new AqlParseException("Unknown Token " + ctx.COMPARABLEOPERATOR().getText());
    }

    private boolean hasHigherPrecedence(LogicalOperatorSymbol operatorSymbol, LogicalOperatorSymbol nextOperatorSymbol) {
        if (nextOperatorSymbol == null) {
            return true;
        }
        return operatorSymbol.getPrecedence() <= nextOperatorSymbol.getPrecedence();
    }

    private int buildContainmentId() {
        return this.containmentId++;
    }

    private ContainmentLogicalOperatorSymbol extractSymbol(AqlParser.ContainsExpressionContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.OR() != null) {
            return ContainmentLogicalOperatorSymbol.OR;
        }
        if (ctx.AND() != null) {
            return ContainmentLogicalOperatorSymbol.AND;
        }
        if (ctx.XOR() != null) {
            throw new AqlParseException("XOR not supported");
        }
        return null;
    }
}

