/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.dto.path.predicate;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorSymbol;
import org.ehrbase.aql.dto.condition.LogicalOperatorDto;
import org.ehrbase.aql.dto.condition.ParameterValue;
import org.ehrbase.aql.dto.condition.SimpleValue;
import org.ehrbase.aql.dto.condition.Value;
import org.ehrbase.aql.dto.path.AqlPath;
import org.ehrbase.aql.dto.path.predicate.PredicateComparisonOperatorDto;
import org.ehrbase.aql.dto.path.predicate.PredicateDto;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalAndOperation;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalOperatorSymbol;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalOrOperation;
import org.ehrbase.aql.dto.path.predicate.SimplePredicateDto;
import org.ehrbase.aql.parser.AqlToDtoVisitor;
import org.ehrbase.util.exception.SdkException;

public class PredicateHelper {
    public static final String NAME_VALUE = "name/value";
    public static final String ARCHETYPE_NODE_ID = "archetype_node_id";
    public static final Comparator<PredicateDto> PREDICATE_DTO_COMPARATOR = new Comparator<PredicateDto>(){

        @Override
        public int compare(PredicateDto o1, PredicateDto o2) {
            if (o1 instanceof PredicateComparisonOperatorDto && o2 instanceof PredicateComparisonOperatorDto) {
                int x = this.toInt((PredicateComparisonOperatorDto)o1);
                return Integer.compare(x, this.toInt((PredicateComparisonOperatorDto)o2));
            }
            return 0;
        }

        int toInt(PredicateComparisonOperatorDto dto) {
            switch (dto.getStatement()) {
                case "archetype_node_id": {
                    return 1;
                }
                case "name/value": {
                    return 2;
                }
            }
            return 3;
        }
    };

    private PredicateHelper() {
    }

    public static PredicateDto buildPredicate(String predicate) {
        List<Object> boolList = PredicateHelper.parsePredicate(predicate);
        if (boolList.size() == 1) {
            return (PredicateDto)boolList.get(0);
        }
        LogicalOperatorDto predicateLogicalOperatorSymbolPredicateDtoLogicalOperatorDto = AqlToDtoVisitor.buildLogicalOperator(boolList, s -> {
            if (PredicateLogicalOperatorSymbol.AND.equals(s)) {
                return new PredicateLogicalAndOperation();
            }
            return new PredicateLogicalOrOperation();
        });
        return (PredicateDto)((Object)predicateLogicalOperatorSymbolPredicateDtoLogicalOperatorDto);
    }

    static List<Object> parsePredicate(String predicate) {
        CharSequence[] split = AqlPath.split(predicate, null, true, " and ", " AND ", " or ", " OR ", ",");
        return IntStream.range(0, split.length).mapToObj(i -> {
            if (i % 2 == 0) {
                return PredicateHelper.handleOperator(split[i], i);
            }
            return PredicateHelper.handleSymbol(split[i]);
        }).collect(Collectors.toList());
    }

    private static PredicateLogicalOperatorSymbol handleSymbol(CharSequence sequence) {
        switch (sequence.toString().trim()) {
            case ",": 
            case "and": 
            case "AND": {
                return PredicateLogicalOperatorSymbol.AND;
            }
            case "or": 
            case "OR": {
                return PredicateLogicalOperatorSymbol.OR;
            }
        }
        throw new SdkException(String.format("Unknown symbol %s", sequence));
    }

    private static PredicateComparisonOperatorDto handleOperator(CharSequence sequence, int i) {
        CharSequence[] split = AqlPath.split(sequence, 3, true, (String[])Arrays.stream(ConditionComparisonOperatorSymbol.values()).map(ConditionComparisonOperatorSymbol::getSymbole).toArray(String[]::new));
        PredicateComparisonOperatorDto comparisonOperatorDto = new PredicateComparisonOperatorDto();
        if (split.length == 1) {
            if (i == 0) {
                comparisonOperatorDto.setStatement(ARCHETYPE_NODE_ID);
                comparisonOperatorDto.setValue(PredicateHelper.parseValue(ARCHETYPE_NODE_ID, split[0].toString().trim()));
                comparisonOperatorDto.setSymbol(ConditionComparisonOperatorSymbol.EQ);
            } else if (i == 2) {
                comparisonOperatorDto.setStatement(NAME_VALUE);
                comparisonOperatorDto.setValue(PredicateHelper.parseValue(NAME_VALUE, split[0].toString().trim()));
                comparisonOperatorDto.setSymbol(ConditionComparisonOperatorSymbol.EQ);
            }
        } else {
            comparisonOperatorDto.setStatement(split[0].toString().trim());
            comparisonOperatorDto.setValue(PredicateHelper.parseValue(comparisonOperatorDto.getStatement(), split[2].toString().trim()));
            comparisonOperatorDto.setSymbol(ConditionComparisonOperatorSymbol.fromSymbol(split[1].toString()));
        }
        return comparisonOperatorDto;
    }

    private static Value parseValue(String statement, String s) {
        if (s.startsWith("$")) {
            ParameterValue parameterValue = new ParameterValue();
            parameterValue.setName(StringUtils.removeStart((String)s, (String)"$"));
            return parameterValue;
        }
        if (ARCHETYPE_NODE_ID.equals(statement)) {
            SimpleValue simpleValue = new SimpleValue();
            simpleValue.setValue(s);
            return simpleValue;
        }
        if (s.startsWith("'")) {
            SimpleValue simpleValue = new SimpleValue();
            simpleValue.setValue(StringUtils.unwrap((String)s, (String)"'"));
            return simpleValue;
        }
        if (StringUtils.contains((CharSequence)s, (int)46)) {
            SimpleValue simpleValue = new SimpleValue();
            simpleValue.setValue(Double.parseDouble(s));
            return simpleValue;
        }
        SimpleValue simpleValue = new SimpleValue();
        simpleValue.setValue(Long.parseLong(s));
        return simpleValue;
    }

    private static void format(String statement, StringBuilder sb, Value value) {
        if (value instanceof SimpleValue) {
            Object o = ((SimpleValue)value).getValue();
            if (o instanceof String && !ARCHETYPE_NODE_ID.equals(statement)) {
                sb.append(StringUtils.wrap((String)o.toString(), (String)"'"));
            } else {
                sb.append(o);
            }
        } else if (value instanceof ParameterValue) {
            sb.append("$").append(((ParameterValue)value).getName());
        }
    }

    public static String format(PredicateDto predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        StringBuilder sb = new StringBuilder();
        PredicateHelper.format(sb, predicateDto, otherPredicatesFormat);
        return sb.toString();
    }

    public static void format(StringBuilder sb, PredicateDto predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (predicateDto instanceof ParameterValue) {
            sb.append("$").append(((ParameterValue)predicateDto).getName());
        } else if (predicateDto instanceof PredicateComparisonOperatorDto) {
            PredicateHelper.formatPredicateComparisonOperatorDto(sb, (PredicateComparisonOperatorDto)predicateDto, otherPredicatesFormat);
        } else if (predicateDto instanceof PredicateLogicalAndOperation) {
            PredicateHelper.formatPredicateLogicalAndOperation(sb, (PredicateLogicalAndOperation)predicateDto, otherPredicatesFormat);
        } else if (predicateDto instanceof PredicateLogicalOrOperation) {
            PredicateHelper.formatPredicateLogicalOrOperation(sb, (PredicateLogicalOrOperation)predicateDto, otherPredicatesFormat);
        }
    }

    private static void formatPredicateLogicalOrOperation(StringBuilder sb, PredicateLogicalOrOperation predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (otherPredicatesFormat.equals((Object)AqlPath.OtherPredicatesFormat.SHORTED)) {
            otherPredicatesFormat = AqlPath.OtherPredicatesFormat.FULL;
        }
        List<SimplePredicateDto> values = predicateDto.getValues();
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0 && !PredicateHelper.isNone(values.get(i), otherPredicatesFormat)) {
                sb.append(" ").append("or").append(" ");
            }
            PredicateHelper.format(sb, values.get(i), otherPredicatesFormat);
        }
    }

    private static void formatPredicateLogicalAndOperation(StringBuilder sb, PredicateLogicalAndOperation predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        List<SimplePredicateDto> values = predicateDto.getValues();
        values.sort(PREDICATE_DTO_COMPARATOR);
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0 && !PredicateHelper.isNone(values.get(i), otherPredicatesFormat)) {
                if (PredicateHelper.isShorten(values.get(i), otherPredicatesFormat)) {
                    sb.append(",");
                } else {
                    sb.append(" ").append("and").append(" ");
                }
            }
            if (PredicateHelper.isNone(values.get(i), otherPredicatesFormat)) continue;
            PredicateHelper.format(sb, values.get(i), otherPredicatesFormat);
        }
    }

    private static void formatPredicateComparisonOperatorDto(StringBuilder sb, PredicateComparisonOperatorDto predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (PredicateHelper.isShorten(predicateDto, otherPredicatesFormat)) {
            PredicateHelper.format(predicateDto.getStatement(), sb, predicateDto.getValue());
        } else if (!PredicateHelper.isNone(predicateDto, otherPredicatesFormat)) {
            sb.append(predicateDto.getStatement()).append(predicateDto.getSymbol().getSymbole());
            PredicateHelper.format(predicateDto.getStatement(), sb, predicateDto.getValue());
        }
    }

    private static boolean isNone(SimplePredicateDto predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (!otherPredicatesFormat.equals((Object)AqlPath.OtherPredicatesFormat.NONE)) {
            return false;
        }
        if (predicateDto instanceof PredicateComparisonOperatorDto) {
            return !Objects.equals(ARCHETYPE_NODE_ID, ((PredicateComparisonOperatorDto)predicateDto).getStatement());
        }
        return false;
    }

    private static boolean isShorten(SimplePredicateDto predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (predicateDto instanceof PredicateComparisonOperatorDto && ((PredicateComparisonOperatorDto)predicateDto).getStatement().equals(ARCHETYPE_NODE_ID)) {
            return true;
        }
        if (otherPredicatesFormat.equals((Object)AqlPath.OtherPredicatesFormat.FULL)) {
            return false;
        }
        if (predicateDto instanceof PredicateLogicalOrOperation) {
            return false;
        }
        if (predicateDto instanceof PredicateLogicalAndOperation) {
            return CollectionUtils.isNotEmpty(((PredicateLogicalAndOperation)predicateDto).getValues()) && PredicateHelper.isShorten(((PredicateLogicalAndOperation)predicateDto).getValues().get(((PredicateLogicalAndOperation)predicateDto).getValues().size()), otherPredicatesFormat);
        }
        if (predicateDto instanceof PredicateComparisonOperatorDto) {
            return List.of(NAME_VALUE, ARCHETYPE_NODE_ID).contains(((PredicateComparisonOperatorDto)predicateDto).getStatement()) && ((PredicateComparisonOperatorDto)predicateDto).getSymbol().equals((Object)ConditionComparisonOperatorSymbol.EQ);
        }
        return false;
    }

    public static Optional<PredicateComparisonOperatorDto> find(PredicateDto predicateDto, String statement) {
        if (predicateDto instanceof PredicateLogicalOrOperation) {
            return ((PredicateLogicalOrOperation)predicateDto).getValues().stream().map(p -> PredicateHelper.find(p, statement)).flatMap(Optional::stream).findAny();
        }
        if (predicateDto instanceof PredicateLogicalAndOperation) {
            return ((PredicateLogicalAndOperation)predicateDto).getValues().stream().map(p -> PredicateHelper.find(p, statement)).flatMap(Optional::stream).findAny();
        }
        if (predicateDto instanceof PredicateComparisonOperatorDto) {
            return Optional.of((PredicateComparisonOperatorDto)predicateDto).filter(p -> p.getStatement().equals(statement));
        }
        return Optional.empty();
    }

    public static <P extends PredicateDto> P clone(P predicateDto) {
        if (predicateDto instanceof PredicateLogicalAndOperation) {
            PredicateLogicalAndOperation clone = new PredicateLogicalAndOperation();
            clone.setValues(((PredicateLogicalAndOperation)predicateDto).getValues().stream().map(PredicateHelper::clone).collect(Collectors.toList()));
            return (P)clone;
        }
        if (predicateDto instanceof PredicateComparisonOperatorDto) {
            return (P)new PredicateComparisonOperatorDto((PredicateComparisonOperatorDto)predicateDto);
        }
        return predicateDto;
    }

    public static SimplePredicateDto add(SimplePredicateDto simplePredicateDto, SimplePredicateDto add) {
        if (simplePredicateDto instanceof PredicateLogicalAndOperation) {
            ((PredicateLogicalAndOperation)simplePredicateDto).getValues().add(add);
            return simplePredicateDto;
        }
        PredicateLogicalAndOperation and = new PredicateLogicalAndOperation();
        and.getValues().add(simplePredicateDto);
        and.getValues().add(add);
        return and;
    }

    public static PredicateLogicalAndOperation remove(PredicateLogicalAndOperation and, String ... remove) {
        PredicateLogicalAndOperation clone = new PredicateLogicalAndOperation();
        for (int i = 0; i < and.getValues().size(); ++i) {
            SimplePredicateDto simplePredicateDto = and.getValues().get(i);
            if (simplePredicateDto instanceof PredicateComparisonOperatorDto && !ArrayUtils.contains((Object[])remove, (Object)((PredicateComparisonOperatorDto)simplePredicateDto).getStatement())) {
                clone.getValues().add(PredicateHelper.clone(simplePredicateDto));
                continue;
            }
            if (!(simplePredicateDto instanceof PredicateLogicalAndOperation)) continue;
            clone.getValues().add(PredicateHelper.remove((PredicateLogicalAndOperation)simplePredicateDto, remove));
        }
        return clone;
    }
}

