/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.binder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.aql.binder.ContainmentBinder;
import org.ehrbase.aql.binder.OrderByBinder;
import org.ehrbase.aql.binder.SelectBinder;
import org.ehrbase.aql.binder.WhereBinder;
import org.ehrbase.aql.dto.AqlDto;
import org.ehrbase.aql.dto.condition.ParameterValue;
import org.ehrbase.aql.dto.containment.ContainmentDto;
import org.ehrbase.aql.dto.containment.ContainmentExpresionDto;
import org.ehrbase.aql.dto.containment.ContainmentLogicalOperator;
import org.ehrbase.aql.dto.select.SelectStatementDto;
import org.ehrbase.client.aql.condition.Condition;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.containment.ContainmentExpression;
import org.ehrbase.client.aql.field.EhrFields;
import org.ehrbase.client.aql.field.SelectAqlField;
import org.ehrbase.client.aql.query.EntityQuery;
import org.ehrbase.client.aql.query.Query;
import org.ehrbase.client.aql.record.Record;
import org.ehrbase.client.aql.top.Direction;
import org.ehrbase.client.aql.top.TopExpresion;

public class AqlBinder {
    private final SelectBinder selectBinder = new SelectBinder();
    private final ContainmentBinder containmentBinder = new ContainmentBinder();
    private final WhereBinder whereBinder = new WhereBinder();
    private final OrderByBinder orderByBinder = new OrderByBinder();

    public Pair<EntityQuery<Record>, List<ParameterValue>> bind(AqlDto aqlDto) {
        Map<Integer, Containment> containmentMap;
        ContainmentExpression containment;
        if (aqlDto.getContains() != null) {
            Pair<ContainmentExpression, Map<Integer, Containment>> pair = this.containmentBinder.buildContainment(aqlDto.getContains());
            containment = (ContainmentExpression)pair.getLeft();
            containmentMap = (Map)pair.getRight();
        } else {
            containment = null;
            containmentMap = new HashMap();
        }
        Map<Containment, String> variablesMap = this.buildVariableMap(aqlDto.getContains()).entrySet().stream().collect(Collectors.toMap(e -> (Containment)containmentMap.get(e.getKey()), Map.Entry::getValue));
        if (aqlDto.getEhr() != null) {
            containmentMap.put(aqlDto.getEhr().getContainmentId(), EhrFields.EHR_CONTAINMENT);
            if (StringUtils.isNotBlank((CharSequence)aqlDto.getEhr().getIdentifier())) {
                variablesMap.put(EhrFields.EHR_CONTAINMENT, aqlDto.getEhr().getIdentifier());
            }
        }
        SelectAqlField[] selectAqlFields = (SelectAqlField[])aqlDto.getSelect().getStatement().stream().map(s -> this.selectBinder.bind((SelectStatementDto)s, containmentMap)).toArray(SelectAqlField[]::new);
        EntityQuery<Record> query = Query.buildEntityQuery(containment, variablesMap, selectAqlFields);
        ArrayList parameterValues = new ArrayList();
        if (aqlDto.getWhere() != null) {
            Pair<Condition, List<ParameterValue>> conditionPair = this.whereBinder.bind(aqlDto.getWhere(), containmentMap);
            query.where((Condition)conditionPair.getLeft());
            parameterValues.addAll((Collection)conditionPair.getRight());
        }
        if (Direction.FORWARD.equals((Object)aqlDto.getSelect().getTopDirection())) {
            query.top(TopExpresion.forward(aqlDto.getSelect().getTopCount()));
        } else if (Direction.BACKWARD.equals((Object)aqlDto.getSelect().getTopDirection())) {
            query.top(TopExpresion.backward(aqlDto.getSelect().getTopCount()));
        }
        if (aqlDto.getSelect().isDistinct()) {
            query.distinct(true);
        }
        if (!CollectionUtils.isEmpty(aqlDto.getOrderBy())) {
            query.orderBy(this.orderByBinder.bind(aqlDto.getOrderBy(), containmentMap));
        }
        if (aqlDto.getLimit() != null) {
            query.limit(aqlDto.getLimit());
        }
        if (aqlDto.getOffset() != null) {
            query.offset(aqlDto.getOffset());
        }
        return new ImmutablePair(query, parameterValues);
    }

    private Map<Integer, String> buildVariableMap(ContainmentExpresionDto contains) {
        HashMap<Integer, String> variablesMap = new HashMap<Integer, String>();
        if (contains instanceof ContainmentDto) {
            if (StringUtils.isNotBlank((CharSequence)((ContainmentDto)contains).getIdentifier())) {
                variablesMap.put(((ContainmentDto)contains).getId(), ((ContainmentDto)contains).getIdentifier());
            }
            if (((ContainmentDto)contains).getContains() != null) {
                variablesMap.putAll(this.buildVariableMap(((ContainmentDto)contains).getContains()));
            }
        } else if (contains instanceof ContainmentLogicalOperator) {
            ((ContainmentLogicalOperator)contains).getValues().stream().map(this::buildVariableMap).forEach(variablesMap::putAll);
        }
        return variablesMap;
    }
}

