/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.binder;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.dto.select.FunctionDto;
import org.ehrbase.aql.dto.select.SelectFieldDto;
import org.ehrbase.aql.dto.select.SelectStatementDto;
import org.ehrbase.aql.parser.AqlParseException;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.field.NativeSelectAqlField;
import org.ehrbase.client.aql.field.SelectAqlField;
import org.ehrbase.client.aql.funtion.Function;
import org.ehrbase.util.exception.SdkException;

public class SelectBinder {
    public SelectAqlField<Object> bind(SelectStatementDto dto, Map<Integer, Containment> containmentMap) {
        SelectAqlField<Object> selectAqlField;
        if (dto instanceof SelectFieldDto) {
            selectAqlField = this.handleSelectFieldDto((SelectFieldDto)dto, containmentMap);
        } else if (dto instanceof FunctionDto) {
            selectAqlField = this.handleFunctionDto((FunctionDto)dto, containmentMap);
        } else {
            throw new SdkException(String.format("Unexpected class: %s", dto.getClass().getSimpleName()));
        }
        return selectAqlField;
    }

    private SelectAqlField<Object> handleFunctionDto(FunctionDto dto, Map<Integer, Containment> containmentMap) {
        switch (dto.getAqlFunction()) {
            case COUNT: {
                return Function.count(this.bind(dto.getParameters().get(0), containmentMap), dto.getName());
            }
            case MAX: {
                return Function.max(this.bind(dto.getParameters().get(0), containmentMap), dto.getName());
            }
            case MIN: {
                return Function.min(this.bind(dto.getParameters().get(0), containmentMap), dto.getName());
            }
            case AVG: {
                return Function.avg(this.bind(dto.getParameters().get(0), containmentMap), dto.getName());
            }
        }
        throw new AqlParseException(String.format("Unsupported Funktion %s", dto.getAqlFunction().name()));
    }

    public SelectAqlField<Object> handleSelectFieldDto(SelectFieldDto dto, Map<Integer, Containment> containmentMap) {
        NativeSelectAqlField<Object> selectAqlField = new NativeSelectAqlField<Object>(containmentMap.get(dto.getContainmentId()), dto.getAqlPath(), StringUtils.isNotBlank((CharSequence)dto.getName()) ? dto.getName() : null, Object.class);
        return selectAqlField;
    }
}

