/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.aql.funtion;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ehrbase.aql.dto.select.AQLFunction;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.field.SelectAqlField;
import org.ehrbase.client.aql.funtion.Function;

public abstract class AbstractFunction<T>
implements Function,
SelectAqlField<T> {
    private final List<SelectAqlField<?>> parameters = new ArrayList();
    private final AQLFunction function;
    private final String name;

    protected AbstractFunction(List<SelectAqlField<?>> parameters, AQLFunction function, String name) {
        this.parameters.addAll(parameters);
        this.function = function;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<SelectAqlField<?>> getParameters() {
        return this.parameters;
    }

    @Override
    public String buildAQL(Containment ehrContainment) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.function.toString()).append("(");
        if (this.parameters != null) {
            sb.append(this.parameters.stream().map(f -> f.buildAQL(ehrContainment)).collect(Collectors.joining(",")));
        }
        sb.append(")");
        return sb.toString();
    }

    protected static <X> AbstractFunction<X> create(List<SelectAqlField<?>> parameters, final AQLFunction function, String name, final Class<X> aClass) {
        return new AbstractFunction<X>(parameters, function, name){

            @Override
            public Containment getContainment() {
                return null;
            }

            @Override
            public String getPath() {
                return function.name();
            }

            @Override
            public Class<?> getEntityClass() {
                return null;
            }

            @Override
            public Class<X> getValueClass() {
                return aClass;
            }

            @Override
            public boolean isMultiValued() {
                return false;
            }
        };
    }
}

