/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.dto.path;

import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorSymbol;
import org.ehrbase.aql.dto.condition.SimpleValue;
import org.ehrbase.aql.dto.path.predicate.PredicateComparisonOperatorDto;
import org.ehrbase.aql.dto.path.predicate.PredicateDto;
import org.ehrbase.aql.dto.path.predicate.PredicateHelper;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalAndOperation;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalOrOperation;
import org.ehrbase.aql.dto.path.predicate.SimplePredicateDto;
import org.ehrbase.aql.util.CharSequenceHelper;
import org.ehrbase.util.exception.SdkException;

public final class AqlPath
implements Serializable {
    public static final AqlPath EMPTY_PATH = new AqlPath(true, new AqlNode[0], 0, null);
    public static final AqlPath ROOT_PATH = new AqlPath(false, new AqlNode[0], 0, null);
    private static final AqlNode NO_NODE = new AqlNode("", null, new PredicateLogicalAndOperation());
    public static final String NAME_VALUE_KEY = "name/value";
    private final boolean isEmpty;
    private final AqlNode[] nodes;
    private final int firstNode;
    private final String attributeName;
    private transient Integer hashCode;

    private AqlPath(boolean isEmpty, AqlNode[] nodes, int firstNode, String attributeName) {
        this.isEmpty = isEmpty;
        if (isEmpty) {
            this.nodes = new AqlNode[0];
            this.firstNode = 0;
        } else {
            this.nodes = nodes;
            this.firstNode = firstNode;
        }
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public AqlPath withAttributeName(String attributeName) {
        return new AqlPath(this.isEmpty, this.nodes, this.firstNode, attributeName);
    }

    public int getNodeCount() {
        return this.nodes.length - this.firstNode;
    }

    public AqlNode getNode(int pos) {
        return this.nodes[this.firstNode + pos];
    }

    public List<AqlNode> getNodes() {
        return Collections.unmodifiableList(Arrays.asList(this.nodes).subList(this.firstNode, this.nodes.length));
    }

    public AqlNode getBaseNode() {
        return this.firstNode == this.nodes.length ? NO_NODE : this.nodes[this.firstNode];
    }

    public AqlNode getLastNode() {
        return this.firstNode == this.nodes.length ? NO_NODE : this.nodes[this.nodes.length - 1];
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean hasPath() {
        return this.getNodeCount() > 0;
    }

    public boolean startsWith(AqlPath aqlPath) {
        if (this.getNodeCount() < aqlPath.getNodeCount()) {
            return false;
        }
        for (int i = 0; i < aqlPath.getNodeCount(); ++i) {
            if (aqlPath.getNode(i).equals(this.getNode(i))) continue;
            return false;
        }
        return true;
    }

    public AqlPath removeStart(AqlPath remove) {
        if (remove.hasPath() && this.startsWith(remove)) {
            return this.removeStart(remove.getNodeCount());
        }
        return this;
    }

    public AqlPath removeStart(int nodeCount) {
        if (this.isEmpty || nodeCount == 0) {
            return this;
        }
        if (nodeCount == this.getNodeCount()) {
            if (this.getAttributeName() != null) {
                return EMPTY_PATH.withAttributeName(this.attributeName);
            }
            return EMPTY_PATH;
        }
        if (nodeCount < 1 || nodeCount > this.getNodeCount()) {
            throw new IllegalArgumentException();
        }
        return new AqlPath(false, this.nodes, this.firstNode + nodeCount, this.attributeName);
    }

    public AqlPath getEnd(int nodeCount) {
        if (this.isEmpty) {
            return this;
        }
        if (nodeCount == this.getNodeCount()) {
            return this;
        }
        if (nodeCount < 0 || nodeCount >= this.getNodeCount()) {
            throw new IllegalArgumentException();
        }
        return new AqlPath(nodeCount == 0, this.nodes, this.nodes.length - nodeCount, this.attributeName);
    }

    public AqlPath addEnd(AqlPath add) {
        if (this.isEmpty) {
            return add;
        }
        if (add.isEmpty) {
            return this;
        }
        AqlNode[] mergedNodes = new AqlNode[this.getNodeCount() + add.getNodeCount()];
        System.arraycopy(this.nodes, this.firstNode, mergedNodes, 0, this.getNodeCount());
        System.arraycopy(add.nodes, add.firstNode, mergedNodes, this.getNodeCount(), add.getNodeCount());
        return new AqlPath(false, mergedNodes, 0, add.getAttributeName());
    }

    public AqlPath addEnd(AqlNode ... nodesToAdd) {
        int nodeCount = this.getNodeCount();
        AqlNode[] mergedNodes = new AqlNode[nodeCount + nodesToAdd.length];
        System.arraycopy(this.nodes, this.firstNode, mergedNodes, 0, nodeCount);
        System.arraycopy(nodesToAdd, 0, mergedNodes, nodeCount, nodesToAdd.length);
        return new AqlPath(false, mergedNodes, 0, null);
    }

    public AqlPath addEnd(String ... pathExp) {
        if (pathExp.length == 0) {
            return this;
        }
        AqlPath[] paths = (AqlPath[])Arrays.stream(pathExp).map(AqlPath::parse).toArray(AqlPath[]::new);
        String newAttributeName = paths[paths.length - 1].attributeName;
        AqlNode[] nodesToAdd = (AqlNode[])Arrays.stream(pathExp).map(AqlPath::parse).map(AqlPath::getNodes).flatMap(Collection::stream).toArray(AqlNode[]::new);
        if (nodesToAdd.length == 0) {
            if (Objects.equals(this.attributeName, newAttributeName)) {
                return this;
            }
            return new AqlPath(this.isEmpty, this.nodes, this.firstNode, newAttributeName);
        }
        int nodeCount = this.getNodeCount();
        AqlNode[] mergedNodes = new AqlNode[nodeCount + nodesToAdd.length];
        System.arraycopy(this.nodes, this.firstNode, mergedNodes, 0, nodeCount);
        System.arraycopy(nodesToAdd, 0, mergedNodes, nodeCount, nodesToAdd.length);
        return new AqlPath(false, mergedNodes, 0, newAttributeName);
    }

    public AqlPath removeEnd(AqlPath remove) {
        if (!StringUtils.equals((CharSequence)this.attributeName, (CharSequence)remove.attributeName)) {
            return this;
        }
        int remainingNodes = this.getNodeCount() - remove.getNodeCount();
        if (remainingNodes < 1) {
            return this;
        }
        for (int i = 0; i < remove.getNodeCount(); ++i) {
            if (this.getNode(remainingNodes + i).equals(remove.getNode(i))) continue;
            return this;
        }
        AqlNode[] subNodes = Arrays.copyOfRange(this.nodes, this.firstNode, this.firstNode + remainingNodes);
        return new AqlPath(false, subNodes, 0, null);
    }

    public AqlPath removeEnd(int nodeCount) {
        if (this.isEmpty || nodeCount == 0) {
            return this;
        }
        if (nodeCount == this.getNodeCount()) {
            return ROOT_PATH;
        }
        if (nodeCount < 1 || nodeCount > this.getNodeCount()) {
            throw new IllegalArgumentException();
        }
        AqlNode[] subNodes = Arrays.copyOfRange(this.nodes, this.firstNode, this.nodes.length - nodeCount);
        return new AqlPath(false, subNodes, 0, null);
    }

    public AqlPath replaceNode(int pos, AqlNode newNode) {
        AqlNode[] newNodes = Arrays.copyOfRange(this.nodes, this.firstNode, this.nodes.length);
        newNodes[pos] = newNode;
        return new AqlPath(this.isEmpty, newNodes, 0, this.attributeName);
    }

    public AqlPath replaceLastNode(UnaryOperator<AqlNode> op) {
        if (this.getNodeCount() == 0) {
            return this;
        }
        int pos = this.nodes.length - 1;
        AqlNode oldNode = this.nodes[pos];
        AqlNode newNode = (AqlNode)op.apply(oldNode);
        if (newNode == null) {
            return this.removeEnd(1);
        }
        if (oldNode.equals(newNode)) {
            return this;
        }
        return this.replaceNode(this.getNodeCount() - 1, newNode);
    }

    public String getPath() {
        return this.format(OtherPredicatesFormat.FULL, false);
    }

    public String format(boolean withOtherPredicates) {
        if (withOtherPredicates) {
            return this.format(OtherPredicatesFormat.FULL, true);
        }
        return this.format(OtherPredicatesFormat.NONE, true);
    }

    public String format(OtherPredicatesFormat otherPredicatesFormat, boolean includeAttributeName) {
        StringBuilder sb = new StringBuilder();
        this.appendFormat(sb, otherPredicatesFormat, includeAttributeName);
        return sb.toString();
    }

    private void appendFormat(StringBuilder sb, OtherPredicatesFormat otherPredicatesFormat, boolean includeAttributeName) {
        if (!this.isEmpty) {
            if (this.getNodeCount() == 0) {
                sb.append('/');
            } else {
                for (int i = this.firstNode; i < this.nodes.length; ++i) {
                    sb.append('/');
                    AqlNode node = this.nodes[i];
                    node.appendFormat(sb, otherPredicatesFormat);
                }
            }
        }
        if (includeAttributeName && this.attributeName != null) {
            sb.append("|").append(this.attributeName);
        }
    }

    public static AqlPath parse(String pathExp) {
        return AqlPath.parse(pathExp, null);
    }

    public static AqlPath parse(String pathExp, String nameValue) {
        if (StringUtils.isBlank((CharSequence)pathExp)) {
            return EMPTY_PATH;
        }
        String attributeName = null;
        CharSequence[] nodeStrings = AqlPath.split(CharSequenceHelper.removeStart(pathExp, "/"), null, false, "/");
        ArrayList nodes = new ArrayList(nodeStrings.length);
        for (int i = 0; i < nodeStrings.length; ++i) {
            boolean isLastNode;
            CharSequence currentNode = nodeStrings[i];
            boolean bl = isLastNode = nodeStrings.length == i + 1;
            if (isLastNode) {
                CharSequence[] attributeSplit = AqlPath.split(currentNode, 2, false, "|");
                if (attributeSplit.length == 2) {
                    attributeName = attributeSplit[1].toString();
                }
                currentNode = attributeSplit[0];
            }
            AqlPath.parseNode(currentNode, isLastNode, nameValue).ifPresent(nodes::add);
        }
        boolean isAttributeOnly = attributeName != null && pathExp.startsWith("|");
        return new AqlPath(isAttributeOnly, (AqlNode[])nodes.toArray(AqlNode[]::new), 0, attributeName);
    }

    private static Optional<AqlNode> parseNode(CharSequence currentNode, boolean isLastNode, String nameValue) {
        String atCode;
        PredicateLogicalAndOperation otherPredicates;
        CharSequence predicatesExp;
        String nodeName;
        if (StringUtils.endsWith((CharSequence)currentNode, (CharSequence)"]")) {
            int fist = StringUtils.indexOf((CharSequence)currentNode, (int)91);
            nodeName = CharSequenceHelper.subSequence(currentNode, 0, fist).toString();
            predicatesExp = CharSequenceHelper.subSequence(currentNode, fist + 1, currentNode.length() - 1);
        } else {
            nodeName = currentNode.toString();
            predicatesExp = null;
        }
        if (StringUtils.isEmpty((CharSequence)nodeName)) {
            return Optional.empty();
        }
        PredicateDto predicateDto = null;
        if (predicatesExp != null) {
            predicateDto = PredicateHelper.buildPredicate(predicatesExp.toString());
            if (predicateDto instanceof PredicateLogicalOrOperation) {
                throw new SdkException("Or in predicate not supported");
            }
            if (predicateDto instanceof PredicateLogicalAndOperation) {
                otherPredicates = (PredicateLogicalAndOperation)predicateDto;
            } else {
                otherPredicates = new PredicateLogicalAndOperation();
                otherPredicates.getValues().add((SimplePredicateDto)predicateDto);
            }
            atCode = PredicateHelper.find(otherPredicates, "archetype_node_id").map(PredicateComparisonOperatorDto::getValue).map(SimpleValue.class::cast).map(SimpleValue::getValue).map(Object::toString).orElse(null);
        } else {
            atCode = null;
            otherPredicates = new PredicateLogicalAndOperation();
        }
        AqlNode node = new AqlNode(nodeName, atCode, otherPredicates);
        if (nameValue != null && isLastNode) {
            node = node.withNameValue(nameValue);
        }
        return Optional.of(node);
    }

    public static CharSequence[] split(CharSequence path, Integer max, boolean addSearch, String ... search) {
        ArrayList<CharSequence> strings = new ArrayList<CharSequence>();
        Arrays.sort(search, CharSequence::compare);
        boolean inBrackets = false;
        boolean inQuotes = false;
        boolean escape = false;
        int last = 0;
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (!inQuotes && ch == '[') {
                inBrackets = true;
                escape = false;
                continue;
            }
            if (!inQuotes && ch == ']') {
                inBrackets = false;
                escape = false;
                continue;
            }
            if (!escape && ch == '\'') {
                inQuotes = !inQuotes;
                continue;
            }
            if (!escape && ch == '\\') {
                escape = true;
                continue;
            }
            if (inBrackets || inQuotes) {
                escape = false;
                continue;
            }
            CharSequence prefix = AqlPath.findPrefix(path, i, search);
            if (prefix == null) {
                escape = false;
                continue;
            }
            strings.add(CharSequenceHelper.subSequence(path, last, i));
            if (addSearch) {
                strings.add(prefix);
            }
            last = prefix.length() + i;
            if (max == null || strings.size() != max - 1) continue;
            strings.add(CharSequenceHelper.subSequence(path, last, path.length()));
            break;
        }
        if (strings.isEmpty()) {
            strings.add(path);
        } else if (last < path.length() && max == null) {
            strings.add(CharSequenceHelper.subSequence(path, last, path.length()));
        }
        return (CharSequence[])strings.toArray(CharSequence[]::new);
    }

    private static CharSequence findPrefix(CharSequence fullPath, int startPos, String[] search) {
        CharBuffer pathAfter = CharSequenceHelper.subSequence(fullPath, startPos, fullPath.length());
        int insertionPoint = Arrays.binarySearch(search, pathAfter, CharSequence::compare);
        if (insertionPoint >= 0) {
            return search[insertionPoint];
        }
        int prefixPos = -insertionPoint - 2;
        if (prefixPos < 0) {
            return null;
        }
        String candidate = search[prefixPos];
        if (candidate.length() <= pathAfter.length() && 0 == CharSequence.compare(candidate, pathAfter.subSequence(0, candidate.length()))) {
            return candidate;
        }
        return null;
    }

    public boolean equals(Object o) {
        return this.equals(o, true);
    }

    public boolean equals(Object o, boolean withOtherPredicates) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (withOtherPredicates && this.hashCode() != o.hashCode()) {
            return false;
        }
        AqlPath aqlPath = (AqlPath)o;
        if (this.isEmpty == aqlPath.isEmpty) {
            if (this.getNodeCount() != aqlPath.getNodeCount()) {
                return false;
            }
            int c = this.getNodeCount();
            for (int i = 0; i < c; ++i) {
                if (this.getNode(i).equals(aqlPath.getNode(i), withOtherPredicates)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = Objects.hash(this.attributeName, this.isEmpty);
            int c = this.nodes.length;
            for (int i = this.firstNode; i < c; ++i) {
                result = 31 * result + this.nodes[i].hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.format(true);
    }

    public static final class AqlNode
    implements Serializable {
        private final String name;
        private final String atCode;
        private final PredicateLogicalAndOperation otherPredicate;
        private transient Integer hashCode;

        public AqlNode(String name, String atCode, PredicateLogicalAndOperation otherPredicates) {
            this.name = name;
            this.atCode = StringUtils.isBlank((CharSequence)atCode) ? null : atCode;
            this.otherPredicate = otherPredicates;
        }

        public String getName() {
            return this.name;
        }

        public String getAtCode() {
            return this.atCode;
        }

        public AqlNode withAtCode(String atCode) {
            if (atCode != null) {
                return new AqlNode(this.name, atCode, this.replace("archetype_node_id", atCode));
            }
            return new AqlNode(this.name, null, this.remove("archetype_node_id"));
        }

        private PredicateLogicalAndOperation replace(String archetypeNodeId, String atCode) {
            PredicateLogicalAndOperation newPredicateDto = PredicateHelper.clone(this.otherPredicate);
            Optional<PredicateComparisonOperatorDto> predicateComparisonOperatorDto = PredicateHelper.find(newPredicateDto, archetypeNodeId);
            if (predicateComparisonOperatorDto.isPresent()) {
                predicateComparisonOperatorDto.get().setValue(new SimpleValue(atCode));
            } else {
                PredicateComparisonOperatorDto add = new PredicateComparisonOperatorDto();
                add.setStatement(archetypeNodeId);
                add.setSymbol(ConditionComparisonOperatorSymbol.EQ);
                add.setValue(new SimpleValue(atCode));
                newPredicateDto.getValues().add(add);
            }
            return newPredicateDto;
        }

        public AqlNode withNameValue(String nameValue) {
            if (Objects.equals(nameValue, PredicateHelper.find(this.otherPredicate, AqlPath.NAME_VALUE_KEY))) {
                return this;
            }
            if (nameValue != null) {
                return new AqlNode(this.name, this.atCode, this.replace(AqlPath.NAME_VALUE_KEY, nameValue));
            }
            return new AqlNode(this.name, this.atCode, this.remove(AqlPath.NAME_VALUE_KEY));
        }

        private PredicateLogicalAndOperation remove(String nameValue) {
            PredicateLogicalAndOperation newPredicateDto = PredicateHelper.clone(this.otherPredicate);
            Optional<PredicateComparisonOperatorDto> predicateComparisonOperatorDto = PredicateHelper.find(newPredicateDto, nameValue);
            predicateComparisonOperatorDto.ifPresent(p -> newPredicateDto.getValues().remove(p));
            return newPredicateDto;
        }

        public PredicateLogicalAndOperation getOtherPredicate() {
            return this.otherPredicate;
        }

        public String findOtherPredicate(String name) {
            return PredicateHelper.find(this.otherPredicate, name).map(PredicateComparisonOperatorDto::getValue).filter(SimpleValue.class::isInstance).map(SimpleValue.class::cast).map(SimpleValue::getValue).map(Object::toString).orElse(null);
        }

        public AqlNode clearOtherPredicates() {
            PredicateLogicalAndOperation otherPredicates = new PredicateLogicalAndOperation();
            if (this.atCode != null) {
                PredicateComparisonOperatorDto predicateComparisonOperatorDto = new PredicateComparisonOperatorDto();
                predicateComparisonOperatorDto.setStatement("archetype_node_id");
                predicateComparisonOperatorDto.setSymbol(ConditionComparisonOperatorSymbol.EQ);
                predicateComparisonOperatorDto.setValue(new SimpleValue(this.atCode));
                otherPredicates.getValues().add(predicateComparisonOperatorDto);
            }
            return new AqlNode(this.name, this.atCode, otherPredicates);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (this.hashCode() != o.hashCode()) {
                return false;
            }
            AqlNode aqlNode = (AqlNode)o;
            return Objects.equals(this.name, aqlNode.name) && Objects.equals(this.atCode, aqlNode.atCode) && Objects.equals(this.otherPredicate, aqlNode.otherPredicate);
        }

        public boolean equals(AqlNode o, boolean withOtherPredicates) {
            if (withOtherPredicates) {
                return this.equals(o);
            }
            return Objects.equals(this.name, o.name) && Objects.equals(this.atCode, o.atCode);
        }

        public int hashCode() {
            if (this.hashCode == null) {
                this.hashCode = Objects.hash(this.name, this.atCode, this.otherPredicate);
            }
            return this.hashCode;
        }

        public void appendFormat(StringBuilder sb, OtherPredicatesFormat otherPredicatesFormat) {
            sb.append(this.name);
            if (!this.otherPredicate.getValues().isEmpty()) {
                sb.append("[");
                PredicateHelper.format(sb, this.otherPredicate, otherPredicatesFormat);
                sb.append("]");
            }
        }
    }

    public static enum OtherPredicatesFormat {
        NONE,
        SHORTED,
        FULL;

    }
}

