/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.util;

import java.nio.CharBuffer;
import org.apache.commons.lang3.StringUtils;

public class CharSequenceHelper {
    private CharSequenceHelper() {
    }

    public static CharBuffer subSequence(CharSequence str, int beginIndex, int endIndex) {
        return CharBuffer.wrap(str, beginIndex, endIndex);
    }

    public static CharSequence removeStart(CharSequence str, String remove) {
        if (StringUtils.isEmpty((CharSequence)str) || str.length() < remove.length()) {
            return str;
        }
        if (0 == CharSequence.compare(remove, CharBuffer.wrap(str, 0, remove.length()))) {
            return CharBuffer.wrap(str, remove.length(), str.length());
        }
        return str;
    }

    public static CharSequence removeEnd(CharSequence str, String remove) {
        if (StringUtils.isEmpty((CharSequence)str) || str.length() < remove.length()) {
            return str;
        }
        if (0 == CharSequence.compare(remove, CharBuffer.wrap(str, str.length() - remove.length(), str.length()))) {
            return CharBuffer.wrap(str, 0, str.length() - remove.length());
        }
        return str;
    }

    public static CharSequence[] splitFirst(CharSequence str, char separator) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new CharSequence[0];
        }
        int pos = StringUtils.indexOf((CharSequence)str, (int)separator);
        if (pos < 0) {
            return new CharSequence[]{str};
        }
        if (pos == 0) {
            if (str.length() == 1) {
                return new CharSequence[0];
            }
            return new CharSequence[]{CharBuffer.wrap(str, 1, str.length())};
        }
        if (pos + 1 == str.length()) {
            return new CharSequence[]{CharBuffer.wrap(str, 0, pos)};
        }
        return new CharSequence[]{CharBuffer.wrap(str, 0, pos), CharBuffer.wrap(str, pos + 1, str.length())};
    }
}

