/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.dto.condition;

import java.io.Serializable;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import org.ehrbase.aql.dto.condition.Value;

public final class SimpleValue
implements Value,
Serializable {
    private final Object value;
    public static final SimpleValue NULL_VALUE = new SimpleValue();
    private static final Class[] SUPPORTED_TYPES = new Class[]{String.class, TemporalAccessor.class, Number.class, Boolean.class};
    private static final String ERR_UNSUPPORTED_TYPE = "Type not supported: %s";

    public SimpleValue() {
        this.value = null;
    }

    private SimpleValue(Object value) {
        this.value = value;
    }

    public SimpleValue(String value) {
        this.value = value;
    }

    public SimpleValue(Number value) {
        this.value = value;
    }

    public SimpleValue(Boolean value) {
        this.value = value;
    }

    public SimpleValue(SimpleValue other) {
        this.value = other.value;
    }

    public SimpleValue(TemporalAccessor value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public static SimpleValue forImmutableObject(Object immutableObject) {
        if (immutableObject == null) {
            return NULL_VALUE;
        }
        Class<?> objectType = immutableObject.getClass();
        if (objectType == SimpleValue.class) {
            return (SimpleValue)immutableObject;
        }
        for (int i = 0; i < SUPPORTED_TYPES.length; ++i) {
            if (!SUPPORTED_TYPES[i].isAssignableFrom(objectType)) continue;
            return new SimpleValue(immutableObject);
        }
        throw new IllegalArgumentException(String.format(ERR_UNSUPPORTED_TYPE, objectType.getName()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleValue)) {
            return false;
        }
        SimpleValue other = (SimpleValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object otherValue = other.getValue();
        return Objects.equals(this.value, otherValue);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleValue(value=" + this.getValue() + ")";
    }
}

