/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.dto.path.predicate;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.ehrbase.aql.dto.condition.LogicalOperatorDto;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalOperatorSymbol;
import org.ehrbase.aql.dto.path.predicate.SimplePredicateDto;

public final class PredicateLogicalAndOperation
implements LogicalOperatorDto<PredicateLogicalOperatorSymbol, SimplePredicateDto>,
SimplePredicateDto,
Serializable {
    private final PredicateLogicalOperatorSymbol symbol = PredicateLogicalOperatorSymbol.AND;
    private List<SimplePredicateDto> values;

    public PredicateLogicalAndOperation() {
        this.values = List.of();
    }

    public PredicateLogicalAndOperation(SimplePredicateDto ... values) {
        this.values = List.of(values);
    }

    @Override
    public PredicateLogicalOperatorSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public List<SimplePredicateDto> getValues() {
        return this.values;
    }

    public PredicateLogicalAndOperation addValues(Stream<SimplePredicateDto> valuesStream) {
        SimplePredicateDto[] newValues = (SimplePredicateDto[])Stream.concat(this.values.stream(), valuesStream).toArray(SimplePredicateDto[]::new);
        return new PredicateLogicalAndOperation(newValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateLogicalAndOperation that = (PredicateLogicalAndOperation)o;
        return this.symbol == that.symbol && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.values);
    }

    public String toString() {
        return "PredicateLogicalAndOperation{symbol=" + this.symbol + ", values=" + this.values + "}";
    }
}

