/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.binder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.aql.binder.SelectBinder;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorDto;
import org.ehrbase.aql.dto.condition.ConditionDto;
import org.ehrbase.aql.dto.condition.ConditionLogicalOperatorDto;
import org.ehrbase.aql.dto.condition.ConditionLogicalOperatorSymbol;
import org.ehrbase.aql.dto.condition.ExistsConditionOperatorDto;
import org.ehrbase.aql.dto.condition.LikeOperatorDto;
import org.ehrbase.aql.dto.condition.MatchesOperatorDto;
import org.ehrbase.aql.dto.condition.NotConditionOperatorDto;
import org.ehrbase.aql.dto.condition.ParameterValue;
import org.ehrbase.aql.dto.condition.SimpleValue;
import org.ehrbase.aql.dto.select.SelectStatementDto;
import org.ehrbase.client.aql.condition.ComparisonOperator;
import org.ehrbase.client.aql.condition.Condition;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.field.SelectAqlField;
import org.ehrbase.client.aql.parameter.Parameter;
import org.ehrbase.util.exception.SdkException;

public class WhereBinder {
    private final SelectBinder selectBinder = new SelectBinder();

    public Pair<Condition, List<ParameterValue>> bind(ConditionDto dto, Map<Integer, Containment> containmentMap) {
        Condition condition;
        ArrayList parameterList = new ArrayList();
        if (dto instanceof ConditionComparisonOperatorDto) {
            Pair<Condition, List<ParameterValue>> pair = this.handleComparisonOperator((ConditionComparisonOperatorDto)dto, containmentMap);
            condition = (Condition)pair.getLeft();
            parameterList.addAll((Collection)pair.getRight());
        } else if (dto instanceof ConditionLogicalOperatorDto) {
            Pair<Condition, List<ParameterValue>> pair = this.handleConditionLogicalOperator((ConditionLogicalOperatorDto)dto, containmentMap);
            condition = (Condition)pair.getLeft();
            parameterList.addAll((Collection)pair.getRight());
        } else if (dto instanceof MatchesOperatorDto) {
            Object[] value = ((MatchesOperatorDto)dto).getValues().stream().filter(f -> f.getClass().equals(SimpleValue.class)).map(SimpleValue.class::cast).map(SimpleValue::getValue).toArray();
            if (value.length != ((MatchesOperatorDto)dto).getValues().size()) {
                throw new SdkException("Only simple values are supported Matches");
            }
            condition = Condition.matches(this.selectBinder.bind(((MatchesOperatorDto)dto).getStatement(), containmentMap), value);
        } else if (dto instanceof ExistsConditionOperatorDto) {
            condition = Condition.exists(this.selectBinder.bind(((ExistsConditionOperatorDto)dto).getValue(), containmentMap));
        } else if (dto instanceof NotConditionOperatorDto) {
            condition = Condition.not((Condition)this.bind(((NotConditionOperatorDto)dto).getConditionDto(), containmentMap).getLeft());
        } else if (dto instanceof LikeOperatorDto) {
            Pair<Condition, List<ParameterValue>> pair = this.handleLikeOperator((LikeOperatorDto)dto, containmentMap);
            condition = (Condition)pair.getLeft();
            parameterList.addAll((Collection)pair.getRight());
        } else {
            throw new SdkException(String.format("Unexpected class: %s", dto.getClass().getName()));
        }
        return new ImmutablePair((Object)condition, parameterList);
    }

    private Pair<Condition, List<ParameterValue>> handleConditionLogicalOperator(ConditionLogicalOperatorDto dto, Map<Integer, Containment> containmentMap) {
        Pair<Condition, List<ParameterValue>> pair = this.bind(dto.getValues().get(0), containmentMap);
        Condition condition = (Condition)pair.getLeft();
        List parameterList = (List)pair.getRight();
        Pair<Condition, List<ParameterValue>> subPair = pair;
        for (int i = 1; i < dto.getValues().size(); ++i) {
            subPair = this.buildLogicalOperator(dto.getSymbol(), subPair, this.bind(dto.getValues().get(i), containmentMap));
            condition = (Condition)subPair.getLeft();
            parameterList = (List)subPair.getRight();
        }
        return Pair.of((Object)condition, (Object)parameterList);
    }

    private Pair<Condition, List<ParameterValue>> handleComparisonOperator(ConditionComparisonOperatorDto dto, Map<Integer, Containment> containmentMap) {
        return this.handleComparisonOperator(dto.getValue(), dto.getSymbol().getSymbol(), dto.getStatement(), dto.getClass(), containmentMap);
    }

    private Pair<Condition, List<ParameterValue>> handleLikeOperator(LikeOperatorDto dto, Map<Integer, Containment> containmentMap) {
        return this.handleComparisonOperator(dto.getValue(), "like", dto.getStatement(), dto.getClass(), containmentMap);
    }

    private Pair<Condition, List<ParameterValue>> handleComparisonOperator(Object value, String operatorSymbol, SelectStatementDto statement, Class<?> dtoClass, Map<Integer, Containment> containmentMap) {
        Condition condition;
        ArrayList<ParameterValue> parameterList = new ArrayList<ParameterValue>();
        SelectAqlField<Object> field = this.selectBinder.bind(statement, containmentMap);
        if (value instanceof SimpleValue) {
            SimpleValue simpleValue = (SimpleValue)value;
            Object conditionValue = simpleValue.getValue();
            condition = ComparisonOperator.valueComparison(field, operatorSymbol, conditionValue);
        } else if (value instanceof ParameterValue) {
            ParameterValue parameterValue = (ParameterValue)value;
            Parameter conditionValue = new Parameter(parameterValue.getName());
            condition = ComparisonOperator.parameterComparison(field, operatorSymbol, conditionValue);
            parameterList.add(parameterValue);
        } else {
            throw new SdkException(String.format("Unexpected value type %s in %s", Optional.of(value).map(Object::getClass).map(Class::getName).orElse("null"), dtoClass.getName()));
        }
        return Pair.of((Object)condition, parameterList);
    }

    private Pair<Condition, List<ParameterValue>> buildLogicalOperator(ConditionLogicalOperatorSymbol symbol, Pair<Condition, List<ParameterValue>> pair1, Pair<Condition, List<ParameterValue>> pair2) {
        Condition containmentExpression;
        switch (symbol) {
            case OR: {
                containmentExpression = ((Condition)pair1.getLeft()).or((Condition)pair2.getLeft());
                break;
            }
            case AND: {
                containmentExpression = ((Condition)pair1.getLeft()).and((Condition)pair2.getLeft());
                break;
            }
            default: {
                throw new SdkException(String.format("Unknown Symbol %s", symbol));
            }
        }
        ((List)pair1.getRight()).addAll((Collection)pair2.getRight());
        return new ImmutablePair((Object)containmentExpression, (Object)((List)pair1.getRight()));
    }
}

