/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.dto.path;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorSymbol;
import org.ehrbase.aql.dto.condition.SimpleValue;
import org.ehrbase.aql.dto.condition.Value;
import org.ehrbase.aql.dto.path.AqlPathHelper;
import org.ehrbase.aql.dto.path.predicate.PredicateComparisonOperatorDto;
import org.ehrbase.aql.dto.path.predicate.PredicateDto;
import org.ehrbase.aql.dto.path.predicate.PredicateHelper;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalAndOperation;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalOrOperation;
import org.ehrbase.aql.dto.path.predicate.SimplePredicateDto;
import org.ehrbase.aql.util.CharSequenceHelper;
import org.ehrbase.util.exception.SdkException;

public final class AqlPath
implements Serializable {
    public static final AqlPath EMPTY_PATH = new AqlPath(true, new AqlNode[0], 0, null);
    public static final AqlPath ROOT_PATH = new AqlPath(false, new AqlNode[0], 0, null);
    private static final AqlNode NO_NODE = new AqlNode("", null, new PredicateLogicalAndOperation());
    public static final String NAME_VALUE_KEY = "name/value";
    public static final AqlPathHelper.PrefixMatcher ATTRIBUTE_SEPARATOR = AqlPathHelper.PrefixMatcher.forChar('|');
    public static final AqlPathHelper.PrefixMatcher PATH_SEPARATOR = AqlPathHelper.PrefixMatcher.forChar('/');
    private final boolean isEmpty;
    private final AqlNode[] nodes;
    private final int firstNode;
    private final String attributeName;
    private final int hashCode;
    private String[] formatCache;

    private AqlPath(boolean isEmpty, AqlNode[] nodes, int firstNode, String attributeName) {
        this.isEmpty = isEmpty;
        if (isEmpty) {
            this.nodes = new AqlNode[0];
            this.firstNode = 0;
        } else {
            this.nodes = nodes;
            this.firstNode = firstNode;
        }
        this.attributeName = attributeName;
        this.hashCode = this.calcHash();
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public AqlPath withAttributeName(String attributeName) {
        return new AqlPath(this.isEmpty, this.nodes, this.firstNode, attributeName);
    }

    public int getNodeCount() {
        return this.nodes.length - this.firstNode;
    }

    public AqlNode getNode(int pos) {
        return this.nodes[this.firstNode + pos];
    }

    public List<AqlNode> getNodes() {
        return Collections.unmodifiableList(Arrays.asList(this.nodes).subList(this.firstNode, this.nodes.length));
    }

    public AqlNode getBaseNode() {
        return this.firstNode == this.nodes.length ? NO_NODE : this.nodes[this.firstNode];
    }

    public AqlNode getLastNode() {
        return this.firstNode == this.nodes.length ? NO_NODE : this.nodes[this.nodes.length - 1];
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean hasPath() {
        return this.getNodeCount() > 0;
    }

    public boolean startsWith(AqlPath aqlPath) {
        if (this.getNodeCount() < aqlPath.getNodeCount()) {
            return false;
        }
        for (int i = 0; i < aqlPath.getNodeCount(); ++i) {
            if (aqlPath.getNode(i).equals(this.getNode(i))) continue;
            return false;
        }
        return true;
    }

    public AqlPath removeStart(AqlPath remove) {
        if (remove.hasPath() && this.startsWith(remove)) {
            return this.removeStart(remove.getNodeCount());
        }
        return this;
    }

    public AqlPath removeStart(int nodeCount) {
        if (this.isEmpty || nodeCount == 0) {
            return this;
        }
        if (nodeCount == this.getNodeCount()) {
            if (this.getAttributeName() != null) {
                return EMPTY_PATH.withAttributeName(this.attributeName);
            }
            return EMPTY_PATH;
        }
        if (nodeCount < 1 || nodeCount > this.getNodeCount()) {
            throw new IllegalArgumentException();
        }
        return new AqlPath(false, this.nodes, this.firstNode + nodeCount, this.attributeName);
    }

    public AqlPath getEnd(int nodeCount) {
        if (this.isEmpty) {
            return this;
        }
        if (nodeCount == this.getNodeCount()) {
            return this;
        }
        if (nodeCount < 0 || nodeCount >= this.getNodeCount()) {
            throw new IllegalArgumentException();
        }
        return new AqlPath(nodeCount == 0, this.nodes, this.nodes.length - nodeCount, this.attributeName);
    }

    public AqlPath addEnd(AqlPath add) {
        if (this.isEmpty) {
            return add;
        }
        if (add.isEmpty) {
            return this;
        }
        AqlNode[] mergedNodes = new AqlNode[this.getNodeCount() + add.getNodeCount()];
        System.arraycopy(this.nodes, this.firstNode, mergedNodes, 0, this.getNodeCount());
        System.arraycopy(add.nodes, add.firstNode, mergedNodes, this.getNodeCount(), add.getNodeCount());
        return new AqlPath(false, mergedNodes, 0, add.getAttributeName());
    }

    public AqlPath addEnd(AqlNode ... nodesToAdd) {
        int nodeCount = this.getNodeCount();
        AqlNode[] mergedNodes = new AqlNode[nodeCount + nodesToAdd.length];
        System.arraycopy(this.nodes, this.firstNode, mergedNodes, 0, nodeCount);
        System.arraycopy(nodesToAdd, 0, mergedNodes, nodeCount, nodesToAdd.length);
        return new AqlPath(false, mergedNodes, 0, null);
    }

    public AqlPath addEnd(String ... pathExp) {
        if (pathExp.length == 0) {
            return this;
        }
        AqlPath lastPath = AqlPath.parse(pathExp[pathExp.length - 1]);
        String newAttributeName = lastPath.attributeName;
        AqlNode[] nodesToAdd = (AqlNode[])Stream.concat(Arrays.stream(pathExp, 0, pathExp.length - 1).map(AqlPath::parse), Stream.of(lastPath)).map(AqlPath::getNodes).flatMap(Collection::stream).toArray(AqlNode[]::new);
        if (nodesToAdd.length == 0) {
            if (Objects.equals(this.attributeName, newAttributeName)) {
                return this;
            }
            return new AqlPath(this.isEmpty, this.nodes, this.firstNode, newAttributeName);
        }
        int nodeCount = this.getNodeCount();
        AqlNode[] mergedNodes = new AqlNode[nodeCount + nodesToAdd.length];
        System.arraycopy(this.nodes, this.firstNode, mergedNodes, 0, nodeCount);
        System.arraycopy(nodesToAdd, 0, mergedNodes, nodeCount, nodesToAdd.length);
        return new AqlPath(false, mergedNodes, 0, newAttributeName);
    }

    public AqlPath removeEnd(AqlPath remove) {
        if (!StringUtils.equals((CharSequence)this.attributeName, (CharSequence)remove.attributeName)) {
            return this;
        }
        int remainingNodes = this.getNodeCount() - remove.getNodeCount();
        if (remainingNodes < 1) {
            return this;
        }
        for (int i = 0; i < remove.getNodeCount(); ++i) {
            if (this.getNode(remainingNodes + i).equals(remove.getNode(i))) continue;
            return this;
        }
        AqlNode[] subNodes = Arrays.copyOfRange(this.nodes, this.firstNode, this.firstNode + remainingNodes);
        return new AqlPath(false, subNodes, 0, null);
    }

    public AqlPath removeEnd(int nodeCount) {
        if (this.isEmpty || nodeCount == 0) {
            return this;
        }
        if (nodeCount == this.getNodeCount()) {
            return ROOT_PATH;
        }
        if (nodeCount < 1 || nodeCount > this.getNodeCount()) {
            throw new IllegalArgumentException();
        }
        AqlNode[] subNodes = Arrays.copyOfRange(this.nodes, this.firstNode, this.nodes.length - nodeCount);
        return new AqlPath(false, subNodes, 0, null);
    }

    public AqlPath replaceNode(int pos, AqlNode newNode) {
        AqlNode[] newNodes = Arrays.copyOfRange(this.nodes, this.firstNode, this.nodes.length);
        newNodes[pos] = newNode;
        return new AqlPath(this.isEmpty, newNodes, 0, this.attributeName);
    }

    public AqlPath replaceLastNode(UnaryOperator<AqlNode> op) {
        if (this.getNodeCount() == 0) {
            return this;
        }
        int pos = this.nodes.length - 1;
        AqlNode oldNode = this.nodes[pos];
        AqlNode newNode = (AqlNode)op.apply(oldNode);
        if (newNode == null) {
            return this.removeEnd(1);
        }
        if (oldNode.equals(newNode)) {
            return this;
        }
        return this.replaceNode(this.getNodeCount() - 1, newNode);
    }

    public String getPath() {
        return this.format(OtherPredicatesFormat.FULL, false);
    }

    public String format(boolean withOtherPredicates) {
        if (withOtherPredicates) {
            return this.format(OtherPredicatesFormat.FULL, true);
        }
        return this.format(OtherPredicatesFormat.NONE, true);
    }

    public AqlPath enableFormatCache() {
        if (this.formatCache == null) {
            this.formatCache = new String[2 * OtherPredicatesFormat.values().length];
        }
        return this;
    }

    public String format(OtherPredicatesFormat otherPredicatesFormat, boolean includeAttributeName) {
        if (this.formatCache == null) {
            return this.formatUncached(otherPredicatesFormat, includeAttributeName);
        }
        int idx = otherPredicatesFormat.ordinal() * (includeAttributeName ? 1 : 2);
        String value = this.formatCache[idx];
        if (value == null) {
            this.formatCache[idx] = value = this.formatUncached(otherPredicatesFormat, includeAttributeName);
        }
        return value;
    }

    private String formatUncached(OtherPredicatesFormat otherPredicatesFormat, boolean includeAttributeName) {
        StringBuilder sb = new StringBuilder();
        this.appendFormat(sb, otherPredicatesFormat, includeAttributeName);
        return sb.toString();
    }

    private void appendFormat(StringBuilder sb, OtherPredicatesFormat otherPredicatesFormat, boolean includeAttributeName) {
        if (!this.isEmpty) {
            if (this.getNodeCount() == 0) {
                sb.append('/');
            } else {
                for (int i = this.firstNode; i < this.nodes.length; ++i) {
                    sb.append('/');
                    AqlNode node = this.nodes[i];
                    node.appendFormat(sb, otherPredicatesFormat);
                }
            }
        }
        if (includeAttributeName && this.attributeName != null) {
            sb.append("|").append(this.attributeName);
        }
    }

    public static AqlPath parse(String pathExp) {
        return AqlPath.parse(pathExp, null);
    }

    public static AqlPath parse(String pathExp, String nameValue) {
        boolean isAttributeOnly;
        if (StringUtils.isBlank((CharSequence)pathExp)) {
            return EMPTY_PATH;
        }
        String attributeName = null;
        List<CharSequence> nodeStrings = AqlPathHelper.split(pathExp, pathExp.startsWith("/") ? 1 : 0, -1, false, PATH_SEPARATOR);
        int nodeCount = nodeStrings.size();
        AqlNode[] nodes = new AqlNode[nodeCount];
        int nodePos = 0;
        for (int i = 0; i < nodeCount; ++i) {
            Optional<AqlNode> aqlNode;
            boolean isLastNode;
            CharSequence currentNode = nodeStrings.get(i);
            boolean bl = isLastNode = nodeCount == i + 1;
            if (isLastNode) {
                List<CharSequence> attributeSplit = AqlPathHelper.split(currentNode, 0, 2, false, ATTRIBUTE_SEPARATOR);
                if (attributeSplit.size() == 2) {
                    attributeName = attributeSplit.get(1).toString();
                }
                currentNode = attributeSplit.get(0);
            }
            if (!(aqlNode = AqlPath.parseNode(currentNode, isLastNode, nameValue)).isPresent()) continue;
            nodes[nodePos++] = aqlNode.get();
        }
        boolean bl = isAttributeOnly = attributeName != null && pathExp.startsWith("|");
        if (nodePos != nodes.length) {
            nodes = Arrays.copyOf(nodes, nodePos);
        }
        return new AqlPath(isAttributeOnly, nodes, 0, attributeName);
    }

    private static Optional<AqlNode> parseNode(CharSequence currentNode, boolean isLastNode, String nameValue) {
        String atCode;
        PredicateLogicalAndOperation otherPredicates;
        CharSequence predicatesExp;
        String nodeName;
        if (StringUtils.endsWith((CharSequence)currentNode, (CharSequence)"]")) {
            int fist = StringUtils.indexOf((CharSequence)currentNode, (int)91);
            nodeName = CharSequenceHelper.subSequence(currentNode, 0, fist).toString();
            predicatesExp = CharSequenceHelper.subSequence(currentNode, fist + 1, currentNode.length() - 1);
        } else {
            nodeName = currentNode.toString();
            predicatesExp = null;
        }
        if (StringUtils.isEmpty((CharSequence)nodeName)) {
            return Optional.empty();
        }
        if (predicatesExp != null) {
            PredicateDto predicateDto = PredicateHelper.buildPredicate(predicatesExp);
            if (predicateDto instanceof PredicateLogicalOrOperation) {
                throw new SdkException("Or in predicate not supported");
            }
            otherPredicates = predicateDto instanceof PredicateLogicalAndOperation ? (PredicateLogicalAndOperation)predicateDto : new PredicateLogicalAndOperation((SimplePredicateDto)predicateDto);
            atCode = PredicateHelper.find(otherPredicates, "archetype_node_id").map(PredicateComparisonOperatorDto::getValue).map(SimpleValue.class::cast).map(SimpleValue::getValue).map(Object::toString).orElse(null);
        } else {
            atCode = null;
            otherPredicates = new PredicateLogicalAndOperation();
        }
        AqlNode node = new AqlNode(nodeName, atCode, otherPredicates);
        if (nameValue != null && isLastNode) {
            node = node.withNameValue(nameValue);
        }
        return Optional.of(node);
    }

    public boolean equals(Object o) {
        return this.equals(o, true);
    }

    public boolean equals(Object o, boolean withOtherPredicates) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AqlPath aqlPath = (AqlPath)o;
        if (this.hashCode != aqlPath.hashCode && withOtherPredicates) {
            return false;
        }
        if (this.isEmpty != aqlPath.isEmpty) {
            return false;
        }
        int nodeCount = this.getNodeCount();
        if (nodeCount != aqlPath.getNodeCount()) {
            return false;
        }
        for (int i = 0; i < nodeCount; ++i) {
            if (this.getNode(i).equals(aqlPath.getNode(i), withOtherPredicates)) continue;
            return false;
        }
        return true;
    }

    private int calcHash() {
        int result = 31 * Objects.hashCode(this.attributeName) + Boolean.hashCode(this.isEmpty);
        int c = this.nodes.length;
        for (int i = this.firstNode; i < c; ++i) {
            result = 31 * result + this.nodes[i].hashCode;
        }
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.format(true);
    }

    public static final class AqlNode
    implements Serializable {
        private final String name;
        private final String atCode;
        private final PredicateLogicalAndOperation otherPredicate;
        private final int hashCode;

        public AqlNode(String name, String atCode, PredicateLogicalAndOperation otherPredicates) {
            this.name = name;
            this.atCode = StringUtils.isBlank((CharSequence)atCode) ? null : atCode;
            this.otherPredicate = otherPredicates;
            this.hashCode = this.calcHash();
        }

        public String getName() {
            return this.name;
        }

        public String getAtCode() {
            return this.atCode;
        }

        public AqlNode withAtCode(String atCode) {
            return this.withStatement("archetype_node_id", atCode);
        }

        private static PredicateComparisonOperatorDto replaceValue(PredicateComparisonOperatorDto cmpOp, String statement, String newValue) {
            Value v;
            if (cmpOp.getSymbol() == ConditionComparisonOperatorSymbol.EQ && cmpOp.getStatement().equals(statement) && (v = cmpOp.getValue()) instanceof SimpleValue) {
                Object oldValue = ((SimpleValue)v).getValue();
                if (Objects.equals(newValue, oldValue)) {
                    return cmpOp;
                }
                return new PredicateComparisonOperatorDto(statement, ConditionComparisonOperatorSymbol.EQ, new SimpleValue(newValue));
            }
            return null;
        }

        private static <P extends SimplePredicateDto> P replaceInternal(P predicate, String statement, String newValue) {
            if (predicate instanceof PredicateComparisonOperatorDto) {
                return (P)AqlNode.replaceValue((PredicateComparisonOperatorDto)predicate, statement, newValue);
            }
            if (predicate instanceof PredicateLogicalAndOperation) {
                for (SimplePredicateDto child : ((PredicateLogicalAndOperation)predicate).getValues()) {
                    SimplePredicateDto newChild = AqlNode.replaceInternal(child, statement, newValue);
                    if (newChild == child) {
                        return predicate;
                    }
                    if (newChild == null) continue;
                    SimplePredicateDto[] newValues = (SimplePredicateDto[])((PredicateLogicalAndOperation)predicate).getValues().stream().map(p -> p == child ? newChild : p).toArray(SimplePredicateDto[]::new);
                    return (P)new PredicateLogicalAndOperation(newValues);
                }
            }
            return null;
        }

        private PredicateLogicalAndOperation replace(String statement, String newValue) {
            PredicateLogicalAndOperation newPredicateDto = AqlNode.replaceInternal(this.otherPredicate, statement, newValue);
            if (newPredicateDto == null) {
                SimplePredicateDto[] newValues = (SimplePredicateDto[])Stream.concat(this.otherPredicate.getValues().stream(), Stream.of(new PredicateComparisonOperatorDto(statement, ConditionComparisonOperatorSymbol.EQ, new SimpleValue(newValue)))).toArray(SimplePredicateDto[]::new);
                return new PredicateLogicalAndOperation(newValues);
            }
            return newPredicateDto;
        }

        public AqlNode withNameValue(String nameValue) {
            return this.withStatement(AqlPath.NAME_VALUE_KEY, nameValue);
        }

        private AqlNode withStatement(String statement, String value) {
            PredicateLogicalAndOperation newOtherPredicate = value == null ? PredicateHelper.remove(this.otherPredicate, ConditionComparisonOperatorSymbol.EQ, statement) : this.replace(statement, value);
            if (newOtherPredicate == this.otherPredicate) {
                return this;
            }
            String newAtCode = "archetype_node_id".equals(statement) ? value : this.atCode;
            return new AqlNode(this.name, newAtCode, newOtherPredicate);
        }

        public PredicateLogicalAndOperation getOtherPredicate() {
            return this.otherPredicate;
        }

        public String findOtherPredicate(String name) {
            return PredicateHelper.find(this.otherPredicate, name).map(PredicateComparisonOperatorDto::getValue).filter(SimpleValue.class::isInstance).map(SimpleValue.class::cast).map(SimpleValue::getValue).map(Object::toString).orElse(null);
        }

        public AqlNode clearOtherPredicates() {
            PredicateLogicalAndOperation otherPredicates = this.atCode == null ? new PredicateLogicalAndOperation() : new PredicateLogicalAndOperation(new PredicateComparisonOperatorDto("archetype_node_id", ConditionComparisonOperatorSymbol.EQ, new SimpleValue(this.atCode)));
            return new AqlNode(this.name, this.atCode, otherPredicates);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AqlNode aqlNode = (AqlNode)o;
            if (this.hashCode != aqlNode.hashCode) {
                return false;
            }
            return Objects.equals(this.name, aqlNode.name) && Objects.equals(this.atCode, aqlNode.atCode) && Objects.equals(this.otherPredicate, aqlNode.otherPredicate);
        }

        public boolean equals(AqlNode o, boolean withOtherPredicates) {
            if (withOtherPredicates) {
                return this.equals(o);
            }
            if (this == o) {
                return true;
            }
            return Objects.equals(this.name, o.name) && Objects.equals(this.atCode, o.atCode);
        }

        private int calcHash() {
            return Objects.hash(this.name, this.atCode, this.otherPredicate);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public void appendFormat(StringBuilder sb, OtherPredicatesFormat otherPredicatesFormat) {
            sb.append(this.name);
            if (!this.otherPredicate.getValues().isEmpty()) {
                sb.append("[");
                PredicateHelper.format(sb, this.otherPredicate, otherPredicatesFormat);
                sb.append("]");
            }
        }
    }

    public static enum OtherPredicatesFormat {
        NONE,
        SHORTED,
        FULL;

    }
}

