/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.parser;

import com.nedap.archie.datetime.DateTimeParsers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.aql.dto.AqlDto;
import org.ehrbase.aql.dto.EhrDto;
import org.ehrbase.aql.dto.LogicalOperatorSymbol;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorDto;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorSymbol;
import org.ehrbase.aql.dto.condition.ConditionDto;
import org.ehrbase.aql.dto.condition.ConditionLogicalOperatorDto;
import org.ehrbase.aql.dto.condition.ConditionLogicalOperatorSymbol;
import org.ehrbase.aql.dto.condition.ExistsConditionOperatorDto;
import org.ehrbase.aql.dto.condition.LikeOperatorDto;
import org.ehrbase.aql.dto.condition.LogicalOperatorDto;
import org.ehrbase.aql.dto.condition.MatchesOperatorDto;
import org.ehrbase.aql.dto.condition.NotConditionOperatorDto;
import org.ehrbase.aql.dto.condition.ParameterValue;
import org.ehrbase.aql.dto.condition.SimpleValue;
import org.ehrbase.aql.dto.condition.Value;
import org.ehrbase.aql.dto.containment.ContainmentDto;
import org.ehrbase.aql.dto.containment.ContainmentExpresionDto;
import org.ehrbase.aql.dto.containment.ContainmentLogicalOperator;
import org.ehrbase.aql.dto.containment.ContainmentLogicalOperatorSymbol;
import org.ehrbase.aql.dto.orderby.OrderByExpressionDto;
import org.ehrbase.aql.dto.orderby.OrderByExpressionSymbol;
import org.ehrbase.aql.dto.path.AqlPath;
import org.ehrbase.aql.dto.path.predicate.PredicateComparisonOperatorDto;
import org.ehrbase.aql.dto.path.predicate.PredicateDto;
import org.ehrbase.aql.dto.path.predicate.PredicateHelper;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalAndOperation;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalOrOperation;
import org.ehrbase.aql.dto.select.AQLFunction;
import org.ehrbase.aql.dto.select.FunctionDto;
import org.ehrbase.aql.dto.select.SelectDto;
import org.ehrbase.aql.dto.select.SelectFieldDto;
import org.ehrbase.aql.dto.select.SelectStatementDto;
import org.ehrbase.aql.parser.AqlBaseVisitor;
import org.ehrbase.aql.parser.AqlParseException;
import org.ehrbase.aql.parser.AqlParser;
import org.ehrbase.client.aql.top.Direction;

public class AqlToDtoVisitor
extends AqlBaseVisitor<Object> {
    private int containmentId = 0;
    private final Map<String, Integer> identifierMap = new HashMap<String, Integer>();
    private final MultiValuedMap<String, SelectFieldDto> selectFieldDtoMultiMap = new ArrayListValuedHashMap();

    @Override
    public AqlDto visitQuery(AqlParser.QueryContext ctx) {
        AqlDto aqlDto = new AqlDto();
        Pair<EhrDto, ConditionDto> visitFromEHR = this.visitFromEHR(ctx.queryExpr().from().fromEHR());
        aqlDto.setEhr((EhrDto)visitFromEHR.getLeft());
        if (ctx.queryExpr().from().containsExpression() != null) {
            aqlDto.setContains(this.visitContainsExpression(ctx.queryExpr().from().containsExpression()));
        }
        aqlDto.setSelect(this.visitSelect(ctx.queryExpr().select()));
        if (ctx.queryExpr().where() != null) {
            aqlDto.setWhere(this.visitIdentifiedExpr(ctx.queryExpr().where().identifiedExpr()));
        }
        if (visitFromEHR.getRight() != null) {
            if (aqlDto.getWhere() == null) {
                aqlDto.setWhere((ConditionDto)visitFromEHR.getRight());
            } else {
                ConditionLogicalOperatorDto and = new ConditionLogicalOperatorDto();
                and.setSymbol(ConditionLogicalOperatorSymbol.AND);
                and.setValues(new ArrayList<ConditionDto>(List.of(aqlDto.getWhere(), (ConditionDto)visitFromEHR.getRight())));
                aqlDto.setWhere(and);
            }
        }
        if (ctx.queryExpr().orderBy() != null) {
            aqlDto.setOrderBy((List<OrderByExpressionDto>)this.visitOrderBySeq(ctx.queryExpr().orderBy().orderBySeq()));
        }
        if (ctx.queryExpr().limit() != null) {
            AqlParser.LimitContext limitExpr = ctx.queryExpr().limit();
            aqlDto.setLimit(Integer.parseInt(limitExpr.INTEGER().getText()));
            if (ctx.queryExpr().offset() != null) {
                aqlDto.setOffset(Integer.parseInt(ctx.queryExpr().offset().INTEGER().getText()));
            }
        }
        this.selectFieldDtoMultiMap.entries().forEach(e -> {
            if (this.identifierMap.containsKey(e.getKey())) {
                ((SelectFieldDto)e.getValue()).setContainmentId(this.identifierMap.get(e.getKey()));
            }
        });
        this.selectFieldDtoMultiMap.entries().stream().filter(e -> !this.identifierMap.containsKey(e.getKey())).forEach(e -> {
            SelectFieldDto selectFieldDto = this.selectFieldDtoMultiMap.values().stream().filter(d -> ((String)e.getKey()).equals(d.getName())).findAny().orElseThrow();
            SelectFieldDto value = (SelectFieldDto)e.getValue();
            value.setName(selectFieldDto.getName());
            value.setAqlPath(selectFieldDto.getAqlPathDto());
            value.setContainmentId(selectFieldDto.getContainmentId());
        });
        return aqlDto;
    }

    @Override
    public Pair<EhrDto, ConditionDto> visitFromEHR(AqlParser.FromEHRContext ctx) {
        EhrDto ehrDto = new EhrDto();
        ehrDto.setContainmentId(this.buildContainmentId());
        if (ctx.IDENTIFIER() != null) {
            this.identifierMap.put(ctx.IDENTIFIER().getText(), ehrDto.getContainmentId());
            ehrDto.setIdentifier(ctx.IDENTIFIER().getText());
        }
        return Pair.of((Object)ehrDto, (Object)Optional.ofNullable(ctx.standardPredicate()).map(AqlParser.StandardPredicateContext::predicateExpr).map(p -> this.buildConditionDtoFromPredicate((AqlParser.PredicateExprContext)((Object)p), ehrDto.getContainmentId())).orElse(null));
    }

    private ConditionDto buildConditionDtoFromPredicate(AqlParser.PredicateExprContext p, int containmentId) {
        PredicateDto predicateDto = PredicateHelper.buildPredicate(AqlToDtoVisitor.getFullText(p));
        return this.to(predicateDto, containmentId);
    }

    public static String getFullText(ParserRuleContext context) {
        if (context.start == null || context.stop == null || context.start.getStartIndex() < 0 || context.stop.getStopIndex() < 0) {
            return context.getText();
        }
        return context.start.getInputStream().getText(Interval.of((int)context.start.getStartIndex(), (int)context.stop.getStopIndex()));
    }

    private ConditionDto to(PredicateDto predicateDto, int containmentId) {
        if (predicateDto instanceof PredicateComparisonOperatorDto) {
            ConditionComparisonOperatorDto conditionComparisonOperatorDto = new ConditionComparisonOperatorDto();
            SelectFieldDto statement = new SelectFieldDto();
            statement.setContainmentId(containmentId);
            String aqlStr = ((PredicateComparisonOperatorDto)predicateDto).getStatement();
            if (StringUtils.isEmpty((CharSequence)aqlStr)) {
                statement.setAqlPath(AqlPath.ROOT_PATH);
            } else {
                statement.setAqlPath(AqlPath.parse(aqlStr));
            }
            conditionComparisonOperatorDto.setStatement(statement);
            conditionComparisonOperatorDto.setSymbol(((PredicateComparisonOperatorDto)predicateDto).getSymbol());
            conditionComparisonOperatorDto.setValue(((PredicateComparisonOperatorDto)predicateDto).getValue());
            return conditionComparisonOperatorDto;
        }
        if (predicateDto instanceof PredicateLogicalAndOperation) {
            ConditionLogicalOperatorDto and = new ConditionLogicalOperatorDto();
            and.setSymbol(ConditionLogicalOperatorSymbol.AND);
            and.setValues(((PredicateLogicalAndOperation)predicateDto).getValues().stream().map(p -> this.to((PredicateDto)p, containmentId)).collect(Collectors.toList()));
            return and;
        }
        if (predicateDto instanceof PredicateLogicalOrOperation) {
            ConditionLogicalOperatorDto or = new ConditionLogicalOperatorDto();
            or.setSymbol(ConditionLogicalOperatorSymbol.OR);
            or.setValues(((PredicateLogicalOrOperation)predicateDto).getValues().stream().map(p -> this.to((PredicateDto)p, containmentId)).collect(Collectors.toList()));
            return or;
        }
        return null;
    }

    @Override
    public SelectDto visitSelect(AqlParser.SelectContext ctx) {
        SelectDto selectDto = new SelectDto();
        selectDto.setStatement((List<SelectStatementDto>)this.visitSelectExpr(ctx.selectExpr()));
        if (ctx.topExpr() != null) {
            selectDto.setTopDirection(this.extractSymbol(ctx.topExpr()));
            selectDto.setTopCount(Integer.parseInt(ctx.topExpr().INTEGER().getText()));
        }
        if (ctx.selectExpr().DISTINCT() != null) {
            selectDto.setDistinct(true);
        }
        return selectDto;
    }

    private Direction extractSymbol(AqlParser.TopExprContext topExpr) {
        if (topExpr.BACKWARD() != null) {
            return Direction.BACKWARD;
        }
        return Direction.FORWARD;
    }

    @Override
    public List<SelectStatementDto> visitSelectExpr(AqlParser.SelectExprContext ctx) {
        ArrayList<SelectStatementDto> selectStatementDtos = new ArrayList<SelectStatementDto>();
        if (ctx.identifiedPath() != null) {
            SelectFieldDto selectFieldDto = this.visitIdentifiedPath(ctx.identifiedPath());
            if (ctx.IDENTIFIER() != null) {
                selectFieldDto.setName(ctx.IDENTIFIER().getText());
            }
            selectStatementDtos.add(selectFieldDto);
        } else if (ctx.stdExpression() != null && ctx.stdExpression().function() != null) {
            FunctionDto functionDto = this.visitFunction(ctx.stdExpression().function());
            selectStatementDtos.add(functionDto);
            if (ctx.IDENTIFIER() != null) {
                functionDto.setName(ctx.IDENTIFIER().getText());
            }
        }
        if (ctx.selectExpr() != null) {
            selectStatementDtos.addAll((Collection<SelectStatementDto>)this.visitSelectExpr(ctx.selectExpr()));
        }
        return selectStatementDtos;
    }

    @Override
    public FunctionDto visitFunction(AqlParser.FunctionContext ctx) {
        FunctionDto functionDto = new FunctionDto();
        AQLFunction aqlFunction = AQLFunction.valueOf(ctx.FUNCTION_IDENTIFIER().toString().toUpperCase(Locale.ROOT));
        functionDto.setAqlFunction(aqlFunction);
        if (ctx.identifiedPath() != null) {
            functionDto.setParameters(ctx.identifiedPath().stream().map(this::visitIdentifiedPath).collect(Collectors.toList()));
        }
        return functionDto;
    }

    @Override
    public SelectFieldDto visitIdentifiedPath(AqlParser.IdentifiedPathContext ctx) {
        SelectFieldDto selectStatementDto = new SelectFieldDto();
        this.selectFieldDtoMultiMap.put((Object)ctx.IDENTIFIER().getText(), (Object)selectStatementDto);
        selectStatementDto.setAqlPath(StringUtils.removeStart((String)AqlToDtoVisitor.getFullText(ctx), (String)ctx.IDENTIFIER().getText()));
        return selectStatementDto;
    }

    @Override
    public ContainmentExpresionDto visitContainsExpression(AqlParser.ContainsExpressionContext ctx) {
        ArrayList<Object> boolList = new ArrayList<Object>();
        for (AqlParser.ContainsExpressionContext currentContext = ctx; currentContext != null; currentContext = currentContext.containsExpression()) {
            ContainmentLogicalOperatorSymbol symbol = this.extractSymbol(currentContext);
            boolList.add(this.visitContainExpressionBool(currentContext.containExpressionBool()));
            if (symbol == null) continue;
            boolList.add(symbol);
        }
        if (boolList.size() == 1) {
            return (ContainmentExpresionDto)boolList.get(0);
        }
        return this.buildContainmentLogicalOperator(boolList);
    }

    public ContainmentLogicalOperator buildContainmentLogicalOperator(List<Object> boolList) {
        return (ContainmentLogicalOperator)AqlToDtoVisitor.buildLogicalOperator(boolList, (S s) -> {
            ContainmentLogicalOperator conditionLogicalOperatorDto = new ContainmentLogicalOperator();
            conditionLogicalOperatorDto.setSymbol((ContainmentLogicalOperatorSymbol)s);
            conditionLogicalOperatorDto.setValues(new ArrayList<ContainmentExpresionDto>());
            return conditionLogicalOperatorDto;
        });
    }

    @Override
    public ContainmentExpresionDto visitContainExpressionBool(AqlParser.ContainExpressionBoolContext ctx) {
        if (ctx.contains() != null) {
            return this.visitContains(ctx.contains());
        }
        return this.visitContainsExpression(ctx.containsExpression());
    }

    @Override
    public ContainmentDto visitContains(AqlParser.ContainsContext ctx) {
        ContainmentDto containmentDto = this.visitSimpleClassExpr(ctx.simpleClassExpr());
        if (ctx.containsExpression() != null) {
            containmentDto.setContains(this.visitContainsExpression(ctx.containsExpression()));
        }
        return containmentDto;
    }

    @Override
    public ContainmentDto visitSimpleClassExpr(AqlParser.SimpleClassExprContext ctx) {
        ContainmentDto currentContainment = new ContainmentDto();
        currentContainment.setId(this.buildContainmentId());
        AqlParser.ArchetypedClassExprContext archetypedClassExprContext = (AqlParser.ArchetypedClassExprContext)ctx.getChild(AqlParser.ArchetypedClassExprContext.class, 0);
        if (archetypedClassExprContext != null) {
            if (archetypedClassExprContext.IDENTIFIER().size() == 2) {
                currentContainment.setIdentifier(archetypedClassExprContext.IDENTIFIER(1).getText());
                this.identifierMap.put(currentContainment.getIdentifier(), currentContainment.getId());
            }
            currentContainment.getContainment().setType(archetypedClassExprContext.IDENTIFIER(0).getText());
            currentContainment.getContainment().setArchetypeId(archetypedClassExprContext.ARCHETYPEID().getText());
            currentContainment.getContainment().setOtherPredicates(new PredicateLogicalAndOperation(new PredicateComparisonOperatorDto("archetype_node_id", ConditionComparisonOperatorSymbol.EQ, new SimpleValue(currentContainment.getContainment().getArchetypeId()))));
        } else {
            currentContainment.getContainment().setType(ctx.IDENTIFIER(0).getText());
            currentContainment.getContainment().setArchetypeId(ctx.IDENTIFIER(0).getText());
            if (ctx.IDENTIFIER().size() == 2) {
                currentContainment.setIdentifier(ctx.IDENTIFIER(1).getText());
                this.identifierMap.put(currentContainment.getIdentifier(), currentContainment.getId());
            }
        }
        return currentContainment;
    }

    @Override
    public ConditionDto visitIdentifiedExpr(AqlParser.IdentifiedExprContext ctx) {
        int childCount = ctx.getChildCount();
        ArrayList<Object> boolList = new ArrayList<Object>(childCount);
        for (int i = 0; i < childCount; ++i) {
            ConditionLogicalOperatorSymbol symbol;
            ParseTree child = ctx.getChild(i);
            if (child instanceof AqlParser.IdentifiedEqualityContext) {
                boolList.add(this.visitIdentifiedEquality((AqlParser.IdentifiedEqualityContext)child));
                continue;
            }
            if (!(child instanceof TerminalNode) || (symbol = this.extractSymbolTerminal((TerminalNode)child)) == null) continue;
            boolList.add(symbol);
        }
        if (boolList.size() == 1) {
            return (ConditionDto)boolList.get(0);
        }
        return this.buildConditionLogicalOperator(boolList);
    }

    private ConditionLogicalOperatorDto buildConditionLogicalOperator(List<Object> boolList) {
        return (ConditionLogicalOperatorDto)AqlToDtoVisitor.buildLogicalOperator(boolList, (S s) -> {
            ConditionLogicalOperatorDto conditionLogicalOperatorDto = new ConditionLogicalOperatorDto();
            conditionLogicalOperatorDto.setSymbol((ConditionLogicalOperatorSymbol)s);
            conditionLogicalOperatorDto.setValues(new ArrayList<ConditionDto>());
            return conditionLogicalOperatorDto;
        });
    }

    private static <T, S extends LogicalOperatorSymbol> LogicalOperatorDto<S, T> buildLogicalOperator(OperatorStructure<S> structure, Function<S, LogicalOperatorDto<S, T>> creator) {
        LogicalOperatorDto<S, Object> operator = creator.apply(structure.getSymbol());
        Stream<Object> stream = structure.getChildren().stream().map(v -> {
            if (v instanceof OperatorStructure) {
                return AqlToDtoVisitor.buildLogicalOperator((OperatorStructure)v, creator);
            }
            return v;
        });
        return operator.addValues(stream);
    }

    public static <S extends LogicalOperatorSymbol, T> LogicalOperatorDto<S, T> buildLogicalOperator(List<Object> boolList, Function<S, LogicalOperatorDto<S, T>> creator) {
        OperatorStructure<S> structure = AqlToDtoVisitor.buildLogicalOperatorStructure(boolList);
        return AqlToDtoVisitor.buildLogicalOperator(structure, creator);
    }

    private static <S extends LogicalOperatorSymbol> OperatorStructure<S> buildLogicalOperatorStructure(List<Object> boolList) {
        OperatorStructure<LogicalOperatorSymbol> currentOperator;
        LogicalOperatorSymbol currentSymbol = (LogicalOperatorSymbol)boolList.get(1);
        OperatorStructure<LogicalOperatorSymbol> lowestOperator = currentOperator = new OperatorStructure<LogicalOperatorSymbol>(currentSymbol, boolList.get(0));
        int l = boolList.size();
        for (int i = 2; i < l; i += 2) {
            LogicalOperatorSymbol nextSymbol = i + 1 < l ? (LogicalOperatorSymbol)boolList.get(i + 1) : null;
            Object currentOpValue = boolList.get(i);
            if (nextSymbol == null || Objects.equals(currentSymbol, nextSymbol)) {
                currentOperator.addChild(currentOpValue);
            } else {
                OperatorStructure<LogicalOperatorSymbol> nextOperator = new OperatorStructure<LogicalOperatorSymbol>(nextSymbol, new Object[0]);
                if (AqlToDtoVisitor.hasHigherPrecedence(currentSymbol, nextSymbol)) {
                    currentOperator.addChild(currentOpValue);
                    nextOperator.addChild(currentOperator);
                    lowestOperator = nextOperator;
                } else {
                    nextOperator.addChild(currentOpValue);
                    currentOperator.addChild(nextOperator);
                    lowestOperator = currentOperator;
                }
                currentOperator = nextOperator;
            }
            currentSymbol = nextSymbol;
        }
        return lowestOperator;
    }

    private ConditionLogicalOperatorSymbol extractSymbolTerminal(TerminalNode child) {
        if (child == null) {
            return null;
        }
        switch (child.getSymbol().getText().toLowerCase(Locale.ROOT)) {
            case "or": {
                return ConditionLogicalOperatorSymbol.OR;
            }
            case "and": {
                return ConditionLogicalOperatorSymbol.AND;
            }
            case "xor": {
                throw new AqlParseException("XOR not supported");
            }
        }
        return null;
    }

    @Override
    public ConditionDto visitIdentifiedEquality(AqlParser.IdentifiedEqualityContext ctx) {
        ConditionDto conditionDto = null;
        if (ctx.identifiedExpr() != null) {
            conditionDto = this.visitIdentifiedExpr(ctx.identifiedExpr());
        } else if (ctx.IS() != null) {
            ConditionComparisonOperatorDto operatorDto = new ConditionComparisonOperatorDto();
            operatorDto.setSymbol(ctx.NOT() == null ? ConditionComparisonOperatorSymbol.EQ : ConditionComparisonOperatorSymbol.NEQ);
            operatorDto.setStatement(this.visitIdentifiedPath(ctx.identifiedOperand(0).identifiedPath()));
            if (ctx.TRUE() != null) {
                operatorDto.setValue(new SimpleValue(true));
            } else if (ctx.FALSE() != null) {
                operatorDto.setValue(new SimpleValue(false));
            } else {
                throw new AqlParseException("Not supported, only IS (NOT) TRUE/FALSE is supported");
            }
            conditionDto = operatorDto;
        } else if (ctx.COMPARABLEOPERATOR() != null) {
            ConditionComparisonOperatorSymbol comparisonOperatorSymbol = this.extractSymbol(ctx);
            ConditionComparisonOperatorDto operatorDto = new ConditionComparisonOperatorDto();
            operatorDto.setSymbol(comparisonOperatorSymbol);
            operatorDto.setStatement(this.visitIdentifiedPath(ctx.identifiedOperand(0).identifiedPath()));
            operatorDto.setValue(this.visitOperand(ctx.identifiedOperand(1).operand()));
            conditionDto = operatorDto;
        } else if (ctx.MATCHES() != null) {
            MatchesOperatorDto matchesOperatorDto = new MatchesOperatorDto();
            matchesOperatorDto.setStatement(this.visitIdentifiedPath(ctx.identifiedOperand(0).identifiedPath()));
            matchesOperatorDto.setValues(new ArrayList<Value>());
            for (AqlParser.ValueListItemsContext valueListItemsContext = ctx.matchesOperand().valueListItems(); valueListItemsContext != null; valueListItemsContext = valueListItemsContext.valueListItems()) {
                matchesOperatorDto.getValues().add(this.visitOperand(valueListItemsContext.operand()));
            }
            conditionDto = matchesOperatorDto;
        } else if (ctx.EXISTS() != null) {
            conditionDto = new ExistsConditionOperatorDto(this.visitIdentifiedPath(ctx.identifiedPath()));
        } else if (ctx.LIKE() != null) {
            LikeOperatorDto likeOperatorDto = new LikeOperatorDto();
            likeOperatorDto.setStatement(this.visitIdentifiedPath(ctx.identifiedOperand(0).identifiedPath()));
            likeOperatorDto.setValue(this.visitLikeOperand(ctx.likeOperand()));
            conditionDto = likeOperatorDto;
        }
        if (ctx.NOT() != null && ctx.IS() == null && ctx.IN() == null && ctx.BETWEEN() == null) {
            return new NotConditionOperatorDto(conditionDto);
        }
        return conditionDto;
    }

    @Override
    public Value visitOperand(AqlParser.OperandContext ctx) {
        Value value;
        if (this.isBooleanOperand(ctx)) {
            value = new SimpleValue(Boolean.parseBoolean(ctx.getText()));
        } else if (ctx.DATE() != null) {
            String unwrap = AqlToDtoVisitor.unwrapText((RuleContext)ctx);
            value = new SimpleValue(DateTimeParsers.parseTimeValue((String)unwrap));
        } else if (ctx.FLOAT() != null) {
            value = new SimpleValue(Double.valueOf(ctx.getText()));
        } else if (ctx.INTEGER() != null) {
            value = new SimpleValue(Integer.valueOf(ctx.getText()));
        } else if (ctx.STRING() != null) {
            value = new SimpleValue(AqlToDtoVisitor.unwrapText((RuleContext)ctx));
        } else if (ctx.PARAMETER() != null) {
            value = AqlToDtoVisitor.parameter((RuleContext)ctx);
        } else {
            throw new AqlParseException("Can not handle value " + ctx.getText());
        }
        return value;
    }

    @Override
    public Value visitLikeOperand(AqlParser.LikeOperandContext ctx) {
        Value value;
        if (ctx.STRING() != null) {
            value = new SimpleValue(AqlToDtoVisitor.unwrapText((RuleContext)ctx));
        } else if (ctx.PARAMETER() != null) {
            value = AqlToDtoVisitor.parameter((RuleContext)ctx);
        } else {
            throw new AqlParseException("Can not handle value " + ctx.getText());
        }
        return value;
    }

    private static String unwrapText(RuleContext ctx) {
        return StringUtils.unwrap((String)StringUtils.unwrap((String)ctx.getText(), (String)"'"), (String)"\"");
    }

    private static ParameterValue parameter(RuleContext ctx) {
        return new ParameterValue(StringUtils.removeStart((String)ctx.getText(), (String)"$"), "?");
    }

    @Override
    public List<OrderByExpressionDto> visitOrderBySeq(AqlParser.OrderBySeqContext ctx) {
        ArrayList<OrderByExpressionDto> orderByExpressionDtoList = new ArrayList<OrderByExpressionDto>();
        orderByExpressionDtoList.add(this.visitOrderByExpr(ctx.orderByExpr()));
        if (ctx.orderBySeq() != null) {
            orderByExpressionDtoList.addAll((Collection<OrderByExpressionDto>)this.visitOrderBySeq(ctx.orderBySeq()));
        }
        return orderByExpressionDtoList;
    }

    @Override
    public OrderByExpressionDto visitOrderByExpr(AqlParser.OrderByExprContext ctx) {
        OrderByExpressionDto orderByExpressionDto = new OrderByExpressionDto();
        orderByExpressionDto.setStatement(this.visitIdentifiedPath(ctx.identifiedPath()));
        orderByExpressionDto.setSymbol(this.extractSymbol(ctx));
        return orderByExpressionDto;
    }

    private OrderByExpressionSymbol extractSymbol(AqlParser.OrderByExprContext ctx) {
        if (ctx.DESC() != null || ctx.DESCENDING() != null) {
            return OrderByExpressionSymbol.DESC;
        }
        return OrderByExpressionSymbol.ASC;
    }

    private ConditionComparisonOperatorSymbol extractSymbol(AqlParser.IdentifiedEqualityContext ctx) {
        switch (ctx.COMPARABLEOPERATOR().getText()) {
            case "=": {
                return ConditionComparisonOperatorSymbol.EQ;
            }
            case "!=": {
                return ConditionComparisonOperatorSymbol.NEQ;
            }
            case ">": {
                return ConditionComparisonOperatorSymbol.GT;
            }
            case ">=": {
                return ConditionComparisonOperatorSymbol.GT_EQ;
            }
            case "<": {
                return ConditionComparisonOperatorSymbol.LT;
            }
            case "<=": {
                return ConditionComparisonOperatorSymbol.LT_EQ;
            }
        }
        throw new AqlParseException("Unknown Token " + ctx.COMPARABLEOPERATOR().getText());
    }

    private static boolean hasHigherPrecedence(LogicalOperatorSymbol operatorSymbol, LogicalOperatorSymbol nextOperatorSymbol) {
        if (nextOperatorSymbol == null) {
            return true;
        }
        return operatorSymbol.getPrecedence() <= nextOperatorSymbol.getPrecedence();
    }

    private int buildContainmentId() {
        return this.containmentId++;
    }

    private ContainmentLogicalOperatorSymbol extractSymbol(AqlParser.ContainsExpressionContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.OR() != null) {
            return ContainmentLogicalOperatorSymbol.OR;
        }
        if (ctx.AND() != null) {
            return ContainmentLogicalOperatorSymbol.AND;
        }
        if (ctx.XOR() != null) {
            throw new AqlParseException("XOR not supported");
        }
        return null;
    }

    private boolean isBooleanOperand(AqlParser.OperandContext ctx) {
        return ctx.BOOLEAN() != null || ctx.TRUE() != null || ctx.FALSE() != null;
    }

    private static final class OperatorStructure<S extends LogicalOperatorSymbol> {
        private final S symbol;
        private final List<Object> children;

        private OperatorStructure(S symbol, Object ... children) {
            this.symbol = symbol;
            this.children = Arrays.stream(children).collect(Collectors.toList());
        }

        public S getSymbol() {
            return this.symbol;
        }

        public List<Object> getChildren() {
            return this.children;
        }

        public void addChild(Object child) {
            this.children.add(child);
        }
    }
}

