/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.aql.parameter;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class StoredQueryParameter {
    private final String qualifiedQueryName;
    private final String version;
    private Integer offset;
    private Integer fetch;
    private String type;
    private final Map<String, String> parameterMap = new HashMap<String, String>();

    public StoredQueryParameter(String qualifiedQueryName, String version) {
        this.qualifiedQueryName = qualifiedQueryName;
        this.version = version;
    }

    public StoredQueryParameter offset(int value) {
        this.offset = value;
        return this;
    }

    public StoredQueryParameter fetch(int value) {
        this.fetch = value;
        return this;
    }

    public StoredQueryParameter type(String value) {
        this.type = value;
        return this;
    }

    public StoredQueryParameter addQueryParam(String parameterName, String value) {
        this.parameterMap.put(parameterName, value);
        return this;
    }

    public Optional<Integer> getOffset() {
        return Optional.ofNullable(this.offset);
    }

    public Optional<Integer> getFetch() {
        return Optional.ofNullable(this.fetch);
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public boolean isValid() {
        return !StringUtils.isEmpty((CharSequence)this.qualifiedQueryName) && !StringUtils.isEmpty((CharSequence)this.version);
    }

    public String getPath() {
        return this.qualifiedQueryName + "/" + this.version;
    }

    public Map<String, String> getQueryParams() {
        return this.parameterMap;
    }
}

