/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.aql.condition;

import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorSymbol;
import org.ehrbase.client.aql.condition.And;
import org.ehrbase.client.aql.condition.ComparisonOperator;
import org.ehrbase.client.aql.condition.Exists;
import org.ehrbase.client.aql.condition.Matches;
import org.ehrbase.client.aql.condition.Not;
import org.ehrbase.client.aql.condition.Or;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.field.SelectAqlField;
import org.ehrbase.client.aql.parameter.Parameter;

public interface Condition {
    default public Condition and(Condition condition) {
        return Condition.and(this, condition);
    }

    default public Condition or(Condition condition) {
        return Condition.or(this, condition);
    }

    default public Condition not() {
        return Condition.not(this);
    }

    public static <T> Condition equal(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ConditionComparisonOperatorSymbol.EQ.getSymbol(), value);
    }

    public static <T> Condition equal(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ConditionComparisonOperatorSymbol.EQ.getSymbol(), parameter);
    }

    public static <T> Condition equal(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ConditionComparisonOperatorSymbol.EQ.getSymbol(), compareField);
    }

    public static <T> Condition notEqual(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ConditionComparisonOperatorSymbol.NEQ.getSymbol(), value);
    }

    public static <T> Condition notEqual(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ConditionComparisonOperatorSymbol.NEQ.getSymbol(), parameter);
    }

    public static <T> Condition notEqual(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ConditionComparisonOperatorSymbol.NEQ.getSymbol(), compareField);
    }

    public static <T> Condition greaterOrEqual(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ConditionComparisonOperatorSymbol.GT_EQ.getSymbol(), value);
    }

    public static <T> Condition greaterOrEqual(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ConditionComparisonOperatorSymbol.GT_EQ.getSymbol(), parameter);
    }

    public static <T> Condition greaterOrEqual(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ConditionComparisonOperatorSymbol.GT_EQ.getSymbol(), compareField);
    }

    public static <T> Condition greaterThan(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ConditionComparisonOperatorSymbol.GT.getSymbol(), value);
    }

    public static <T> Condition greaterThan(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ConditionComparisonOperatorSymbol.GT.getSymbol(), parameter);
    }

    public static <T> Condition greaterThan(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ConditionComparisonOperatorSymbol.GT.getSymbol(), compareField);
    }

    public static <T> Condition lessOrEqual(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ConditionComparisonOperatorSymbol.LT_EQ.getSymbol(), value);
    }

    public static <T> Condition lessOrEqual(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ConditionComparisonOperatorSymbol.LT_EQ.getSymbol(), parameter);
    }

    public static <T> Condition lessOrEqual(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ConditionComparisonOperatorSymbol.LT_EQ.getSymbol(), compareField);
    }

    public static <T> Condition lessThan(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, ConditionComparisonOperatorSymbol.LT.getSymbol(), value);
    }

    public static <T> Condition lessThCan(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, ConditionComparisonOperatorSymbol.LT.getSymbol(), parameter);
    }

    public static <T> Condition lessThan(SelectAqlField<T> field, SelectAqlField<T> compareField) {
        return ComparisonOperator.fieldComparison(field, ConditionComparisonOperatorSymbol.LT.getSymbol(), compareField);
    }

    public static <T> Condition matches(SelectAqlField<T> field, T ... value) {
        return new Matches<T>(field, value);
    }

    @SafeVarargs
    public static <T> Condition matches(SelectAqlField<T> field, Parameter<T> ... parameter) {
        return new Matches<T>(field, parameter);
    }

    public static Condition and(Condition condition1, Condition condition2) {
        return new And(condition1, condition2);
    }

    public static Condition or(Condition condition1, Condition condition2) {
        return new Or(condition1, condition2);
    }

    public static Condition not(Condition condition) {
        return new Not(condition);
    }

    public static Condition exists(SelectAqlField<?> field) {
        return new Exists(field);
    }

    public static <T> Condition like(SelectAqlField<T> field, T value) {
        return ComparisonOperator.valueComparison(field, "like", value);
    }

    public static <T> Condition like(SelectAqlField<T> field, Parameter<T> parameter) {
        return ComparisonOperator.parameterComparison(field, "like", parameter);
    }

    public String buildAql(Containment var1);
}

