/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.dto.path.predicate;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorSymbol;
import org.ehrbase.aql.dto.condition.LogicalOperatorDto;
import org.ehrbase.aql.dto.condition.ParameterValue;
import org.ehrbase.aql.dto.condition.SimpleValue;
import org.ehrbase.aql.dto.condition.Value;
import org.ehrbase.aql.dto.path.AqlPath;
import org.ehrbase.aql.dto.path.AqlPathHelper;
import org.ehrbase.aql.dto.path.predicate.PredicateComparisonOperatorDto;
import org.ehrbase.aql.dto.path.predicate.PredicateDto;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalAndOperation;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalOperatorSymbol;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalOrOperation;
import org.ehrbase.aql.dto.path.predicate.SimplePredicateDto;
import org.ehrbase.aql.parser.AqlToDtoVisitor;
import org.ehrbase.aql.util.CharSequenceHelper;
import org.ehrbase.util.exception.SdkException;

public class PredicateHelper {
    public static final String NAME_VALUE = "name/value";
    public static final String ARCHETYPE_NODE_ID = "archetype_node_id";
    private static final AqlPathHelper.PrefixMatcher OPERATOR_SYMBOLS = AqlPathHelper.PrefixMatcher.forStrings((String[])Arrays.stream(ConditionComparisonOperatorSymbol.values()).map(ConditionComparisonOperatorSymbol::getSymbol).toArray(String[]::new));
    private static final PredicateComparisonOperatorDto NO_PREDICATE = new PredicateComparisonOperatorDto(null, null, null);
    private static final AqlPathHelper.PrefixMatcher PREDICATES_MATCHER = AqlPathHelper.PrefixMatcher.forStrings(" and ", " AND ", " or ", " OR ", ",");
    static final Comparator<PredicateDto> PREDICATE_DTO_COMPARATOR = Comparator.comparingInt(PredicateHelper::comparisonKey);

    private static int comparisonKey(PredicateDto dto) {
        if (dto instanceof PredicateComparisonOperatorDto) {
            switch (((PredicateComparisonOperatorDto)dto).getStatement()) {
                case "archetype_node_id": {
                    return 1;
                }
                case "name/value": {
                    return 2;
                }
            }
            return 3;
        }
        return 9;
    }

    private PredicateHelper() {
    }

    public static PredicateDto buildPredicate(CharSequence predicate) {
        Object[] boolList = PredicateHelper.parsePredicate(predicate);
        if (boolList.length == 1) {
            return (PredicateDto)boolList[0];
        }
        LogicalOperatorDto predicateLogicalOperatorSymbolPredicateDtoLogicalOperatorDto = AqlToDtoVisitor.buildLogicalOperator(Arrays.asList(boolList), s -> {
            if (PredicateLogicalOperatorSymbol.AND.equals(s)) {
                return new PredicateLogicalAndOperation();
            }
            return new PredicateLogicalOrOperation();
        });
        return (PredicateDto)((Object)predicateLogicalOperatorSymbolPredicateDtoLogicalOperatorDto);
    }

    static Object[] parsePredicate(CharSequence predicate) {
        List<CharSequence> split = AqlPathHelper.split(predicate, 0, -1, true, PREDICATES_MATCHER);
        Object[] ret = new Object[split.size()];
        int l = split.size();
        for (int i = 0; i < l; ++i) {
            ret[i] = i % 2 == 0 ? PredicateHelper.handleOperator(split.get(i), i) : PredicateHelper.handleSymbol(split.get(i));
        }
        return ret;
    }

    private static PredicateLogicalOperatorSymbol handleSymbol(CharSequence sequence) {
        switch (CharSequenceHelper.trim(sequence).toString()) {
            case ",": 
            case "and": 
            case "AND": {
                return PredicateLogicalOperatorSymbol.AND;
            }
            case "or": 
            case "OR": {
                return PredicateLogicalOperatorSymbol.OR;
            }
        }
        throw new SdkException(String.format("Unknown symbol %s", sequence));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PredicateComparisonOperatorDto handleOperator(CharSequence sequence, int i) {
        Value value;
        ConditionComparisonOperatorSymbol operator;
        String statement;
        List<CharSequence> split = AqlPathHelper.split(sequence, 0, 3, true, OPERATOR_SYMBOLS);
        if (split.size() == 1) {
            if (i == 0) {
                statement = ARCHETYPE_NODE_ID;
                operator = ConditionComparisonOperatorSymbol.EQ;
                value = PredicateHelper.parseValue(ARCHETYPE_NODE_ID, CharSequenceHelper.trim(split.get(0)));
                return new PredicateComparisonOperatorDto(statement, operator, value);
            } else {
                if (i != 2) throw new IllegalArgumentException();
                statement = NAME_VALUE;
                operator = ConditionComparisonOperatorSymbol.EQ;
                value = PredicateHelper.parseValue(NAME_VALUE, CharSequenceHelper.trim(split.get(0)));
            }
            return new PredicateComparisonOperatorDto(statement, operator, value);
        } else {
            statement = CharSequenceHelper.trim(split.get(0)).toString();
            operator = ConditionComparisonOperatorSymbol.fromSymbol(split.get(1));
            value = PredicateHelper.parseValue(statement, CharSequenceHelper.trim(split.get(2)));
        }
        return new PredicateComparisonOperatorDto(statement, operator, value);
    }

    private static Value parseValue(String statement, CharSequence s) {
        if (s.length() > 0 && s.charAt(0) == '$') {
            ParameterValue parameterValue = new ParameterValue(CharSequenceHelper.subSequence(s, 1).toString(), null);
            return parameterValue;
        }
        if (ARCHETYPE_NODE_ID.equals(statement)) {
            return new SimpleValue(s.toString());
        }
        if (s.length() > 1 && s.charAt(0) == '\'') {
            return new SimpleValue(CharSequenceHelper.subSequence(s, 1, s.length() - 1).toString());
        }
        if (StringUtils.contains((CharSequence)s, (int)46)) {
            return new SimpleValue(Double.parseDouble(s.toString()));
        }
        return new SimpleValue(Long.parseLong(s.toString()));
    }

    private static void format(String statement, StringBuilder sb, Value value) {
        if (value instanceof SimpleValue) {
            Object o = ((SimpleValue)value).getValue();
            if (o instanceof String && !ARCHETYPE_NODE_ID.equals(statement)) {
                sb.append(StringUtils.wrap((String)o.toString(), (String)"'"));
            } else {
                sb.append(o);
            }
        } else if (value instanceof ParameterValue) {
            sb.append('$').append(((ParameterValue)value).getName());
        }
    }

    public static String format(PredicateDto predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        StringBuilder sb = new StringBuilder();
        PredicateHelper.format(sb, predicateDto, otherPredicatesFormat);
        return sb.toString();
    }

    public static void format(StringBuilder sb, PredicateDto predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (predicateDto instanceof ParameterValue) {
            sb.append('$').append(((ParameterValue)predicateDto).getName());
        } else if (predicateDto instanceof PredicateComparisonOperatorDto) {
            PredicateHelper.formatPredicateComparisonOperatorDto(sb, (PredicateComparisonOperatorDto)predicateDto, otherPredicatesFormat);
        } else if (predicateDto instanceof PredicateLogicalAndOperation) {
            PredicateHelper.formatPredicateLogicalAndOperation(sb, (PredicateLogicalAndOperation)predicateDto, otherPredicatesFormat);
        } else if (predicateDto instanceof PredicateLogicalOrOperation) {
            PredicateHelper.formatPredicateLogicalOrOperation(sb, (PredicateLogicalOrOperation)predicateDto, otherPredicatesFormat);
        }
    }

    private static void formatPredicateLogicalOrOperation(StringBuilder sb, PredicateLogicalOrOperation predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (otherPredicatesFormat.equals((Object)AqlPath.OtherPredicatesFormat.SHORTED)) {
            otherPredicatesFormat = AqlPath.OtherPredicatesFormat.FULL;
        }
        List<SimplePredicateDto> values = predicateDto.getValues();
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0 && !PredicateHelper.isNone(values.get(i), otherPredicatesFormat)) {
                sb.append(" or ");
            }
            PredicateHelper.format(sb, values.get(i), otherPredicatesFormat);
        }
    }

    private static void formatPredicateLogicalAndOperation(StringBuilder sb, PredicateLogicalAndOperation predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        SimplePredicateDto[] values = (SimplePredicateDto[])predicateDto.getValues().toArray(SimplePredicateDto[]::new);
        Arrays.sort(values, PREDICATE_DTO_COMPARATOR);
        for (int i = 0; i < values.length; ++i) {
            SimplePredicateDto value = values[i];
            if (PredicateHelper.isNone(value, otherPredicatesFormat)) continue;
            if (i > 0) {
                if (PredicateHelper.isShorten(value, otherPredicatesFormat)) {
                    sb.append(",");
                } else {
                    sb.append(" and ");
                }
            }
            PredicateHelper.format(sb, value, otherPredicatesFormat);
        }
    }

    private static void formatPredicateComparisonOperatorDto(StringBuilder sb, PredicateComparisonOperatorDto predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        if (PredicateHelper.isShorten(predicateDto, otherPredicatesFormat)) {
            PredicateHelper.format(predicateDto.getStatement(), sb, predicateDto.getValue());
        } else if (!PredicateHelper.isNone(predicateDto, otherPredicatesFormat)) {
            sb.append(predicateDto.getStatement()).append(predicateDto.getSymbol().getSymbol());
            PredicateHelper.format(predicateDto.getStatement(), sb, predicateDto.getValue());
        }
    }

    private static boolean isNone(SimplePredicateDto predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        return AqlPath.OtherPredicatesFormat.NONE == otherPredicatesFormat && predicateDto instanceof PredicateComparisonOperatorDto && !ARCHETYPE_NODE_ID.equals(((PredicateComparisonOperatorDto)predicateDto).getStatement());
    }

    private static boolean isShorten(SimplePredicateDto predicateDto, AqlPath.OtherPredicatesFormat otherPredicatesFormat) {
        boolean isCompOp = predicateDto instanceof PredicateComparisonOperatorDto;
        if (isCompOp && ((PredicateComparisonOperatorDto)predicateDto).getStatement().equals(ARCHETYPE_NODE_ID)) {
            return true;
        }
        if (otherPredicatesFormat == AqlPath.OtherPredicatesFormat.FULL) {
            return false;
        }
        if (isCompOp) {
            PredicateComparisonOperatorDto cmpOpDto = (PredicateComparisonOperatorDto)predicateDto;
            return ConditionComparisonOperatorSymbol.EQ == cmpOpDto.getSymbol() && List.of(NAME_VALUE, ARCHETYPE_NODE_ID).contains(cmpOpDto.getStatement());
        }
        if (predicateDto instanceof PredicateLogicalOrOperation) {
            return false;
        }
        if (predicateDto instanceof PredicateLogicalAndOperation) {
            List<SimplePredicateDto> andOpVals = ((PredicateLogicalAndOperation)predicateDto).getValues();
            return CollectionUtils.isNotEmpty(andOpVals) && PredicateHelper.isShorten(andOpVals.get(andOpVals.size() - 1), otherPredicatesFormat);
        }
        return false;
    }

    public static Optional<PredicateComparisonOperatorDto> find(PredicateDto predicateDto, String statement) {
        List<SimplePredicateDto> values;
        if (predicateDto instanceof PredicateComparisonOperatorDto) {
            return Optional.of(predicateDto).map(PredicateComparisonOperatorDto.class::cast).filter(op -> statement.equals(op.getStatement()));
        }
        if (predicateDto instanceof PredicateLogicalOrOperation) {
            values = ((PredicateLogicalOrOperation)predicateDto).getValues();
        } else if (predicateDto instanceof PredicateLogicalAndOperation) {
            values = ((PredicateLogicalAndOperation)predicateDto).getValues();
        } else {
            return Optional.empty();
        }
        for (SimplePredicateDto v : values) {
            PredicateComparisonOperatorDto cmpOp;
            if (!(v instanceof PredicateComparisonOperatorDto) || !statement.equals((cmpOp = (PredicateComparisonOperatorDto)v).getStatement())) continue;
            return Optional.of(cmpOp);
        }
        ArrayDeque<SimplePredicateDto> deque = new ArrayDeque<SimplePredicateDto>(values);
        while (!deque.isEmpty()) {
            List<SimplePredicateDto> values2;
            PredicateDto pred = (PredicateDto)deque.pop();
            if (pred instanceof PredicateLogicalOrOperation) {
                values2 = ((PredicateLogicalOrOperation)pred).getValues();
            } else {
                if (!(pred instanceof PredicateLogicalAndOperation)) continue;
                values2 = ((PredicateLogicalAndOperation)pred).getValues();
            }
            for (SimplePredicateDto v : values2) {
                PredicateComparisonOperatorDto cmpOp;
                if (!(v instanceof PredicateComparisonOperatorDto) || !statement.equals((cmpOp = (PredicateComparisonOperatorDto)v).getStatement())) continue;
                return Optional.of(cmpOp);
            }
            deque.addAll(values2);
        }
        return Optional.empty();
    }

    public static SimplePredicateDto add(SimplePredicateDto simplePredicateDto, SimplePredicateDto add) {
        if (simplePredicateDto instanceof PredicateLogicalAndOperation) {
            return ((PredicateLogicalAndOperation)simplePredicateDto).addValues((Stream)Stream.of(add));
        }
        return new PredicateLogicalAndOperation(simplePredicateDto, add);
    }

    public static PredicateLogicalAndOperation remove(PredicateLogicalAndOperation and, ConditionComparisonOperatorSymbol symbol, String ... remove) {
        return PredicateHelper.removeInternal(and, cmpOp -> (symbol == null || symbol == cmpOp.getSymbol()) && ArrayUtils.contains((Object[])remove, (Object)cmpOp.getStatement()));
    }

    private static <P extends SimplePredicateDto> P removeInternal(P predicate, Predicate<PredicateComparisonOperatorDto> filter) {
        if (predicate instanceof PredicateComparisonOperatorDto) {
            PredicateComparisonOperatorDto cmpOp = (PredicateComparisonOperatorDto)predicate;
            if (filter.test(cmpOp)) {
                return (P)NO_PREDICATE;
            }
            return predicate;
        }
        if (predicate instanceof PredicateLogicalAndOperation) {
            ArrayList<SimplePredicateDto> newValues = null;
            List<SimplePredicateDto> values = ((PredicateLogicalAndOperation)predicate).getValues();
            int newPos = 0;
            int s = values.size();
            for (int i = 0; i < s; ++i) {
                boolean removeNode;
                SimplePredicateDto child = values.get(i);
                SimplePredicateDto newChild = PredicateHelper.removeInternal(child, filter);
                if (newChild == child) continue;
                boolean bl = removeNode = newChild == NO_PREDICATE;
                if (newValues == null) {
                    newValues = new ArrayList<SimplePredicateDto>(removeNode ? s - 1 : s);
                }
                if (i > newPos) {
                    newValues.addAll(values.subList(newPos, i));
                }
                if (!removeNode) {
                    newValues.add(newChild);
                }
                newPos = i + 1;
            }
            if (newPos == 0) {
                return predicate;
            }
            if (newPos < s) {
                newValues.addAll(values.subList(newPos, s));
            }
            return (P)new PredicateLogicalAndOperation((SimplePredicateDto[])newValues.toArray(SimplePredicateDto[]::new));
        }
        return predicate;
    }
}

