/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.aql.condition;

import org.ehrbase.client.aql.condition.Condition;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.field.SelectAqlField;
import org.ehrbase.client.aql.parameter.AqlValue;
import org.ehrbase.client.aql.parameter.Parameter;

public class ComparisonOperator<T>
implements Condition {
    protected final SelectAqlField<T> field;
    protected final AqlValue value;
    protected final Parameter<T> parameter;
    protected final SelectAqlField<T> compareField;
    private final String symbol;

    public ComparisonOperator(String symbol, SelectAqlField<T> field, T value) {
        this.symbol = symbol;
        this.field = field;
        this.value = new AqlValue(value);
        this.parameter = null;
        this.compareField = null;
    }

    public ComparisonOperator(String symbol, SelectAqlField<T> field, Parameter<T> parameter) {
        this.symbol = symbol;
        this.field = field;
        this.parameter = parameter;
        this.value = null;
        this.compareField = null;
    }

    public ComparisonOperator(String symbol, SelectAqlField<T> field, SelectAqlField<T> compereField) {
        this.symbol = symbol;
        this.field = field;
        this.value = null;
        this.parameter = null;
        this.compareField = compereField;
    }

    public static <T> Condition valueComparison(SelectAqlField<T> field, String symbol, T value) {
        return new ComparisonOperator<T>(symbol, field, value);
    }

    public static <T> Condition parameterComparison(SelectAqlField<T> field, String symbol, Parameter<T> parameter) {
        return new ComparisonOperator<T>(symbol, field, parameter);
    }

    public static <T> Condition fieldComparison(SelectAqlField<T> field, String symbol, SelectAqlField<T> compareField) {
        return new ComparisonOperator<T>(symbol, field, compareField);
    }

    @Override
    public String buildAql(Containment ehrContainment) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.field.buildAQL(ehrContainment)).append(" ").append(this.getSymbol()).append(" ");
        if (this.value != null) {
            sb.append(this.value.buildAql());
        } else if (this.parameter != null) {
            sb.append(this.parameter.getAqlParameter());
        } else {
            sb.append(this.compareField.buildAQL(ehrContainment));
        }
        return sb.toString();
    }

    protected String getSymbol() {
        return this.symbol;
    }
}

