/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.dto.path.predicate;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.ehrbase.aql.dto.condition.LogicalOperatorDto;
import org.ehrbase.aql.dto.path.predicate.PredicateDto;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalOperatorSymbol;
import org.ehrbase.aql.dto.path.predicate.SimplePredicateDto;

public class PredicateLogicalOrOperation
implements PredicateDto,
LogicalOperatorDto<PredicateLogicalOperatorSymbol, SimplePredicateDto>,
Serializable {
    private final PredicateLogicalOperatorSymbol symbol = PredicateLogicalOperatorSymbol.OR;
    private List<SimplePredicateDto> values;

    public PredicateLogicalOrOperation(SimplePredicateDto ... values) {
        this.values = List.of(values);
    }

    PredicateLogicalOrOperation() {
        this.values = List.of();
    }

    @Override
    public PredicateLogicalOperatorSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public List<SimplePredicateDto> getValues() {
        return this.values;
    }

    public PredicateLogicalOrOperation addValues(Stream<SimplePredicateDto> valuesStream) {
        SimplePredicateDto[] newValues = (SimplePredicateDto[])Stream.concat(this.values.stream(), valuesStream).toArray(SimplePredicateDto[]::new);
        return new PredicateLogicalOrOperation(newValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateLogicalOrOperation that = (PredicateLogicalOrOperation)o;
        return this.symbol == that.symbol && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.values);
    }

    public String toString() {
        return "PredicateLogicalOrOperation{symbol=" + this.symbol + ", values=" + this.values + "}";
    }
}

