/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.dto.operand;

import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;

public class DoublePrimitive
extends Primitive<Double, DoublePrimitive> {
    private String stringRepresentation;

    public DoublePrimitive() {
    }

    public DoublePrimitive(Double value) {
        super(DoublePrimitive.checkValue(value));
    }

    public DoublePrimitive(String stringRepresentation) {
        super(DoublePrimitive.checkValue(DoublePrimitive.parse(stringRepresentation)));
        this.stringRepresentation = stringRepresentation;
    }

    private static Double checkValue(Double d) throws NumberFormatException {
        if (d != null && (d.isInfinite() || d.isNaN())) {
            throw new NumberFormatException("%s is not supported".formatted(d));
        }
        return d;
    }

    private static Double parse(String s) {
        if (s == null) {
            return null;
        }
        if (!StringUtils.containsOnly((CharSequence)s, (String)"-0123456789eE.")) {
            throw new NumberFormatException("%s does not match REAL, SCI_REAL or SCI_INTEGER definition".formatted(s));
        }
        return Double.valueOf(s);
    }

    @Override
    public void setValue(Double value) {
        super.setValue(DoublePrimitive.checkValue(value));
        this.stringRepresentation = null;
    }

    public String getStringRepresentation() {
        if (this.stringRepresentation == null && this.getValue() != null) {
            this.stringRepresentation = ((Double)this.getValue()).toString();
        }
        return this.stringRepresentation;
    }

    public void setStringRepresentation(String stringRepresentation) {
        this.setValue(DoublePrimitive.checkValue(DoublePrimitive.parse(stringRepresentation)));
        this.stringRepresentation = stringRepresentation;
    }
}

