/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.dto.path;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.path.AdlRegex;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.util.Freezable;

public class ComparisonOperatorPredicate
implements Freezable<ComparisonOperatorPredicate> {
    private AqlObjectPath path;
    private PredicateComparisonOperator operator;
    private PathPredicateOperand<?> value;
    private AdlRegex matchesOperand;
    private boolean frozen = false;

    public ComparisonOperatorPredicate() {
    }

    public ComparisonOperatorPredicate(AqlObjectPath path, PredicateComparisonOperator operator, PathPredicateOperand value) {
        if (ObjectUtils.anyNull((Object[])new Object[]{operator, path, value})) {
            throw new IllegalArgumentException("All constructor arguments are required to not be null");
        }
        if (operator == PredicateComparisonOperator.MATCHES) {
            throw new IllegalArgumentException("Cannot combine MATCHES with PathPredicateOperand");
        }
        this.operator = operator;
        this.path = path;
        this.value = value;
    }

    public static ComparisonOperatorPredicate matches(AqlObjectPath path, AdlRegex value) {
        ComparisonOperatorPredicate p = new ComparisonOperatorPredicate();
        p.setOperator(PredicateComparisonOperator.MATCHES);
        p.setPath(path);
        p.setMatchesOperand(value);
        return p;
    }

    public AqlObjectPath getPath() {
        return this.path;
    }

    public void setPath(AqlObjectPath path) {
        this.path = path;
    }

    public PredicateComparisonOperator getOperator() {
        return this.operator;
    }

    public void setOperator(PredicateComparisonOperator operator) {
        if (operator == PredicateComparisonOperator.MATCHES) {
            this.value = null;
        } else {
            this.matchesOperand = null;
        }
        this.operator = operator;
    }

    public PathPredicateOperand<?> getValue() {
        return this.value;
    }

    public void setValue(PathPredicateOperand<?> value) {
        if (this.operator == PredicateComparisonOperator.MATCHES) {
            throw new IllegalStateException("value cannot be set for a matches predicate");
        }
        this.value = value;
    }

    public AdlRegex getMatchesOperand() {
        return this.matchesOperand;
    }

    public void setMatchesOperand(AdlRegex matchesOperand) {
        if (this.operator != PredicateComparisonOperator.MATCHES) {
            throw new IllegalStateException("matchesOperand can only be set for a matches predicate");
        }
        this.matchesOperand = matchesOperand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonOperatorPredicate that = (ComparisonOperatorPredicate)o;
        return new EqualsBuilder().append((Object)this.operator, (Object)that.operator).append((Object)this.path, (Object)that.path).append(this.value, that.value).append((Object)this.matchesOperand, (Object)that.matchesOperand).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.operator).append((Object)this.path).append(this.value).append((Object)this.matchesOperand).toHashCode();
    }

    public String toString() {
        return "ComparisonOperatorPredicate{path=" + this.path + ", operator=" + this.operator + ", value=" + this.value + ", matchesOperand=" + this.matchesOperand + "}";
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public ComparisonOperatorPredicate frozen() {
        return (ComparisonOperatorPredicate)Freezable.frozen((Freezable)this, t -> {
            ComparisonOperatorPredicate clone = t.clone();
            clone.frozen = true;
            return clone;
        });
    }

    public ComparisonOperatorPredicate clone() {
        return (ComparisonOperatorPredicate)Freezable.clone((Freezable)this, o -> {
            AqlObjectPath path = this.path.clone();
            if (this.operator == PredicateComparisonOperator.MATCHES) {
                return ComparisonOperatorPredicate.matches(path, this.matchesOperand.clone());
            }
            return new ComparisonOperatorPredicate(path, this.operator, (PathPredicateOperand)this.getValue().clone());
        });
    }

    public ComparisonOperatorPredicate thawed() {
        AqlObjectPath path = this.path.thawed();
        if (this.operator == PredicateComparisonOperator.MATCHES) {
            return ComparisonOperatorPredicate.matches(path, this.matchesOperand.thawed());
        }
        return new ComparisonOperatorPredicate(path, this.operator, (PathPredicateOperand)this.getValue().thawed());
    }

    public static enum PredicateComparisonOperator {
        EQ("="),
        NEQ("!="),
        GT_EQ(">="),
        GT(">"),
        LT_EQ("<="),
        LT("<"),
        MATCHES(" matches ");

        private final String symbol;

        private PredicateComparisonOperator(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public static Optional<PredicateComparisonOperator> findBySymbol(String symbol) {
            return Arrays.stream(PredicateComparisonOperator.values()).filter(o -> o.getSymbol().trim().equalsIgnoreCase(symbol)).findFirst();
        }
    }
}

