/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LogicalOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.WhereCondition;
import org.ehrbase.openehr.sdk.aql.dto.operand.Operand;
import org.ehrbase.openehr.sdk.aql.dto.operand.QueryParameter;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.sdk.aql.render.AqlRenderer;

public class AqlUtil {
    private AqlUtil() {
    }

    public static String removeParameter(String aql, String parameterName) {
        AqlQuery dto = AqlQueryParser.parse(aql);
        dto.setWhere(AqlUtil.removeParameter(dto.getWhere(), parameterName));
        return AqlRenderer.render(dto);
    }

    private static WhereCondition removeParameter(WhereCondition condition, String parameterName) {
        if (condition instanceof ComparisonOperatorCondition) {
            Operand value = ((ComparisonOperatorCondition)condition).getValue();
            if (value instanceof QueryParameter && Objects.equals(((QueryParameter)value).getName(), parameterName)) {
                return null;
            }
        } else if (condition instanceof LogicalOperatorCondition) {
            List<WhereCondition> values = ((LogicalOperatorCondition)condition).getValues();
            for (WhereCondition value : new ArrayList<WhereCondition>(values)) {
                values.remove(value);
                WhereCondition newValue = AqlUtil.removeParameter(value, parameterName);
                if (newValue == null) continue;
                values.add(newValue);
            }
            if (values.isEmpty()) {
                return null;
            }
            if (values.size() == 1) {
                return values.get(0);
            }
            return condition;
        }
        return condition;
    }
}

