/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LogicalOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.WhereCondition;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentNotOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperator;
import org.ehrbase.openehr.sdk.aql.dto.operand.Operand;
import org.ehrbase.openehr.sdk.aql.dto.operand.QueryParameter;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;
import org.ehrbase.openehr.sdk.aql.render.AqlRenderer;

public class AqlUtil {
    private AqlUtil() {
    }

    public static String removeParameter(String aql, String parameterName) {
        AqlQuery dto = AqlQueryParser.parse(aql);
        dto.setWhere(AqlUtil.removeParameter(dto.getWhere(), parameterName));
        return AqlRenderer.render(dto);
    }

    private static WhereCondition removeParameter(WhereCondition condition, String parameterName) {
        if (condition instanceof ComparisonOperatorCondition) {
            Operand value = ((ComparisonOperatorCondition)condition).getValue();
            if (value instanceof QueryParameter && Objects.equals(((QueryParameter)value).getName(), parameterName)) {
                return null;
            }
        } else if (condition instanceof LogicalOperatorCondition) {
            List<WhereCondition> values = ((LogicalOperatorCondition)condition).getValues();
            for (WhereCondition value : new ArrayList<WhereCondition>(values)) {
                values.remove(value);
                WhereCondition newValue = AqlUtil.removeParameter(value, parameterName);
                if (newValue == null) continue;
                values.add(newValue);
            }
            if (values.isEmpty()) {
                return null;
            }
            if (values.size() == 1) {
                return values.get(0);
            }
            return condition;
        }
        return condition;
    }

    public static Map<String, AbstractContainmentExpression> containmentExpressionsByIdentifier(Containment containment) {
        return AqlUtil.streamContainmentExpressions(containment).collect(Collectors.toMap(AbstractContainmentExpression::getIdentifier, e -> e));
    }

    private static Stream<AbstractContainmentExpression> streamContainmentExpressions(Containment containment) {
        if (containment == null) {
            return Stream.empty();
        }
        if (containment instanceof AbstractContainmentExpression) {
            AbstractContainmentExpression containmentExp = (AbstractContainmentExpression)containment;
            return Stream.concat(Stream.of(containmentExp).filter(e -> e.getIdentifier() != null), AqlUtil.streamContainmentExpressions(containmentExp.getContains()));
        }
        if (containment instanceof ContainmentSetOperator) {
            ContainmentSetOperator containmentSetOp = (ContainmentSetOperator)containment;
            return containmentSetOp.getValues().stream().flatMap(AqlUtil::streamContainmentExpressions);
        }
        if (containment instanceof ContainmentNotOperator) {
            ContainmentNotOperator containmentNotOp = (ContainmentNotOperator)containment;
            return AqlUtil.streamContainmentExpressions(containmentNotOp.getContainmentExpression());
        }
        throw new IllegalArgumentException("Unsupported class %s".formatted(containment.getClass().getSimpleName()));
    }
}

