/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.webtemplatepath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.ehrbase.openehr.sdk.util.CharSequenceHelper;

public class AqlPathHelper {
    private AqlPathHelper() {
    }

    private static String findPrefix(CharSequence fullPath, int startPos, String ... search) {
        int pathLength = fullPath.length() - startPos;
        for (String s : search) {
            int len = s.length();
            if (len > pathLength || 0 != CharSequenceHelper.compareSubsequence((CharSequence)s, (int)0, (int)len, (CharSequence)fullPath, (int)startPos, (int)(startPos + len))) continue;
            return s;
        }
        return null;
    }

    public static List<CharSequence> split(CharSequence path, int startPos, int max, boolean addSearch, PrefixMatcher matcher) {
        List<CharSequence> strings = null;
        boolean inBrackets = false;
        boolean inQuotes = false;
        boolean escape = false;
        int pathLength = path.length();
        int last = startPos;
        int l = pathLength;
        for (int i = startPos; i < l; ++i) {
            char ch = path.charAt(i);
            if (!inQuotes && ch == '[') {
                inBrackets = true;
                escape = false;
                continue;
            }
            if (!inQuotes && ch == ']') {
                inBrackets = false;
                escape = false;
                continue;
            }
            if (!escape && ch == '\'') {
                inQuotes = !inQuotes;
                continue;
            }
            if (!escape && ch == '\\') {
                escape = true;
                continue;
            }
            if (inBrackets || inQuotes) {
                escape = false;
                continue;
            }
            String prefix = matcher.findPrefix(ch, path, i);
            if (prefix == null) {
                escape = false;
                continue;
            }
            if (strings == null) {
                strings = new ArrayList<CharSequence>(max > 0 && max < 10 ? max : 10);
            }
            strings.add(CharSequenceHelper.subSequence((CharSequence)path, (int)last, (int)i));
            if (addSearch) {
                strings.add(prefix);
            }
            last = prefix.length() + i;
            if (max <= 0 || strings.size() != max - 1) continue;
            strings.add(CharSequenceHelper.subSequence((CharSequence)path, (int)last, (int)pathLength));
            break;
        }
        if (strings == null) {
            strings = List.of(startPos == 0 ? path : CharSequenceHelper.subSequence((CharSequence)path, (int)startPos, (int)pathLength));
        } else if (max <= 0 && last < pathLength) {
            strings.add(CharSequenceHelper.subSequence((CharSequence)path, (int)last, (int)pathLength));
        }
        return strings;
    }

    public static interface PrefixMatcher {
        public static PrefixMatcher forStrings(String ... search) {
            int minChar;
            int[] firstChars = Arrays.stream(search).mapToInt(s -> s.charAt(0)).distinct().sorted().toArray();
            int maxChar = firstChars[firstChars.length - 1];
            if (maxChar - (minChar = firstChars[0]) > 255) {
                return (firstChar, fullString, firstPos) -> {
                    if (ArrayUtils.contains((int[])firstChars, (int)firstChar)) {
                        return AqlPathHelper.findPrefix(fullString, firstPos, search);
                    }
                    return null;
                };
            }
            String[][] charMatches = new String[maxChar - minChar + 1][];
            for (int i = 0; i < firstChars.length; ++i) {
                int ii = i;
                charMatches[firstChars[i] - minChar] = (String[])Arrays.stream(search).filter(s -> s.charAt(0) == firstChars[ii]).toArray(String[]::new);
            }
            return (firstChar, fullString, firstPos) -> {
                if (firstChar >= minChar && firstChar <= maxChar) {
                    String[] searchTerms = charMatches[firstChar - minChar];
                    if (searchTerms == null) {
                        return null;
                    }
                    return AqlPathHelper.findPrefix(fullString, firstPos, searchTerms);
                }
                return null;
            };
        }

        public static PrefixMatcher forChar(char search) {
            String str = Character.toString(search);
            return (firstChar, fullString, firstPos) -> {
                if (firstChar == search) {
                    return str;
                }
                return null;
            };
        }

        public String findPrefix(char var1, CharSequence var2, int var3);
    }
}

