/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.dto.path;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.ehrbase.openehr.sdk.util.Freezable;

public final class AdlRegex
implements Freezable<AdlRegex> {
    private String escapedRegex;
    private boolean frozen = false;

    public AdlRegex(String escapedRegex) {
        this.setEscapedRegex(escapedRegex);
    }

    public String getEscapedRegex() {
        return this.escapedRegex;
    }

    public void setEscapedRegex(String escapedRegex) {
        if (this.frozen) {
            throw new IllegalStateException("%s is immutable".formatted(this.getClass().getSimpleName()));
        }
        if (!escapedRegex.matches("\\{\\s*/.*/\\s*(;\\s*[\"'].*[\"']\\s*)?}")) {
            throw new IllegalArgumentException("invalid ADL regex");
        }
        this.escapedRegex = escapedRegex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdlRegex adlRegex = (AdlRegex)o;
        return new EqualsBuilder().append((Object)this.escapedRegex, (Object)adlRegex.escapedRegex).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.escapedRegex).toHashCode();
    }

    public String toString() {
        return "AdlRegex{escapedRegex='" + this.escapedRegex + "'}";
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public AdlRegex frozen() {
        return (AdlRegex)Freezable.frozen((Freezable)this, t -> {
            AdlRegex clone = t.clone();
            clone.frozen = true;
            return clone;
        });
    }

    public AdlRegex clone() {
        return (AdlRegex)Freezable.clone((Freezable)this, AdlRegex::thawed);
    }

    public AdlRegex thawed() {
        return new AdlRegex(this.getEscapedRegex());
    }
}

